%define qtdir		/usr/lib/qt3
%define kdedir		/opt/kde3
%define vers		1.1pre15
%define rel		suse

Name:			wordtrans
Group:			Applications/Text
URL:			http://wordtrans.sourceforge.net
Summary:		Multi Language Word Translator for Linux
Summary(es):	Traductor multi lenguaje para Linux
Version:		%{vers}
Release:		%{rel}
Vendor:			Ricardo Villalba <rvm@escomposlinux.org>
Copyright:		GPL
BuildRoot:		%{_tmppath}/%{name}-buildroot
Source:			%{name}_%{version}.tar.gz
BuildRequires:	kdelibs3-devel 
BuildRequires:	qt3-devel 
BuildRequires:	XFree86-devel 
BuildRequires:	fribidi-devel
BuildRequires:	glibc-devel
#Requires:       qt3 >= %( echo `rpm -q --queryformat '%{VERSION}' qt3` | cut -b 1-3 )
#Requires:	fribidi >= %( echo `rpm -q --queryformat '%{VERSION}' fribidi` | cut -b 1-6 )


%description
Wordtrans is a front-end for several dictionaries. It supports
some dictionaries in plain text such as i2e (English-Spanish) and
de-en (German-English), dict servers and Babylon Translator's
dictionaries (note that Babylon Translator is a windows shareware
application).

%description -l es
Wordtrans es un front-end para varios diccionarios. Puede emplear
algunos diccionarios de texto como i2e (Ingls-Espaol) y de-en
(Alemn-Ingls), servidores dict y los diccionarios de Babylon
Translator (una aplicacin shareware para Windows).

%package kde
Summary:	KDE front-end for wordtrans
Summary(es):	Front-end de KDE para wordtrans
Group:		Graphical desktop/KDE
Prefix:		%{kdedir}
Requires:	%{name} = %{version}-%{release}
#Requires:       kdelibs3 >= %( echo `rpm -q --queryformat '%{VERSION}' kdelibs3` | cut -b 1-5 )
#Requires:       qt3 >= %( echo `rpm -q --queryformat '%{VERSION}' qt3` | cut -b 1-3 )
#Requires:	fribidi >= %( echo `rpm -q --queryformat '%{VERSION}' fribidi` | cut -b 1-6 )


%description kde
Wordtrans is a front-end for several dictionaries. It supports
some dictionaries in plain text such as i2e (English-Spanish) and
de-en (German-English), dict servers and Babylon Translator's
dictionaries (note that Babylon Translator is a windows shareware
application).

This package contains a KDE front-end for wordtrans.

%description kde -l es
Wordtrans es un front-end para varios diccionarios. Puede emplear
algunos diccionarios de texto como i2e (Ingls-Espaol) y de-en
(Alemn-Ingls), servidores dict y los diccionarios de Babylon
Translator (una aplicacin shareware para Windows).

Este paquete contiene un front-end de KDE para wordtrans.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q -n %{name}-%{version}

# put the application-data in /usr/share/apps, not in /usr/share:
#mv Makefile Makefile.org-appdir
#sed -e 's:/usr/share/wordtrans:/usr/share/apps/wordtrans:g' <Makefile.org-appdir >Makefile

%build

export QTDIR=%{qtdir}
export KDEDIR=%{kdedir}

make KDE3=1 QTLINK=-lqt-mt QT_INC="-I$QTDIR/include" QT_LIB="-L$QTDIR/lib" \
	KDE_INC="-I$KDEDIR/include/" KDE_LIB="-L$KDEDIR/lib" \
	MOC="$QTDIR/bin/moc" CFLAGS="$RPM_OPT_FLAGS -Wall" all

make KDE3=1 QTLINK=-lqt-mt QT_INC="-I$QTDIR/include" QT_LIB="-L$QTDIR/lib" \
	KDE_INC="-I$KDEDIR/include/" KDE_LIB="-L$KDEDIR/lib" \
	MOC="$QTDIR/bin/moc" CFLAGS="$RPM_OPT_FLAGS -Wall" all_kde


%install
rm -rf  $RPM_BUILD_ROOT
%makeinstall DESTDIR=$RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install_kde

# Move wordtrans-web:

install -d $RPM_BUILD_ROOT/srv/www/htdocs/
mv $RPM_BUILD_ROOT/var/www/wordtrans $RPM_BUILD_ROOT/srv/www/htdocs/

# Move kde stuff:

install -d $RPM_BUILD_ROOT/%kdedir/share/applnk/
install -d $RPM_BUILD_ROOT/%kdedir/share/doc/HTML/en
install -d $RPM_BUILD_ROOT/%kdedir/share/doc/HTML/es
install -d $RPM_BUILD_ROOT/%kdedir/share/doc/HTML/fr
install -d $RPM_BUILD_ROOT/%kdedir/share/icons/

mv $RPM_BUILD_ROOT/usr/share/applnk/* $RPM_BUILD_ROOT/%kdedir/share/applnk/
mv $RPM_BUILD_ROOT/usr/share/icons/* $RPM_BUILD_ROOT/%kdedir/share/icons/
ln -sf /usr/share/doc/wordtrans-doc/html.en $RPM_BUILD_ROOT/%kdedir/share/doc/HTML/en/kwordtrans
ln -sf /usr/share/doc/wordtrans-doc/html.es $RPM_BUILD_ROOT/%kdedir/share/doc/HTML/es/kwordtrans
ln -sf /usr/share/doc/wordtrans-doc/html.fr $RPM_BUILD_ROOT/%kdedir/share/doc/HTML/fr/kwordtrans



#(cd $RPM_BUILD_ROOT
#mkdir -p ./usr/lib/menu
#cat > ./usr/lib/menu/%{name}-kde <<EOF
#?package(%{name}-kde):\
#command="%{_bindir}/kwordtrans"\
#title="Kwordtrans"\
#longtitle="Translate utility"\
#needs="x11"\
#icon="kwordtrans.xpm"\
#section="Office/Accessories"
#EOF
#)

#%post
#%update_menus

#%postun
#%update_menus

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%dir %{_sysconfdir}/wordtrans/
%config(noreplace) %{_sysconfdir}/wordtrans/*

%{_bindir}/qwordtrans
%{_bindir}/wordtrans

%dir %_datadir/locale/*/LC_MESSAGES/
%_datadir/locale/*/LC_MESSAGES/wordtrans.mo

%dir %_datadir/wordtrans/
%_datadir/wordtrans/*

%docdir %_datadir/doc/wordtrans-doc/
%doc %_datadir/doc/wordtrans-doc/*
%docdir %_datadir/doc/wordtrans-data/
%doc %_datadir/doc/wordtrans-data/*
%docdir %_datadir/doc/wordtrans-web/
%doc %_datadir/doc/wordtrans-web/*

%doc %{_mandir}/es/man1/qwordtrans.1*
%doc %{_mandir}/es/man1/wordtrans.1*
%doc %{_mandir}/man1/qwordtrans.1*
%doc %{_mandir}/man1/wordtrans.1*

%dir /srv/www/htdocs/wordtrans/
/srv/www/htdocs/wordtrans/*

%files kde
%defattr(-,root,root)

%{_bindir}/kwordtrans

%dir %kdedir/
%kdedir/*

#%_menudir/*

%dir %_datadir/locale/*/LC_MESSAGES/
%_datadir/locale/*/LC_MESSAGES/kwordtrans.mo

%doc %{_mandir}/es/man1/kwordtrans.1*
%doc %{_mandir}/man1/kwordtrans.1*

%doc %kdedir/share/doc/HTML/en/kwordtrans
%doc %kdedir/share/doc/HTML/es/kwordtrans
%doc %kdedir/share/doc/HTML/fr/kwordtrans


%changelog
* Mon Feb 14 2005 Ricardo Villalba <rvm@escomposlinux.org>
- Adapted for SuSE 9.2
* Sun Jan 18 2004 Johan Evenhuis <johan@evenhuis.nl>
- Updated to 1.1pre14 for Mandrake 9.2
* Fri Jan 17 2003 Johan Evenhuis <johan@evenhuis.nl>
- Updated to 1.1pre12 for Mandrake 9.0
* Mon Oct 01 2001 Juan Minaya <jminaya@iname.com> 1.0.1-1
- Release 1.0.1
- Remove unnecessary patches
- Separate KDE frontend (and make it relocatable)

* Mon Apr 30 2001 Juan Minaya <jminaya@iname.com> 1.0beta1-1
- Added description in Spanish.
- Adapt to 1.0beta1 release.
- Clean up %files.

* Thu Mar 08 2001 Juan Minaya <jminaya@iname.com> 0.9-1
- First spec file.

