/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include <qfile.h>
#include <kmessagebox.h>
#include <klocale.h>

class WANetParams
{
public:
        QString iface;
        QString essid;
        //QString mode;
        QString channel;
        QString ap;
        bool wep;
        QString wepMode;
        QString wepKey;

        bool dhcp;
        QString ip;
        QString netmask;
        QString broadcast;
        QString gateway;
        QString domain;
        QString dns1;
        QString dns2;

        bool hiddenEssid;
        bool wasHiddenEssid;
        bool wasWep;

        bool review()
        {
                bool r = false; //DEFAULTS TO 'no review needed'
                if (wep)
                        if ( (wepMode.isEmpty()) || (wepKey.isEmpty()) ) {
                                if (!wasWep) {
                                        KMessageBox::information(0, i18n("<qt><p>The network changed its security settings.</p><p>Please go to <i>Security</i> tab of the following dialog and configure WEP settings.</p></qt>") );
                                } else
                                        KMessageBox::error(0, i18n("<qt><p>Your WEP Key is not set properly.</p><p>Please go to <i>Security</i> tab of the following dialog and enter the required key.</p></qt>") );
                                r = true;
                        }
                if ( (hiddenEssid) && (!wasHiddenEssid) )
                        if ( KMessageBox::questionYesNo(0, i18n("<qt><p>The network has stopped broadcasting its ESSID since the last time you were connected.</p><p>Would you like to use '<b>%1</b>' as an ESSID for this network?</p><p><i>NOTE: If you answer No, a dialog will appear where you will be able to specify a different ESSID.</i></p></qt>").arg(essid) ) != 3 ) // !=YES
                                r = true;

                wasHiddenEssid = hiddenEssid;
                wasWep = wep;
                return r;
        }

        QString netParamsString()
        {
                QStringList mNPS;
                mNPS << boolToString(hiddenEssid) << essid << ap << channel << boolToString(wep) << wepMode << wepKey << boolToString(dhcp) << ip << netmask << broadcast << gateway << domain << dns1 << dns2 << boolToString(wasHiddenEssid) << boolToString(wasWep);
                return mNPS.join(",");
        }

        void loadNetParamsString( const QString & nps )
        {
                /*if (nps.section(",",0,0)=="true")
                        hiddenEssid=true;
                else
                        hiddenEssid=false;*/	// COMMENTED OUT because hiddenEssid boolean is set from the list item
                essid = nps.section(",",1,1);
                ap = nps.section(",",2,2);
                //channel = nps.section(",",3,3);	COMMENTED OUT because channel is set from the list item
                /*if (nps.section(",",4,4)=="true")
                	wep=true;
                else
                	wep=false;*/	// COMMENTED OUT because wep boolean is set from the list item
                wepMode = nps.section(",",5,5);
                wepKey = nps.section(",",6,6);
                if (nps.section(",",7,7)=="true")
                        dhcp=true;
                else
                        dhcp=false;
                ip = nps.section(",",8,8);
                netmask = nps.section(",",9,9);
                broadcast = nps.section(",",10,10);
                gateway = nps.section(",",11,11);
                domain = nps.section(",",12,12);
                dns1 = nps.section(",",13,13);
                dns2 = nps.section(",",14,14);
                if (nps.section(",",15,15)=="true")
                        wasHiddenEssid=true;
                else
                        wasHiddenEssid=false;
                if (nps.section(",",16,16)=="true")
                        wasWep=true;
                else
                        wasWep=false;
        }
private:
        QString boolToString( bool b )
        {
                QString result;
                if ( b )
                        result = "true";
                else
                        result = "false";
                return result;
        }
};

class WACommands
{
public:
        bool allFound;
        QStringList notFound;

        void init()
        {
                QStringList binDirs;
                binDirs << "/sbin" << "/usr/sbin" << "/usr/local/sbin" << "/bin" << "/usr/bin" << "/usr/local/bin";

                dhcp = getPath("dhcpcd", binDirs); //these 2 checks have to be first, so allFound flag is properly set.
                if (dhcp.isEmpty())
                        dhcp = getPath("dhclient", binDirs);
                if (!dhcp.isEmpty()) {
                        allFound=1;
                        dhcpClient = dhcp.section("/",-1,-1);
                        std::cout << "DHCP Client: " << dhcpClient << std::endl;
                }

                ifconfig = getPath("ifconfig", binDirs);
                iwconfig = getPath("iwconfig", binDirs);
                iwlist = getPath("iwlist", binDirs);
                route = getPath("route", binDirs);
                pidof = getPath("pidof", binDirs);

                if (!allFound)
                        std::cout << "Executable(s) not found:" << notFound.join(", ") << std::endl;
                else
                        std::cout << "All executables found." << std::endl;
        }

        QStringList cmd( const QString & action, const WANetParams & np, const bool & quiet = false )
        {
                QStringList mCmd;

                if (action=="ifup")
                        mCmd << ifconfig << np.iface << "up";

                else if (action=="ifdown")
                        mCmd << ifconfig << np.iface << "down";

                else if (action=="iwconfig_status") {
                        mCmd << iwconfig;
                        if (!np.iface.isEmpty())
                        	mCmd << np.iface;

                } else if (action=="ifconfig_status") {
                        mCmd << ifconfig;
                        if (!np.iface.isEmpty())
                        	mCmd << np.iface;

                } else if (action=="radio_on")
                        mCmd << iwconfig << np.iface << "txpower" << "auto";

                else if (action=="radio_off")
                        mCmd << iwconfig << np.iface << "txpower" << "off";

                else if (action=="scan")
                        mCmd << iwlist << np.iface << "scan";

                else if (action=="disconnect")
                        mCmd << iwconfig << np.iface << "mode" << "managed" << "key" << "off" << "ap" << "off" << "essid" << "off";

                else if (action=="iwconfig_set") {
                        mCmd << iwconfig << np.iface << "mode" << "managed" << "channel" << np.channel << "key";
                        if (np.wep)
                                mCmd << np.wepMode << np.wepKey;
                        else
                                mCmd << "off";
			mCmd << "essid" << np.essid;

                } else if (action=="iwconfig_ap") {
                        mCmd << iwconfig << np.iface << "ap" << np.ap;

                } else if (action=="ifconfig_dhcp") {
                        if (dhcpClient=="dhcpcd")
                                mCmd << dhcp << "-nd" << np.iface;
                        else if (dhcpClient=="dhclient")
                                mCmd << dhcp << "-q" << np.iface; // << "-1"

                } else if (action=="kill_dhcp") {
                        if ( dhcpClient=="dhcpcd")	//dhcpcd
                                mCmd << dhcp << "-k" << np.iface;
                        else //dhclient
                                mCmd << dhcp << "-r" << np.iface;

                } else if (action=="ifconfig_manual") {
                        mCmd << ifconfig << np.iface << np.ip;
                        if (!np.netmask.isEmpty())
                                mCmd << "netmask" << np.netmask;
                        if (!np.broadcast.isEmpty())
                                mCmd << "broadcast" << np.broadcast;

                } else if (action=="route") {
                        if (!np.gateway.isEmpty())
                                mCmd << route << "add" << "default" << "gw" << np.gateway;

                } else if (action=="ping_gw") {
                        if (!np.gateway.isEmpty())
                                mCmd << "ping" << "-c" << "1" << "-I" << np.iface << np.gateway;

                } else if (action=="ping_internet") {
                        mCmd << "ping" << "-c" << "1" << "-I" << np.iface << "www.ibiblio.org";

                } else
                        std::cout << "Unknown action: " << action << std::endl;

                if ( (!mCmd.isEmpty()) && (!quiet) ) //mCmd = QStringList();
                        std::cout << action << ": " << mCmd.join(" ") << std::endl;
                return mCmd;
        }

	QString route;
	QString dhcpClient;
private:
        QString ifconfig;
        QString iwconfig;
        QString iwlist;
        QString dhcp;
        QString pidof;

        QString getPath(QString file, QStringList dirs)
        {
                QString s;
                for ( QStringList::Iterator it = dirs.begin(); it != dirs.end(); it++ ) {
                        if (QFile( QString(*it+"/"+file) ).exists()) {
                                s = QString(*it+"/"+file);
                                break;
                        }
                }
                if (s.isEmpty()) {
                        allFound = 0;
                        notFound << file;
                }
                return s;
        }
};
