Robot Testing Framework 2.0.0 (2019-06-03) Release Notes               {#v2_0_0}
========================================================

Important Changes
-----------------

* The RTF acronym is no longer used to avoid conflicts with Rich Text Format.
  Therefore the following changes were applied:
  * The CMake package was changed from `RTF` to `RobotTestingFramework`
    (e.g. `find_package(RobotTestingFramework)`)
  * The CMake target namespace was changed from `RTF` to
    `RobotTestingFramework`. The names of the target are unchanged.
    (e.g. `target_link_libraries(foo PRIVATE RobotTestingFramework::RTF)`
  * The CMake variables were changed from `RTF` to `RobotTestingFramework`
    (e.g. `RobotTestingFramework_INCLUDE_DIRS`)
  * The CMake macros and functions were changed from `rtf` to
    `robottestingframework`
    (e.g. `robottestingframework_add_suite`)
  * The name of the libraries were changed from `RTF*` to
    `robottestingframework*`
    (e.g. `librobottestingframework.so`)
  * The `testrunner` executable was renamed `robottestingframework-testrunner`
  * The include path changed from `rtf` to `robottestingframework`
    (e.g. `#include <robottestingframework/TestCase.h>`)
  * The namespace changed from `RTF` to `robottestingframework`
    (e.g. `robottestingframework::TestCase`)
  * The preprocessor macros `RTF_*` were renamed `ROBOTTESTINGFRAMEWORK_`
    (e.g. `ROBOTTESTINGFRAMEWORK_ASSERT_ERROR("This is an error")`)
  * The module name for script languages was changed from `RTF` to
    `robottestingframework` or `RobotTestingFramework` (language dependent)
    (e.g. `robottestingframework.setName("PythonTestCase")`, and
    `RobotTestingFramework::setName("RubyTestCase")`)
* The `PREPARE_FIXTURE_PLUGIN` macro was renamed
  `ROBOTTESTINGFRAMEWORK_PREPARE_FIXTURE_PLUGIN`
* The `PREPARE_PLUGIN` macro was renamed `ROBOTTESTINGFRAMEWORK_PREPARE_PLUGIN`
* Support for `suit` instead of `suite` was removed.
* The following methods return `std::string` instead of `const std::string`
  * `FixtureManager::getParam`
  * `PluginLoader::getLastError`
  * `TestCase::getParam`
  * `TestCase::getEnvironment`
  * `TestMessage::getMessage`
  * `TestMessage::getDetail`
  * `TestMessage::getSourceFileName`
