#include <errno.h>
#include <fcntl.h>
#include <grp.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <sysexits.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <config.h>
#include <installpaths.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#include <sys/resource.h>

#include "bytecode.h"
#include "db.h"
#include "rlinetd.h"
#include "signals.h"

void main_loop();

int rl_debug = 0;
char *rl_parser = MODULESDIR "/libparse.so";
char *rl_config = SYSCONFDIR "/rlinetd.conf";
char rl_lf[] = "\n";
#ifdef HAVE_GETOPT_LONG
struct option options[] = {
		{ "help", 0, NULL, 'h' },
		{ "debug", 0, NULL, 'd' },
		{ "parser", 1, NULL, 'p' },
		{ "config", 1, NULL, 'f' },
		{ NULL, 0, NULL, 0 }
};
#endif

int main(int argc, char **argv) {
	int i;

#ifdef HAVE_GETOPT
	while((i =
#ifdef HAVE_GETOPT_LONG
				 getopt_long
#else
				 getopt
#endif				 
				 (argc, argv, "p:f:dh"
#ifdef HAVE_GETOPT_LONG
												 , options, NULL
#endif												 
												 )) != -1) {
		switch(i) {
			case 'p':
				rl_parser = optarg;
				break;
			case 'f':
				rl_config = optarg;
				break;
			case 'd':
				rl_debug++;
				break;
			case 'h':
				fprintf(stderr, "%s Version %s\n"
								"Usage %s: [options]\n"
								"\t-p file\t\talternative parser module (default %s)\n"
								"\t-f file\t\talternative config file (default %s)\n"
								"\t-h\t\tthis message\n", PACKAGE, VERSION, argv[0],
								rl_parser, rl_config);
				exit(0);
			default:
				fprintf(stderr, "Unknown option '%c'\n", i);
				exit(EX_USAGE);
		}
	}
#endif	
	if(!rl_debug) {
		switch(fork()) {
			case -1:
				perror("fork");
				exit(EX_OSERR);
			case 0:
				chdir("/");
				setgroups(0, NULL);
				setsid();
				break;
			default:
				exit(0);
		}
	}
	openlog("rlinetd", LOG_NDELAY|LOG_PID, LOG_DAEMON);
	rl_siginit();
	main_loop();
	return 0;
}
