/* Generated by re2c 0.9.12.dev on Wed Dec 28 01:01:19 2005 */
#line 1 "scanner.re"
/* $Id: scanner.re,v 1.20 2005/12/27 23:58:09 helly Exp $ */
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include "scanner.h"
#include "parser.h"
#include "y.tab.h"
#include "globals.h"

extern YYSTYPE yylval;

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#define	BSIZE	8192

#define	YYCTYPE		char
#define	YYCURSOR	cursor
#define	YYLIMIT		lim
#define	YYMARKER	ptr
#define	YYFILL(n)	{cursor = fill(cursor);}

#define	RETURN(i)	{cur = cursor; return i;}

namespace re2c
{

Scanner::Scanner(std::istream& i) : in(i),
	bot(NULL), tok(NULL), ptr(NULL), cur(NULL), pos(NULL), lim(NULL),
	top(NULL), eof(NULL), tchar(0), tline(0), cline(1) {
    ;
}

char *Scanner::fill(char *cursor){
    if(!eof){
	uint cnt = tok - bot;
	if(cnt){
	    memcpy(bot, tok, lim - tok);
	    tok = bot;
	    ptr -= cnt;
	    cursor -= cnt;
	    pos -= cnt;
	    lim -= cnt;
	}
	if((top - lim) < BSIZE){
	    char *buf = new char[(lim - bot) + BSIZE];
	    memcpy(buf, tok, lim - tok);
	    tok = buf;
	    ptr = &buf[ptr - bot];
	    cursor = &buf[cursor - bot];
	    pos = &buf[pos - bot];
	    lim = &buf[lim - bot];
	    top = &lim[BSIZE];
	    delete [] bot;
	    bot = buf;
	}
	if((cnt = in.rdbuf()->sgetn((char*) lim, BSIZE)) != BSIZE){
	    eof = &lim[cnt]; *eof++ = '\0';
	}
	lim += cnt;
    }
    return cursor;
}

#line 77 "scanner.re"


int Scanner::echo(std::ostream &out){
    char *cursor = cur;
    bool ignore_eoc = false;

    // Catch EOF
    if (eof && cursor == eof)
	{
    	return 0;
	}

    tok = cursor;
echo:

#line 85 "scanner.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	goto yy0;
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if(yych <= ')'){
		if(yych <= 0x00)	goto yy7;
		if(yych == 0x0A)	goto yy5;
		goto yy9;
	} else {
		if(yych <= '*')	goto yy4;
		if(yych != '/')	goto yy9;
		goto yy2;
	}
yy2:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '*')	goto yy12;
	goto yy3;
yy3:
#line 123 "scanner.re"
{
					goto echo;
				}
#line 112 "scanner.cc"
yy4:	yych = *++YYCURSOR;
	if(yych == '/')	goto yy10;
	goto yy3;
yy5:	++YYCURSOR;
	goto yy6;
yy6:
#line 112 "scanner.re"
{
					out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					tok = pos = cursor; cline++; oline++;
				  	goto echo;
				}
#line 125 "scanner.cc"
yy7:	++YYCURSOR;
	goto yy8;
yy8:
#line 117 "scanner.re"
{
					out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok) - 1); // -1 so we don't write out the \0
					if(cursor == eof) {
						RETURN(0);
					}
				}
#line 136 "scanner.cc"
yy9:	yych = *++YYCURSOR;
	goto yy3;
yy10:	++YYCURSOR;
	goto yy11;
yy11:
#line 103 "scanner.re"
{
					if (ignore_eoc) {
						ignore_eoc = false;
					} else {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					}
					tok = pos = cursor;
					goto echo;
				}
#line 152 "scanner.cc"
yy12:	yych = *++YYCURSOR;
	if(yych == '!')	goto yy14;
	goto yy13;
yy13:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy3;
	}
yy14:	yych = *++YYCURSOR;
	if(yych == 'm')	goto yy15;
	if(yych == 'r')	goto yy16;
	goto yy13;
yy15:	yych = *++YYCURSOR;
	if(yych == 'a')	goto yy21;
	goto yy13;
yy16:	yych = *++YYCURSOR;
	if(yych != 'e')	goto yy13;
	goto yy17;
yy17:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy13;
	goto yy18;
yy18:	yych = *++YYCURSOR;
	if(yych != 'c')	goto yy13;
	goto yy19;
yy19:	++YYCURSOR;
	goto yy20;
yy20:
#line 92 "scanner.re"
{ 
					out.write((const char*)(tok), (const char*)(&cursor[-7]) - (const char*)(tok));
					tok = cursor;
					RETURN(1);
				}
#line 185 "scanner.cc"
yy21:	yych = *++YYCURSOR;
	if(yych != 'x')	goto yy13;
	goto yy22;
yy22:	yych = *++YYCURSOR;
	if(yych != ':')	goto yy13;
	goto yy23;
yy23:	yych = *++YYCURSOR;
	if(yych != 'r')	goto yy13;
	goto yy24;
yy24:	yych = *++YYCURSOR;
	if(yych != 'e')	goto yy13;
	goto yy25;
yy25:	yych = *++YYCURSOR;
	if(yych != '2')	goto yy13;
	goto yy26;
yy26:	yych = *++YYCURSOR;
	if(yych != 'c')	goto yy13;
	goto yy27;
yy27:	++YYCURSOR;
	goto yy28;
yy28:
#line 97 "scanner.re"
{
					out << "#define YYMAXFILL " << maxFill << std::endl;
					tok = pos = cursor;
					ignore_eoc = true;
					goto echo;
				}
#line 214 "scanner.cc"
}
#line 126 "scanner.re"

}


int Scanner::scan(){
    char *cursor = cur;
    uint depth;

scan:
    tchar = cursor - pos;
    tline = cline;
    tok = cursor;

#line 230 "scanner.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	goto yy29;
	++YYCURSOR;
yy29:
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if(yych <= '/'){
		if(yych <= '"'){
			if(yych <= 0x0A){
				if(yych <= 0x08)	goto yy53;
				if(yych <= 0x09)	goto yy49;
				goto yy51;
			} else {
				if(yych == ' ')	goto yy49;
				if(yych <= '!')	goto yy53;
				goto yy37;
			}
		} else {
			if(yych <= '*'){
				if(yych <= '&')	goto yy53;
				if(yych <= '\'')	goto yy39;
				if(yych <= ')')	goto yy43;
				goto yy35;
			} else {
				if(yych <= '+')	goto yy44;
				if(yych <= '-')	goto yy53;
				if(yych <= '.')	goto yy47;
				goto yy33;
			}
		}
	} else {
		if(yych <= '@'){
			if(yych <= '<'){
				if(yych == ';')	goto yy43;
				goto yy53;
			} else {
				if(yych <= '=')	goto yy43;
				if(yych == '?')	goto yy44;
				goto yy53;
			}
		} else {
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy45;
				if(yych <= '[')	goto yy41;
				if(yych <= '\\')	goto yy43;
				goto yy53;
			} else {
				if(yych <= 'z')	goto yy45;
				if(yych <= '{')	goto yy31;
				if(yych <= '|')	goto yy43;
				goto yy53;
			}
		}
	}
yy31:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ',')	goto yy87;
		goto yy32;
	} else {
		if(yych <= '0')	goto yy84;
		if(yych <= '9')	goto yy85;
		goto yy32;
	}
yy32:
#line 139 "scanner.re"
{ depth = 1;
				  goto code;
				}
#line 302 "scanner.cc"
yy33:	++YYCURSOR;
	if((yych = *YYCURSOR) == '*')	goto yy82;
	goto yy34;
yy34:
#line 169 "scanner.re"
{ RETURN(*tok); }
#line 309 "scanner.cc"
yy35:	++YYCURSOR;
	if((yych = *YYCURSOR) == '/')	goto yy80;
	goto yy36;
yy36:
#line 171 "scanner.re"
{ yylval.op = *tok;
				  RETURN(CLOSE); }
#line 317 "scanner.cc"
yy37:	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != 0x0A)	goto yy76;
	goto yy38;
yy38:
#line 156 "scanner.re"
{ fatal("unterminated string constant (missing \")"); }
#line 325 "scanner.cc"
yy39:	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != 0x0A)	goto yy71;
	goto yy40;
yy40:
#line 157 "scanner.re"
{ fatal("unterminated string constant (missing ')"); }
#line 333 "scanner.cc"
yy41:	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A)	goto yy42;
	if(yych == '^')	goto yy62;
	goto yy60;
yy42:
#line 167 "scanner.re"
{ fatal("unterminated range (missing ])"); }
#line 342 "scanner.cc"
yy43:	yych = *++YYCURSOR;
	goto yy34;
yy44:	yych = *++YYCURSOR;
	goto yy36;
yy45:	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy58;
yy46:
#line 191 "scanner.re"
{ cur = cursor;
				  yylval.symbol = Symbol::find(token());
				  return ID; }
#line 355 "scanner.cc"
yy47:	++YYCURSOR;
	goto yy48;
yy48:
#line 195 "scanner.re"
{ cur = cursor;
				  yylval.regexp = mkDot();
				  return RANGE;
				}
#line 364 "scanner.cc"
yy49:	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy56;
yy50:
#line 200 "scanner.re"
{ goto scan; }
#line 371 "scanner.cc"
yy51:	++YYCURSOR;
	goto yy52;
yy52:
#line 202 "scanner.re"
{ if(cursor == eof) RETURN(0);
				  pos = cursor; cline++;
				  goto scan;
	    			}
#line 380 "scanner.cc"
yy53:	++YYCURSOR;
	goto yy54;
yy54:
#line 207 "scanner.re"
{ std::cerr << "unexpected character: " << *tok << std::endl;
				  goto scan;
				}
#line 388 "scanner.cc"
yy55:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy56;
yy56:	if(yych == 0x09)	goto yy55;
	if(yych == ' ')	goto yy55;
	goto yy50;
yy57:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy58;
yy58:	if(yych <= '@'){
		if(yych <= '/')	goto yy46;
		if(yych <= '9')	goto yy57;
		goto yy46;
	} else {
		if(yych <= 'Z')	goto yy57;
		if(yych <= '`')	goto yy46;
		if(yych <= 'z')	goto yy57;
		goto yy46;
	}
yy59:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy60;
yy60:	if(yych <= '['){
		if(yych != 0x0A)	goto yy59;
		goto yy61;
	} else {
		if(yych <= '\\')	goto yy64;
		if(yych <= ']')	goto yy65;
		goto yy59;
	}
yy61:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy32;
	case 1:	goto yy38;
	case 2:	goto yy40;
	case 3:	goto yy42;
	case 4:	goto yy88;
	}
yy62:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy63;
yy63:	if(yych <= '['){
		if(yych == 0x0A)	goto yy61;
		goto yy62;
	} else {
		if(yych <= '\\')	goto yy67;
		if(yych <= ']')	goto yy68;
		goto yy62;
	}
yy64:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A)	goto yy61;
	goto yy59;
yy65:	++YYCURSOR;
	goto yy66;
yy66:
#line 163 "scanner.re"
{ cur = cursor;
				  yylval.regexp = ranToRE(token());
				  return RANGE; }
#line 454 "scanner.cc"
yy67:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A)	goto yy61;
	goto yy62;
yy68:	++YYCURSOR;
	goto yy69;
yy69:
#line 159 "scanner.re"
{ cur = cursor;
				  yylval.regexp = invToRE(token());
				  return RANGE; }
#line 467 "scanner.cc"
yy70:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy71;
yy71:	if(yych <= '&'){
		if(yych == 0x0A)	goto yy61;
		goto yy70;
	} else {
		if(yych <= '\'')	goto yy73;
		if(yych != '\\')	goto yy70;
		goto yy72;
	}
yy72:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A)	goto yy61;
	goto yy70;
yy73:	++YYCURSOR;
	goto yy74;
yy74:
#line 152 "scanner.re"
{ cur = cursor;
				  yylval.regexp = strToCaseInsensitiveRE(token());
				  return STRING; }
#line 492 "scanner.cc"
yy75:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy76;
yy76:	if(yych <= '!'){
		if(yych == 0x0A)	goto yy61;
		goto yy75;
	} else {
		if(yych <= '"')	goto yy78;
		if(yych != '\\')	goto yy75;
		goto yy77;
	}
yy77:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A)	goto yy61;
	goto yy75;
yy78:	++YYCURSOR;
	goto yy79;
yy79:
#line 148 "scanner.re"
{ cur = cursor;
				  yylval.regexp = strToRE(token());
				  return STRING; }
#line 517 "scanner.cc"
yy80:	++YYCURSOR;
	goto yy81;
yy81:
#line 145 "scanner.re"
{ tok = cursor;
				  RETURN(0); }
#line 524 "scanner.cc"
yy82:	++YYCURSOR;
	goto yy83;
yy83:
#line 142 "scanner.re"
{ depth = 1;
				  goto comment; }
#line 531 "scanner.cc"
yy84:	yych = *++YYCURSOR;
	if(yych == ',')	goto yy98;
	goto yy86;
yy85:	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	goto yy86;
yy86:	if(yych <= '/'){
		if(yych == ',')	goto yy91;
		goto yy61;
	} else {
		if(yych <= '9')	goto yy85;
		if(yych == '}')	goto yy89;
		goto yy61;
	}
yy87:	++YYCURSOR;
	goto yy88;
yy88:
#line 189 "scanner.re"
{ fatal("illegal closure form, use '{n}', '{n,}', '{n,m}' where n and m are numbers"); }
#line 552 "scanner.cc"
yy89:	++YYCURSOR;
	goto yy90;
yy90:
#line 177 "scanner.re"
{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = atoi((char *)tok+1);
				  RETURN(CLOSESIZE); }
#line 560 "scanner.cc"
yy91:	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy88;
	if(yych <= '9')	goto yy94;
	if(yych != '}')	goto yy88;
	goto yy92;
yy92:	++YYCURSOR;
	goto yy93;
yy93:
#line 185 "scanner.re"
{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = -1;
				  RETURN(CLOSESIZE); }
#line 574 "scanner.cc"
yy94:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy95;
yy95:	if(yych <= '/')	goto yy61;
	if(yych <= '9')	goto yy94;
	if(yych != '}')	goto yy61;
	goto yy96;
yy96:	++YYCURSOR;
	goto yy97;
yy97:
#line 181 "scanner.re"
{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = MAX(yylval.extop.minsize,atoi(strchr((char *)tok, ',')+1));
				  RETURN(CLOSESIZE); }
#line 590 "scanner.cc"
yy98:	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy88;
	if(yych <= '9')	goto yy94;
	if(yych != '}')	goto yy88;
	goto yy99;
yy99:	++YYCURSOR;
	goto yy100;
yy100:
#line 174 "scanner.re"
{ yylval.op = '*';
				  RETURN(CLOSE); }
#line 603 "scanner.cc"
}
#line 210 "scanner.re"


code:

#line 610 "scanner.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	goto yy101;
	++YYCURSOR;
yy101:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '&'){
		if(yych <= 0x0A){
			if(yych <= 0x09)	goto yy109;
			goto yy107;
		} else {
			if(yych == '"')	goto yy111;
			goto yy109;
		}
	} else {
		if(yych <= '{'){
			if(yych <= '\'')	goto yy112;
			if(yych <= 'z')	goto yy109;
			goto yy105;
		} else {
			if(yych != '}')	goto yy109;
			goto yy103;
		}
	}
yy103:	++YYCURSOR;
	goto yy104;
yy104:
#line 214 "scanner.re"
{ if(--depth == 0){
					cur = cursor;
					yylval.token = new Token(token(), tline);
					return CODE;
				  }
				  goto code; }
#line 647 "scanner.cc"
yy105:	++YYCURSOR;
	goto yy106;
yy106:
#line 220 "scanner.re"
{ ++depth;
				  goto code; }
#line 654 "scanner.cc"
yy107:	++YYCURSOR;
	goto yy108;
yy108:
#line 222 "scanner.re"
{ if(cursor == eof) fatal("missing '}'");
				  pos = cursor; cline++;
				  goto code;
				}
#line 663 "scanner.cc"
yy109:	++YYCURSOR;
	goto yy110;
yy110:
#line 226 "scanner.re"
{ goto code; }
#line 669 "scanner.cc"
yy111:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A)	goto yy110;
	goto yy118;
yy112:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A)	goto yy110;
	goto yy114;
yy113:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy114;
yy114:	if(yych <= '&'){
		if(yych != 0x0A)	goto yy113;
		goto yy115;
	} else {
		if(yych <= '\'')	goto yy109;
		if(yych == '\\')	goto yy116;
		goto yy113;
	}
yy115:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy110;
	}
yy116:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A)	goto yy115;
	goto yy113;
yy117:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy118;
yy118:	if(yych <= '!'){
		if(yych == 0x0A)	goto yy115;
		goto yy117;
	} else {
		if(yych <= '"')	goto yy109;
		if(yych != '\\')	goto yy117;
		goto yy119;
	}
yy119:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A)	goto yy115;
	goto yy117;
}
#line 227 "scanner.re"


comment:

#line 722 "scanner.cc"
{
	YYCTYPE yych;
	goto yy120;
	++YYCURSOR;
yy120:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= ')'){
		if(yych == 0x0A)	goto yy125;
		goto yy127;
	} else {
		if(yych <= '*')	goto yy122;
		if(yych == '/')	goto yy124;
		goto yy127;
	}
yy122:	++YYCURSOR;
	if((yych = *YYCURSOR) == '/')	goto yy130;
	goto yy123;
yy123:
#line 241 "scanner.re"
{ goto comment; }
#line 744 "scanner.cc"
yy124:	yych = *++YYCURSOR;
	if(yych == '*')	goto yy128;
	goto yy123;
yy125:	++YYCURSOR;
	goto yy126;
yy126:
#line 237 "scanner.re"
{ if(cursor == eof) RETURN(0);
				  tok = pos = cursor; cline++;
				  goto comment;
				}
#line 756 "scanner.cc"
yy127:	yych = *++YYCURSOR;
	goto yy123;
yy128:	++YYCURSOR;
	goto yy129;
yy129:
#line 235 "scanner.re"
{ ++depth;
				  goto comment; }
#line 765 "scanner.cc"
yy130:	++YYCURSOR;
	goto yy131;
yy131:
#line 231 "scanner.re"
{ if(--depth == 0)
					goto scan;
				    else
					goto comment; }
#line 774 "scanner.cc"
}
#line 242 "scanner.re"

}

void Scanner::fatal(char *msg) const
{
    std::cerr << "line " << tline << ", column " << (tchar + 1) << ": "
		<< msg << std::endl;
    exit(1);
}

} // end namespace re2c

