% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_fwf.R
\name{melt_fwf}
\alias{melt_fwf}
\title{Return melted data for each token in a fixed width file}
\usage{
melt_fwf(
  file,
  col_positions,
  locale = default_locale(),
  na = c("", "NA"),
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  n_max = Inf,
  progress = show_progress(),
  skip_empty_rows = FALSE
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_positions}{Column positions, as created by \code{\link[=fwf_empty]{fwf_empty()}},
\code{\link[=fwf_widths]{fwf_widths()}} or \code{\link[=fwf_positions]{fwf_positions()}}. To read in only selected fields,
use \code{\link[=fwf_positions]{fwf_positions()}}. If the width of the last column is variable (a
ragged fwf file), supply the last end position as NA.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}
}
\description{
For certain non-rectangular data formats, it can be useful to parse the data
into a melted format where each row represents a single token.
}
\details{
\code{melt_fwf()} parses each token of a fixed width file into a single row, but
it still requires that each field is in the same in every row of the
source file.
}
\examples{
fwf_sample <- readr_example("fwf-sample.txt")
cat(read_lines(fwf_sample))

# You can specify column positions in several ways:
# 1. Guess based on position of empty columns
melt_fwf(fwf_sample, fwf_empty(fwf_sample, col_names = c("first", "last", "state", "ssn")))
# 2. A vector of field widths
melt_fwf(fwf_sample, fwf_widths(c(20, 10, 12), c("name", "state", "ssn")))
# 3. Paired vectors of start and end positions
melt_fwf(fwf_sample, fwf_positions(c(1, 30), c(10, 42), c("name", "ssn")))
# 4. Named arguments with start and end positions
melt_fwf(fwf_sample, fwf_cols(name = c(1, 10), ssn = c(30, 42)))
# 5. Named arguments with column widths
melt_fwf(fwf_sample, fwf_cols(name = 20, state = 10, ssn = 12))
}
\seealso{
\code{\link[=melt_table]{melt_table()}} to melt fixed width files where each
column is separated by whitespace, and \code{\link[=read_fwf]{read_fwf()}} for the conventional
way to read rectangular data from fixed width files.
}
