% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostage.R
\name{easy.survival.twostage}
\alias{easy.survival.twostage}
\title{Wrapper for easy fitting of Clayton-Oakes or bivariate Plackett models for bivariate survival data}
\usage{
easy.survival.twostage(
  margsurv = NULL,
  data = parent.frame(),
  score.method = "nlminb",
  status = "status",
  time = "time",
  entry = NULL,
  id = "id",
  Nit = 60,
  detail = 0,
  silent = 1,
  weights = NULL,
  control = list(),
  theta = NULL,
  theta.formula = NULL,
  desnames = NULL,
  deshelp = 0,
  var.link = 1,
  step = 0.5,
  model = "plackett",
  marginal.surv = NULL,
  strata = NULL,
  se.clusters = NULL
)
}
\arguments{
\item{margsurv}{model}

\item{data}{data frame}

\item{score.method}{Scoring method}

\item{status}{Status at exit time}

\item{time}{Exit time}

\item{entry}{Entry time}

\item{id}{name of cluster variable in data frame}

\item{Nit}{Number of iterations}

\item{detail}{Detail for more output for iterations}

\item{silent}{Debug information}

\item{weights}{Weights for log-likelihood, can be used for each type of outcome in 2x2 tables.}

\item{control}{Optimization arguments}

\item{theta}{Starting values for variance components}

\item{theta.formula}{design for depedence, either formula or design function}

\item{desnames}{names for dependence parameters}

\item{deshelp}{if 1 then prints out some data sets that are used, on on which the design function operates}

\item{var.link}{Link function for variance (exp link)}

\item{step}{Step size for newton-raphson}

\item{model}{plackett or clayton-oakes model}

\item{marginal.surv}{vector of marginal survival probabilities}

\item{strata}{strata for fitting}

\item{se.clusters}{clusters for iid decomposition for roubst standard errors}
}
\description{
Fits two-stage model for describing depdendence in survival data
using marginals that are on cox or aalen form using the twostage funcion, but
call is different and easier and the data manipulation  build into the function.
Useful in particular for family design data.
}
\details{
If clusters contain more than two times, the algoritm uses a composite likelihood
based on the pairwise bivariate models.

The reported standard errors are based on the estimated information from the
likelihood assuming that the marginals are known.
}
\examples{
library(mets)
data("prt",package="mets")
prtsam <- blocksample(prt,idvar="id",1e3,replace=FALSE)
margp <- coxph(Surv(time,status==1)~factor(country),data=prtsam)
fitco <- survival.twostage(margp,data=prtsam,clusters=prtsam$id)
summary(fitco)

des <- model.matrix(~-1+factor(zyg),data=prtsam);
fitco <- survival.twostage(margp,data=prtsam,theta.des=des,clusters=prtsam$id)
summary(fitco)
rm(prtsam)

dfam <- simSurvFam(1000)
dfam <- fast.reshape(dfam,var=c("x","time","status"))

desfs <- function(x,num1="num1",num2="num2")
{
pp <- (x[num1]=="m")*(x[num2]=="f")*1   ## mother-father
pc <- (x[num1]=="m" | x[num1]=="f")*(x[num2]=="b1" | x[num2]=="b2")*1 ## mother-child
cc <- (x[num1]=="b1")*(x[num2]=="b1" | x[num2]=="b2")*1               ## child-child
c(pp,pc,cc)
}

marg <- coxph(Surv(time,status)~factor(num),data=dfam)
out3 <- easy.survival.twostage(marg,data=dfam,time="time",status="status",id="id",
             deshelp=0,
             score.method="nr",theta.formula=desfs,
             model="plackett",
             desnames=c("parent-parent","parent-child","child-cild"))
summary(out3)

}
\keyword{survival}
\keyword{twostage}
