% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{setSessionVariables}
\alias{setSessionVariables}
\title{Adds variables to a session environment}
\usage{
setSessionVariables(vars, sessionId = NULL, makeDefault = FALSE)
}
\arguments{
\item{vars}{Named list of variables to be added to a session environment. Names are required and 
will be used as variable names.}

\item{sessionId}{ID of the session to which variables should be added. Can also be a vector of
multiple session IDs. If \code{NULL}, then variables will be added to all currently active sessions.}

\item{makeDefault}{If \code{TRUE} then, in addition, the specified variables will be added to each
new opened session as default ones.}
}
\description{
Each client session in \code{jrc}, gets its own environment that can be accessed only by this
session (or from the outside with the \code{\link{getSessionVariable}} function). General purpose
of these environments is to store some session-specific information such as state of the app for
each user. It can also be used to mask variables from the user: if there are two variables with the
same name in the session environment and outside of it, user will not be able to see the latter one.
This function adds new variables to a session environment or changes values of some existing ones.
}
\details{
This function is a wrapper around method \code{sessionVariables} of class \code{\link{Session}}.
If \code{makeDefault = TRUE}, it is also a wrapper around method \code{sessionVariables} of class
\code{\link{App}}. The first one changes the current state of the session environment, while the
second specifies default variables for each new session.
}
\examples{
\donttest{openPage(allowedFunctions = "f", allowedVariables = "res")

m <- 1
f <- function() {v * m}
setSessionVariables(list(v = 1:10, m = 2))

sendCommand("jrc.callFunction('f', [], 'res')", wait = 1)
print(res)

closePage()}

}
\seealso{
\code{\link{getSessionVariable}}.
}
