% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.r
\name{aes}
\alias{aes}
\title{Construct aesthetic mappings}
\usage{
aes(x, y, ...)
}
\arguments{
\item{x, y, ...}{List of name value pairs giving aesthetics to map to
variables. The names for x and y aesthetics are typically omitted because
they are so common; all other aesthetics must be named.}
}
\description{
Aesthetic mappings describe how variables in the data are mapped to visual
properties (aesthetics) of geoms. Aesthetic mappings can be set in
\code{\link{ggplot2}} and in individual layers.
}
\details{
This function also standardise aesthetic names by performing partial
matching, converting color to colour, and translating old style R names to
ggplot names (eg. pch to shape, cex to size)
}
\examples{
aes(x = mpg, y = wt)
aes(mpg, wt)

# You can also map aesthetics to functions of variables
aes(x = mpg ^ 2, y = wt / cyl)

# Aesthetic names are automatically standardised
aes(col = x)
aes(fg = x)
aes(color = x)
aes(colour = x)

# aes is almost always used with ggplot() or a layer
ggplot(mpg, aes(displ, hwy)) + geom_point()
ggplot(mpg) + geom_point(aes(displ, hwy))

# Aesthetics supplied to ggplot() are used as defaults for every layer
# you can override them, or supply different aesthetics for each layer
}
\seealso{
See \code{\link{aes_}} for a version of \code{aes} that is
  more suitable for programming with.
}
