% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_densityDiag}
\alias{ggally_densityDiag}
\title{Univariate density plot}
\usage{
ggally_densityDiag(data, mapping, ..., rescale = FALSE)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used.}

\item{...}{other arguments sent to stat_density}

\item{rescale}{boolean to decide whether or not to rescale the count output}
}
\description{
Displays a density plot for the diagonal of a \code{\link{ggpairs}} plot matrix.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips, package = "reshape")
p_(ggally_densityDiag(tips, mapping = ggplot2::aes(x = total_bill)))
p_(ggally_densityDiag(tips, mapping = ggplot2::aes(x = total_bill, color = day)))
}
\author{
Barret Schloerke
}
\keyword{hplot}
