% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-source.R
\name{source_gist}
\alias{source_gist}
\title{Run a script on gist}
\usage{
source_gist(id, ..., filename = NULL, sha1 = NULL, quiet = FALSE)
}
\arguments{
\item{id}{either full url (character), gist ID (numeric or character of
numeric).}

\item{...}{other options passed to \code{\link[=source]{source()}}}

\item{filename}{if there is more than one R file in the gist, which one to
source (filename ending in '.R')? Default \code{NULL} will source the
first file.}

\item{sha1}{The SHA-1 hash of the file at the remote URL. This is highly
recommend as it prevents you from accidentally running code that's not
what you expect. See \code{\link[=source_url]{source_url()}} for more information on
using a SHA-1 hash.}

\item{quiet}{if \code{FALSE}, the default, prints informative messages.}
}
\description{
\dQuote{Gist is a simple way to share snippets and pastes with others.
All gists are git repositories, so they are automatically versioned,
forkable and usable as a git repository.}
\url{https://gist.github.com/}
}
\examples{
\dontrun{
# You can run gists given their id
source_gist(6872663)
source_gist("6872663")

# Or their html url
source_gist("https://gist.github.com/hadley/6872663")
source_gist("gist.github.com/hadley/6872663")

# It's highly recommend that you run source_gist with the optional
# sha1 argument - this will throw an error if the file has changed since
# you first ran it
source_gist(6872663, sha1 = "54f1db27e60")
# Wrong hash will result in error
source_gist(6872663, sha1 = "54f1db27e61")

#' # You can speficy a particular R file in the gist
source_gist(6872663, filename = "hi.r")
source_gist(6872663, filename = "hi.r", sha1 = "54f1db27e60")
}
}
\seealso{
\code{\link[=source_url]{source_url()}}
}
