% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary.DESeqResults}
\title{Summarize DESeq results}
\usage{
\method{summary}{DESeqResults}(object, alpha, \dots)
}
\arguments{
\item{object}{a \code{\link{DESeqResults}} object}

\item{alpha}{the adjusted p-value cutoff. if not set, this
defaults to the \code{alpha} argument which was used in
\code{\link{results}} to set the target FDR for independent
filtering.}

\item{...}{additional arguments}
}
\description{
Print a summary of the results from a DESeq analysis.
}
\examples{

dds <- makeExampleDESeqDataSet(m=4)
dds <- DESeq(dds)
res <- results(dds)
summary(res)

}
\author{
Michael Love
}

