

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: mcpagoda.hpp,v 1.6 2002/01/16 14:41:40 nando Exp $

#ifndef quantlib_pagoda_pricer_h
#define quantlib_pagoda_pricer_h

#include <ql/Pricers/mcpricer.hpp>
#include <ql/Math/matrix.hpp>
#include <ql/Math/statistics.hpp>
#include <ql/MonteCarlo/mctypedefs.hpp>

namespace QuantLib {

    namespace Pricers {

        //! roofed Asian option
        /*! Given a certain portfolio of assets at the end of the period
            it is returned the minimum of a given roof and a certain fraction
            of the positive portfolio performance.
            If the performance of the portfolio is below then the payoff
            is null.
        */
        class McPagoda : public McPricer<Math::Statistics,
            MonteCarlo::GaussianMultiPathGenerator,
            MonteCarlo::PathPricer<MonteCarlo::MultiPath> > {
          public:
            McPagoda(const Array& portfolio,
                     double fraction,
                     double roof,
                     const Array& dividendYield,
                     const Math::Matrix& covariance,
                     Rate riskFreeRate,
                     const std::vector<Time>& times,
                     bool antithetic,
                     long seed = 0);
        };

    }

}


#endif
