/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


 // HashCorrelation.h: interface for the HashCorrelation class.
//
//////////////////////////////////////////////////////////////////////

#ifndef HASHCORRELATION_H
#define HASHCORRELATION_H

#include <PKI_CERT.h>
#include <mString.h>
#include <ASN1/Asn1Helper.h>
#include "HashCorrelation_ASN1.h"

/*!
  This class handles a correlation of hashes
*/
class HashCorrelation  
{
public:
	/*! \brief This is the constructor.
	 */
	HashCorrelation();

	/*! \brief This is the destructor.
	 */
	virtual ~HashCorrelation();

	/*! \brief This function resets the class.
	 */
	void Clear();

	/*! \brief This function returns the hash in string format.
	 *  \param pem_hash [OUT] The hash in string format.
	 *  \return true on success, false on failure.
	 */
	bool GetHash(mString & pem_hash) const;

	/* \brief This function adds an entry to the hash.
	 * \param id [IN] The ID of the entry.
	 * \param datas [IN] The datas.
	 * \param dataslen [IN] The datas length.
	 * \return true on success, false on failure.
	 */
	bool AddEntry(unsigned long id, const char * datas, int dataslen) const;

	/* \brief This function adds an entry to the hash.
	 * \param id [IN] The ID of the entry.
	 * \param id_len [IN] The ID length.
	 * \param datas [IN] The datas.
	 * \param dataslen [IN] The datas length.
	 * \return true on success, false on failure.
	 */
	bool AddEntry(const char * id, int id_len, const char * datas, int dataslen) const;

	/* \brief This loads the hash.
	 * \param hash [IN] The hash in string format.
	 * \return true on success, false on failure.
	 */
	bool SetCurrentHash(const mString & hash);

	/* \brief This loads the certificate used for the hash signature/verification.
	 * \param cert [IN] The certificate.
	 */
	void SetCert(const PKI_CERT & cert);

	/* \brief This compares two hashes.
	 * \param other [IN] The hash to compare.
	 * \return true when equal, false when different.
	 */
	bool operator==(const HashCorrelation &other);

	/* \brief Is the hash operable.
	 * \param other [IN] The hash to compare.
	 * \return return 1 when hash is operable and 0 when not.
	 */
	operator int();
private:
	char * HashDatas(const char * datas1, int len1, const char * datas2, int len2, int & resultlen) const;
	PKI_CERT m_cert;
	InternalHash ActualHash;
};

#endif
