/***************************** LICENSE START ***********************************

 Copyright 2020 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef DOCHIGHLIGHTER_HPP_
#define DOCHIGHLIGHTER_HPP_

#include <string>
#include <QSyntaxHighlighter>

class DocHighlighter : public QSyntaxHighlighter
{
public:
    DocHighlighter(QTextDocument *parent,QString id);
    static void init();
    void toHtml(QString& html);

protected:
    void highlightBlock(const QString &text) override;
    void addRule(QString,QTextCharFormat);

private:
    void load(QString);
    QColor rgb(QString name) const;

    struct HighlightingRule
    {
        QRegExp pattern;
        QTextCharFormat format;
    };

    QList<HighlightingRule> rules_;
    static std::string parFile_;
};

#endif
