
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileFlagPlottingAttributes.h
    \brief Definition of FlagPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef FlagPlottingAttributes_H
#define FlagPlottingAttributes_H

#include "magics.h"
#include "OriginMarker.h"
#include "CalmIndicator.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class FlagPlottingAttributes 
{
public:
//  --  constructor
    FlagPlottingAttributes();
    
//  --  destructor
    virtual ~FlagPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const FlagPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double calm_indicator_size_;
	double calm_below_;
	bool cross_boundary_;
	double length_;
	double max_speed_;
	double min_speed_;
	double origin_marker_size_;
	int thickness_;
	unique_ptr<CalmIndicator> calm_;
	unique_ptr<Colour> colour_;
	LineStyle style_;
	unique_ptr<OriginMarker> origin_;
	 

private:
	friend ostream& operator<<(ostream& s,const FlagPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

