#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <sys/time.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "support.h"
#include "interface.h"
#include "lopster.h"
#include "global.h"
#include "search.h"
#include "share2.h"
#include "mp3_ext.h"
#include "md5.h"
#include "scheme.h"
#include "callbacks.h"
#include "handler.h"
#include "connection.h"
#include "clist_rename.h"
#include "utils.h"

#define ROW_TOP_YPIXEL(clist, row) (((clist)->row_height * (row)) + \
                                    ((row) + 1) + \
                                    (clist)->voffset)


void on_rename_activate(GtkEditable * editable, gpointer user_data)
{
  char* text;
  clist_rename_t* cr = user_data;
  GtkWidget* win;

  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "activate");
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  cr->new_text = text;

  if (cr->func) cr->func(cr);
  
  // FIXME: free whole cr
  win = gtk_object_get_data(GTK_OBJECT(editable), "win");
  if (win) {
    gtk_widget_destroy(win);
    l_free(cr);
  }
}

gboolean
on_escape_press_event             (GtkWidget       *widget ATTR_UNUSED,
				   GdkEventKey     *event,
				   gpointer         user_data) {
  void *cr;

  if ((event->type == GDK_KEY_PRESS) && (event->keyval == GDK_Escape)) {
    gtk_widget_destroy(GTK_WIDGET(user_data));
    cr = gtk_object_get_data(GTK_OBJECT(user_data), "cr");
    if (cr) l_free(cr);
  }
  return FALSE;
}

void clist_rename(GtkCList* clist, int col, rename_func_t func,
		  void* data, char* old_text) {
  GtkWidget* win;
  GtkWidget* entry;
  int x, y;
  int w, h;
  clist_rename_t* cr;
  int pix_width, height;
  GtkCListRow* row;

  //  row = g_list_nth(clist->row_list, global.popup_row)->data;
  global.popup_row = gtk_clist_find_row_from_data(clist, data);
  if (global.popup_row < 0) return;

  cr = l_malloc(sizeof(clist_rename_t));
  if (!cr) return;
  cr->clist = clist;
  cr->col = col;
  cr->func = func;
  cr->data = data;
  cr->old_text = old_text;
  cr->new_text = NULL;

  win = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_modal (GTK_WINDOW (win), TRUE);
  gtk_window_set_policy(GTK_WINDOW(win), FALSE, FALSE, FALSE);
  gtk_object_set_data(GTK_OBJECT(win), "cr", cr);

  entry = gtk_entry_new ();
  gtk_entry_set_text(GTK_ENTRY(entry), cr->old_text?cr->old_text:"");
  gtk_widget_show(entry);
  gtk_container_add (GTK_CONTAINER (win), entry);
  gtk_entry_select_region(GTK_ENTRY(entry), 0, -1);
  gtk_object_set_data(GTK_OBJECT(entry), "win", win);

  gtk_signal_connect (GTK_OBJECT (entry), "activate",
                      GTK_SIGNAL_FUNC (on_rename_activate),
                      (gpointer)cr);
  gtk_signal_connect (GTK_OBJECT (entry), "key_press_event",
                      GTK_SIGNAL_FUNC (on_escape_press_event),
                      (gpointer)win);
  
  row = g_list_nth(clist->row_list, global.popup_row)->data;

  switch (row->cell[cr->col].type) {
  case GTK_CELL_PIXTEXT:
    gdk_window_get_size (GTK_CELL_PIXTEXT (row->cell[cr->col])->pixmap,
			 &pix_width, &height);
    pix_width += GTK_CELL_PIXTEXT (row->cell[cr->col])->spacing;
    break;
  case GTK_CELL_TEXT:
  default:
    pix_width = 0;
    break;
  }
  //  pix_width += row->cell[cr->col].horizontal;

  gdk_window_get_origin(clist->clist_window, &x, &y);
  x += clist->column[cr->col].area.x + clist->hoffset + pix_width;
  y += ROW_TOP_YPIXEL(clist, global.popup_row);
  w = clist->column[cr->col].area.width - pix_width;
  h = clist->row_height+1;
  
  y -= 3;
  x -= 4;
  gtk_widget_realize(win);
  if (win->window) gdk_window_set_decorations(win->window, 0);
  gtk_widget_set_usize(win, w, -2);

  gtk_widget_set_uposition(win, x, y);
  gtk_widget_show(win);
  //  gtk_window_reposition(GTK_WINDOW(win), x, y);
  gtk_widget_grab_focus(entry);
}
