/* Copyright (C) 2000-2003 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "global.h"
#include "server.h"
#include "support.h"
#include "preferences.h"
#include "callbacks.h"
#include "dirselect.h"
#include "chat.h"
#include "commands.h"
#include "search.h"
#include "transfer.h"
#include "connection.h"
#include "handler.h"
#include "scheme.h"
#include "hotlist.h"
#include "whois.h"
#include "string_list.h"
#include "subscription.h"
#include "browse.h"
#include "resume.h"
#include "about.h"
#include "log.h"
#include "dialog.h"
#include "share2.h"
#include "wizard.h"
#include "statistic.h"
#include "filetips.h"
#include "userinfo.h"
#include "utils.h"
#include "sarray.h"

#define DOUBLE_CLICK(event, row) \
  ((event->type == GDK_2BUTTON_PRESS) && \
  (event->button = 1) && \
  (row >= 0))

static int ev_button = 0;

void check_uploads_again();

///////////////////////////
// CONNECTION
///////////////////////////

void on_connect_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			 gpointer user_data ATTR_UNUSED)
{
  net_group_start_connect(NULL);
}

void on_disconnect_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			    gpointer user_data ATTR_UNUSED)
{
  net_group_disconnect(NULL);
}

void on_preferences_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			     gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (global.options_win) {
    if (global.options_win->window)
      gdk_window_raise(global.options_win->window);
    return;
  } else {
    global.options_win = create_options_win();
    temp = lookup_widget(global.options_win, "ctree2");
    gtk_clist_set_column_auto_resize(GTK_CLIST(temp), 0, TRUE);
  }
  temp = lookup_widget(global.options_win, "text8");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);

  setup_preferences(P_TREE|P_ALL);

  gtk_my_widget_show(global.options_win);
}


void on_exit_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
		      gpointer user_data ATTR_UNUSED)
{
  on_window_delete_event(NULL, NULL, NULL);
}


void on_join_chatrooms_activate(GtkMenuItem * menuitem ATTR_UNUSED,
				gpointer user_data ATTR_UNUSED)
{
}


void on_dir_select29(gchar * dir)
{
  GtkWidget *temp;
  size_t len;

  if (!global.options_win)
    return;
  temp = lookup_widget(global.options_win, "entry14");
  if (dir) {
    if (*dir) {
      len = strlen(dir);
      if (dir[len - 1] == DIR_SEP) dir[len - 1] = 0;
    }
    gtk_entry_set_text(GTK_ENTRY(temp), dir);
  }
}

void on_button29_clicked(GtkButton * button ATTR_UNUSED, 
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser("Select Directory", g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_dir_select29);
  gtk_widget_show(win);
}

void on_button30_clicked(GtkButton * button ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.options_win);
  apply_preferences();
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void on_button31_clicked(GtkButton * button ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}

void on_button33_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void on_chat_close_clicked(GtkButton * button ATTR_UNUSED,
			   gpointer user_data) {
  chat_page_t *page = user_data;
  if (!page) return;
  chat_page_leave(page, NULL);
}

void on_chat_entry_activate(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
#define MAX_HISTORY   1000
  GtkEntry *entry;
  char *text;
  char *pos;

  deactivate_auto_afk();
  entry = GTK_ENTRY(editable);
  text = l_strdup(gtk_entry_get_text(entry));
  if (text[0] == 0) {
    l_free(text);
    return;
  }

  global.chat_history = g_list_append(global.chat_history, l_strdup(text));

  // updating history
  while (g_list_length(global.chat_history) > MAX_HISTORY) {
    pos = g_list_nth_data(global.chat_history, 0);
    l_free(pos);
    global.chat_history = g_list_remove(global.chat_history, pos);
  }
  global.history_pos = g_list_length(global.chat_history);
  
  if (global.afk.message && global.afk.warn_afk)
    client_message("Message", "You are in AFK mode! Type /away to deactivate it.");

  if (text[0] == '/') {
    handle_lopster_command(text);
  } else if (global.current_page) {
    if (!global.current_page->active) {
      client_message("Error", "This page is not active");
    } else {
      if (global.current_page->type == P_PUBLIC) {
	send_public(global.current_page, text);
      } else if (global.current_page->type == P_PRIVATE) {
	send_private(global.current_page->net, 
		     global.current_page->name, text, 1);
      } else if (!strcmp("Wallop", global.current_page->name)) {
	send_wallop(global.current_page->net, text);
      } else if (!strcmp("Global", global.current_page->name)) {
	send_global(global.current_page->net, text);
      }
    }
  }
  l_free(text);
  gtk_entry_set_text(entry, "");
}


void
on_notebook3_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page,
			 gint page_num ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  chat_page_t *page2;

  if (page) {
    page2 = gtk_object_get_data(GTK_OBJECT(page->tab_label), "page");
    if (!page2) return;
    if (global.current_page == page2) return;
  } else page2 = NULL;

  if (global.current_page && global.current_page->tclose) {
    gtk_widget_set_sensitive(global.current_page->tclose, FALSE);
    gtk_widget_hide(global.current_page->tclose);
  }
  
  global.current_page = page2;
  if (global.current_page && global.current_page->tclose) {
    gtk_widget_set_sensitive(global.current_page->tclose, TRUE);
    gtk_widget_show(global.current_page->tclose);
  }
  /*
  if (page2)
    printf("switched to %s %d\n", page2->name, page2->type);
  else
    printf("switched to NULL\n");
  */    
  if (page2) highlight(page2, 0);
  
  temp = lookup_widget(global.win, "label2680");
  gtk_widget_set_style(temp, global.styles[STYLE_TAB1]);

  temp = lookup_widget(global.win, "chat_entry");
  gtk_widget_grab_focus(temp);

  update_status_line();
}


gboolean
on_search_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  GtkCTree* ctree;
  GtkCTreeNode* node;
  file_t* file;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  ctree = GTK_CTREE(widget);
  node = gtk_ctree_node_nth(ctree, row);
  if (node)
    file = gtk_ctree_node_get_row_data(ctree, node);
  else file = NULL;


  if (DOUBLE_CLICK(event, row)) return FALSE;
  /*
  if (DOUBLE_CLICK(event, row)) {
    file = gtk_clist_get_row_data(GTK_CLIST(widget),
				  global.popup_row);
    if (file->net)
      on_download_activate(NULL, NULL);
    else
      play_file(file->longname);
    return FALSE;
  }
  */

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_search_list_popup(file);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return TRUE;
}

//////////////////////////////////////////
// download stuff
void
on_download_selected_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			      gpointer user_data)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  file_t *file;
  search_t* search = user_data;
  char* search_string;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  if (search && search->pattern)
    search_string = search->pattern->include;
  else search_string = NULL;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    file = gtk_ctree_node_get_row_data(ctree, node);
    download_file(file, search_string, NULL);
    row_list = row_list->next;
  }
}

void
on_download_selected_wd_activate(GtkMenuItem * menuitem ATTR_UNUSED,
				 gpointer user_data)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  file_t *file;
  search_t* search = user_data;
  char* search_string;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  if (search && search->pattern)
    search_string = search->pattern->include;
  else search_string = NULL;
  
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    file = gtk_ctree_node_get_row_data(ctree, node);
    download_file(file, search_string, get_last_dir(file->longname));
    row_list = row_list->next;
  }
}

void
on_download_resume_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			    gpointer user_data)
{
  GtkCList *list;
  socket_t *socket;
  file_node_t* node;

  list = GTK_CLIST(global.popup_list);
  node = gtk_clist_get_row_data(list, global.popup_row);
  if (node && node->file && node->file->net) {
    socket = download_create(node->file, user_data, NULL, NULL, 0);
    if (socket) download_start(socket, 0);
  }
}

void on_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCList *clist;
  file_t *file;
  search_t* search = user_data;
  char* search_string;
  
  if (search && search->pattern)
    search_string = search->pattern->include;
  else search_string = NULL;
  
  clist = GTK_CLIST(global.popup_list);
  file = gtk_clist_get_row_data(clist, global.popup_row);
  download_file(file, search_string, NULL);
}

void on_download_wd_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCList *clist;
  file_t *file;
  search_t* search = user_data;
  char* search_string;
  
  if (search && search->pattern)
    search_string = search->pattern->include;
  else search_string = NULL;

  clist = GTK_CLIST(global.popup_list);
  file = gtk_clist_get_row_data(clist, global.popup_row);
  
  download_file(file, search_string, get_last_dir(file->longname));
}


// end download stuff
/////////////////////////////////

//////////////////////////////////////////
// hotlist stuff

void set_prefix(char *prefix, int num)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;

  if (!global.options_win) return;
  if (!prefix) return;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  switch (num) {
  case 0:
    if (scheme->server_prefix)
      l_free(scheme->server_prefix);
    scheme->server_prefix = l_strdup(prefix);
    break;
  case 1:
    if (scheme->client_prefix)
      l_free(scheme->client_prefix);
    scheme->client_prefix = l_strdup(prefix);
    break;
  case 2:
    if (scheme->join_prefix)
      l_free(scheme->join_prefix);
    scheme->join_prefix = l_strdup(prefix);
    break;
  case 3:
    if (scheme->part_prefix)
      l_free(scheme->part_prefix);
    scheme->part_prefix = l_strdup(prefix);
    break;
  }
  scheme_draw(scheme);
}

gboolean
on_online_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, 
			     gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  channel_user_t* user;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;
  
  user = gtk_clist_get_row_data(GTK_CLIST(widget), row);
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);

    pop = create_online_popup(user);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return TRUE;
}

// end hotlist stuff
/////////////////////////////////

/////////////////////////////////
// list stuff
void
on_list_click_column(GtkCList * clist, gint column, gpointer user_data ATTR_UNUSED)
{
  if (column == clist->sort_column) {
    if (clist->sort_type == GTK_SORT_ASCENDING)
      gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
    else
      gtk_clist_set_sort_type(clist, GTK_SORT_ASCENDING);
  } else {
    gtk_clist_set_sort_column(clist, column);
    gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
  }

  gtk_clist_sort(clist);
}

// end list stuff
/////////////////////////////////

void
on_cancel_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t *socket;
  GList* result = NULL;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent != NULL) {
      socket = gtk_ctree_node_get_row_data(ctree, node);
      result = g_list_prepend(result, socket);
    }
  }
  for (row_list = result; row_list; row_list = row_list->next) {
    socket = row_list->data;
    socket_end(socket, S_CANCELED);
  }
  g_list_free(result);
}

void
on_delete_upload_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;
  socket_t *socket;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    socket = gtk_clist_get_row_data(clist, row);
    socket_end(socket, S_DELETE);
  }
}

void on_allow_upload_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			      gpointer user_data ATTR_UNUSED) {
  GtkCList *clist;
  GList *row_list;
  int row;
  socket_t *socket;
  upload_t *upload;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    socket = gtk_clist_get_row_data(clist, row);
    if (socket->type != S_UPLOAD) continue;
    upload = socket->data;
    if (!upload) continue;
    if (upload_in_progress(upload)) continue;
    if (upload->data->status == S_FINISHED) continue;
    upload_start(socket);
  }
}

void on_retry_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t* socket;
  GList* work = NULL;
  GList* dlist;
  download_t* download;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) continue;

    socket = gtk_ctree_node_get_row_data(ctree, node);
    download = socket->data;
    work = g_list_append(work, socket);
  }
  for (dlist = work; dlist; dlist = dlist->next) {
    socket = dlist->data;
    download = socket->data;
    if (download_in_progress(download)) {
      socket_end(socket, S_QUEUED);
    }
    download_start(socket, 0);
  }
  g_list_free(work);
}

void on_force_download_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t* socket;
  GList* work = NULL;
  GList* dlist;
  download_t* download;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) continue;
    
    socket = gtk_ctree_node_get_row_data(ctree, node);
    download = socket->data;
    work = g_list_append(work, socket);
  }
  for (dlist = work; dlist; dlist = dlist->next) {
    socket = dlist->data;
    download = socket->data;
    if (download_in_progress(download)) {
      socket_end(socket, S_QUEUED);
    }
    download_start(socket, 1);
  }
  g_list_free(work);
}

void on_search_artist_activate(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "activate");
  send_search_request(FALSE);
}


void on_search_results_activate(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  send_search_request(FALSE);
}



gboolean
on_chat_entry_key_press_event(GtkWidget * widget,
			      GdkEventKey * event, gpointer user_data ATTR_UNUSED)
{
  GtkEntry *entry;
  char *text;
  char *text2;
  char comm[2048];
  char t[2048];
  GList *c_list;
  int i1;
  command_t *command;
  static int cnt = 0;

  entry = GTK_ENTRY(widget);
  if (event->type == GDK_KEY_PRESS) {
    if ((event->keyval == GDK_r) && (event->state & 8) && 
	(global.user_reply.user)) {
      
      if (global.user_reply.net)
	i1 = g_list_index(global.net_active, 
			  global.user_reply.net);
      else i1 = -1;

      if (i1 >= 0) {
	text = l_strdup_printf("/msg :%d %s ", i1+1,
			       global.user_reply.user);
	gtk_entry_set_text(entry, text);
	l_free(text);
      }
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
      return TRUE;
    } if ((event->keyval == GDK_f) && (event->state & 8)) {
      // help ppl giving a feature request.
      gtk_entry_set_text(entry, "feat req.: ");
    } else if (event->keyval == 65289) {	// tab
      cnt++;
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");

      text = l_strdup(gtk_entry_get_text(entry));

      if (*text == 0) {
	l_free(text);
	return TRUE;
      }
      text2 = strrchr(text, ' ');
      if ((text[0] != '/') || (text2)) {
	if (text2) text2++;
	else text2 = text;

	if (text2[0] == '@')
	  text2++;
	c_list = user_search(text2);

	switch (g_list_length(c_list)) {
	case 0:
	  client_message("Error", "no matching user found");
	  cnt = 0;
	  break;
	case 1:
	  text2[0] = 0;
	  strcpy(t, text);
	  strcat(t, c_list->data);
	  if (!strchr(t, ' '))
	    strcat(t, ": ");
	  gtk_entry_set_text(entry, t);
	  cnt = 0;
	  break;
	default:
	  i1 = calc_list_prefix(c_list);
	  text2[0] = 0;
	  strcpy(t, text);
	  strncat(t, c_list->data, i1);
	  gtk_entry_set_text(entry, t);

	  if (cnt > 1) {
	    client_message(NULL, "Available Users:");
	    *t = 0;
	    for (i1 = 0; i1 < (int)g_list_length(c_list); i1++) {
	      if (i1 > 0)
		strcat(t, ", ");
	      strcat(t, g_list_nth(c_list, i1)->data);
	    }
	    client_message(NULL, t);
	    cnt = 0;
	  }
	  break;
	}
      } else {
	text2 = l_strdup(text + 1);
	c_list = command_search(text2);

	switch (g_list_length(c_list)) {
	case 0:
	  client_message("Error", "no matching command found");
	  cnt = 0;
	  break;
	case 1:
	  command = (command_t *) (c_list->data);
	  sprintf(comm, "/%s ", command->name);
	  gtk_entry_set_text(entry, comm);
	  cnt = 0;
	  break;
	default:
	  i1 = calc_command_prefix(c_list);
	  command = (command_t *) (c_list->data);
	  comm[0] = '/';
	  comm[1] = 0;
	  strncat(comm, command->name, i1);
	  gtk_entry_set_text(entry, comm);

	  if (cnt > 1) {
	    client_message(NULL, "Available Commands:");
	    *t = 0;
	    for (i1 = 0; i1 < (int)g_list_length(c_list); i1++) {
	      if (i1 > 0)
		strcat(t, ", /");
	      else
		strcat(t, "/");
	      command = (command_t *) (g_list_nth(c_list, i1)->data);
	      strcat(t, command->name);
	    }
	    client_message(NULL, t);
	    cnt = 0;
	  }
	  break;
	}
	l_free(text2);
      }
      l_free(text);
    } else if ((event->keyval == 65362) || (event->keyval == 65364)) {
      cnt = 0;
      if (event->keyval == 65362) {	// Up
	if (global.history_pos > 0)
	  global.history_pos--;
	else
	  global.history_pos = 0;
      }
      if (event->keyval == 65364) {	// Down
	if (global.history_pos < (int)g_list_length(global.chat_history))
	  global.history_pos++;
	else
	  global.history_pos = g_list_length(global.chat_history);
      }
      c_list = g_list_nth(global.chat_history, global.history_pos);
      if (c_list) {
	text = c_list->data;
	if (text)
	  gtk_entry_set_text(GTK_ENTRY(widget), text);
      } else {
	gtk_entry_set_text(GTK_ENTRY(widget), "");
      }
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    } else {
      cnt = 0;
    }
  }
  
  text = gtk_entry_get_text(entry);
  if (!l_strcasecmp(text, "/reply") && (event->keyval == 32)) {
    if (global.user_reply.user && global.user_reply.net) {
      int i1 = g_list_index(global.net_active, 
			    global.user_reply.net);
      sprintf(t, "/msg :%d %s", i1+1, global.user_reply.user);
    } else
      sprintf(t, "/msg");
    gtk_entry_set_text(GTK_ENTRY(widget), t);
  }
  if (!l_strcasecmp(text, "/reply ")) {
    if (global.user_reply.user && global.user_reply.net) {
      int i1 = g_list_index(global.net_active, 
			    global.user_reply.net);
      sprintf(t, "/msg :%d %s", i1+1, global.user_reply.user);
    } else
      sprintf(t, "/msg ");
    gtk_entry_set_text(GTK_ENTRY(widget), t);
  }

  return TRUE;
}


void on_whois_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_destroy(global.whois_win);
  global.whois_win = NULL;
}


void on_button82_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.whois_win);
}


gboolean
on_transfer_up_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  GtkCList *clist;
  upload_t *upload = NULL;
  share_t *share = NULL;
  socket_t *socket;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if (DOUBLE_CLICK(event, row)) {
    /*
    printf("event: type %d button %d row %d\n", 
	   event->type, event->button, row);
    */
    on_play_file_activate(NULL, NULL);
    return FALSE;
  }

  if (event->button == global.options.popup_create) {
    clist = GTK_CLIST(global.popup_list);
    socket = gtk_clist_get_row_data(clist, global.popup_row);
    if (socket) {
      if (socket->type == S_UPLOAD)
	upload = socket->data;
      else if (socket->type == S_SHARE)
	share = socket->data;
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    }
    pop = create_upload_popup(upload, share);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return TRUE;
}

/*
void
on_togglebutton2_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkWidget *temp2;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "label125");
  temp2 = lookup_widget(GTK_WIDGET(togglebutton), "entry35");

  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
  }

}
*/

void on_button90_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{

  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


void on_add_to_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  net_user_t* nu = user_data;

  if (nu && nu->user) {
    hotlist_add(nu->user, NULL, 1);
  }
}

void on_whois_user_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (nu && nu->user && nu->net && nu->net->active_server)
    whois_request(nu->net, nu->user, WHOIS_SHOW);
}


void on_ignore_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;
  
  if (!nu || !nu->user) return;

  if (string_list_search(LIST_IGNORE, nu->user)) {
    ignore_remove(nu->user);
  } else {
    ignore_add(nu->user);
  }
}

void on_subscribe_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  net_user_t* nu = user_data;
  subscription_t* sub;

  if (!nu || !nu->user) return;

  sub = subscription_user_search(nu->user);
  if (sub) {
    subscription_user_delete(sub);
  } else {
    subscription_user_add(nu->user);
  }
}

void
on_refresh_users_files_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  hot_t* hot = user_data;
  net_t* net;

  if (!hot || !hot->nets) return;
  net = hot->nets->data;
  browse_user_files(net, hot->user);
}


void
on_remove_user_from_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED,
				     gpointer user_data)
{
  hot_t* hot = user_data;

  if (!hot) return;
  hotlist_remove(hot->user, 1);
}

void
on_remove_from_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (nu && nu->user)
    hotlist_remove(nu->user, 1);
}

void on_download2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCList *clist;
  GList *row_list = user_data;
  file_node_t* bnode;
  int row;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;

  while (row_list) {
    row = (int) row_list->data;
    bnode = gtk_clist_get_row_data(clist, row);
    if (bnode && bnode->file) {
      if (user_data)
	download_file(bnode->file, NULL,
		      get_last_dir(bnode->file->longname));
      else
	download_file(bnode->file, NULL, NULL);
    }
    row_list = row_list->next;
  }

}

void on_button96_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  apply_preferences();
}


void on_combo_entry15_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *temp;
  GtkWidget *temp2;
  scheme_t *scheme1;
  scheme_t *scheme2;
  char *text;
  GList *list2;
  GList *dlist;
  style_t *style;

  win = global.options_win;
  text = gtk_entry_get_text(GTK_ENTRY(editable));

  temp = lookup_widget(global.options_win, "button98");
  temp2 = lookup_widget(global.options_win, "button99");

  scheme1 = gtk_object_get_data(GTK_OBJECT(win), "scheme");

  if ((scheme2 = scheme_load(text)) != NULL) {
    scheme_draw(scheme2);
    if (scheme1) scheme_destroy(scheme1);
    gtk_object_set_data(GTK_OBJECT(win), "scheme", scheme2);
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
    return;
  }

  list2 = NULL;
  temp = lookup_widget(win, "combo5");
  for (dlist = scheme2->colors; dlist; dlist = dlist->next) {
    style = dlist->data;
    list2 = g_list_append(list2, style->name);
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(temp), list2);
  g_list_free(list2);
}

void on_options_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void on_ban_win_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *data;

  temp = lookup_widget(global.ban_win, "clist3");
  data = gtk_object_get_data(object, "channel");
  if (data)
    l_free(data);

  gtk_widget_hide(global.ban_win);
  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


int hex_to_int(char ch)
{
  if ((ch <= '9') && (ch >= '0'))
    return ch - '0';
  else if ((ch <= 'f') && (ch >= 'a'))
    return ch - 'a' + 10;
  else if ((ch <= 'F') && (ch >= 'A'))
    return ch - 'A' + 10;
  else
    return 0;
}

void convert_color(char *text, gdouble * color)
{
  int temp;

  temp = hex_to_int(text[1]) * 16 + hex_to_int(text[2]);
  color[0] = (gdouble) temp / 255.0;
  temp = hex_to_int(text[3]) * 16 + hex_to_int(text[4]);
  color[1] = (gdouble) temp / 255.0;
  temp = hex_to_int(text[5]) * 16 + hex_to_int(text[6]);
  color[2] = (gdouble) temp / 255.0;
}

void on_button94_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *colorsel;
  GtkWidget *temp;
  gdouble color[3];
  char *text;
  scheme_t *scheme;
  style_t *style;

  win = create_colorselectiondialog1();
  gtk_object_set_data(GTK_OBJECT(win), "foreground", (gpointer) 1);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reset");
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Cancel");

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no scheme found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_fore, color);

  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void on_button106_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *colorsel;
  GtkWidget *temp;
  gdouble color[3];
  char *text;
  scheme_t *scheme;
  style_t *style;

  win = create_colorselectiondialog1();
  gtk_object_set_data_full(GTK_OBJECT(win),
			   "foreground", (gpointer) 2, NULL);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reset");
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Cancel");

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_back, color);

  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void on_button107_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *fontsel;
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;
  style_t *style;

  win = create_fontselectiondialog1();

  temp = lookup_widget(win, "NULL_button1");
  gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		     GTK_SIGNAL_FUNC(on_NULL_button1_clicked), NULL);
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Reset");

  temp = lookup_widget(win, "cancel_button3");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), "Cancel");

  temp = lookup_widget(win, "ok_button3");
  gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		     GTK_SIGNAL_FUNC(on_ok_button3_clicked), NULL);


  // setting up font
  fontsel = GTK_FONT_SELECTION_DIALOG(win)->fontsel;
  temp = lookup_widget(global.options_win, "combo_entry13");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }

  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(fontsel),
				   style->n_font);

  gtk_widget_show(win);
}


void
on_colorselectiondialog1_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);
}


void
on_fontselectiondialog1_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);

}


void on_cancel_button3_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  gtk_widget_destroy(temp);

}


void set_color(gdouble * color, int fore)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;
  char color_str[20];
  char hex[17] = "0123456789abcdef";
  int int_val;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (!color) {
    if (fore)
      style_update(scheme, text, "NULL", NULL, NULL);
    else {
      style_update(scheme, text, NULL, "NULL", NULL);
    }
    scheme_draw(scheme);
    return;
  }

  color_str[0] = '#';
  int_val = (int) (color[0] * 255);
  color_str[1] = hex[int_val / 16];
  color_str[2] = hex[int_val % 16];
  int_val = (int) (color[1] * 255);
  color_str[3] = hex[int_val / 16];
  color_str[4] = hex[int_val % 16];
  int_val = (int) (color[2] * 255);
  color_str[5] = hex[int_val / 16];
  color_str[6] = hex[int_val % 16];
  color_str[7] = 0;
  if (fore)
    style_update(scheme, text, color_str, NULL, NULL);
  else
    style_update(scheme, text, NULL, color_str, NULL);

  scheme_draw(scheme);
}

void on_ok_button2_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *colorsel;
  GtkWidget *temp;
  static gdouble color[3];
  gpointer *pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  colorsel = GTK_COLOR_SELECTION_DIALOG(temp)->colorsel;
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }

  gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_destroy(temp);

  switch ((int) pointer) {
  case 1:
    set_color(color, 1);
    break;
  case 2:
    set_color(color, 0);
    break;
  default:
    g_warning("unknown data");
    break;
  }
}


void on_button100_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;

  temp = lookup_widget(global.options_win, "combo_entry15");

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no temp colors found!");
    return;
  }

  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (*text == 0) return;

  if (scheme->name) l_free(scheme->name);
  scheme->name = l_strdup(text);
  scheme_save(scheme);

  // is loaded in prefs (Apply/Ok)
  //  scheme_load(global.colors, text, 0);
}

void set_font(char *font)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (font)
    style_update(scheme, text, NULL, NULL, font);
  else
    style_update(scheme, text, NULL, NULL, "NULL");

  scheme_draw(scheme);
}


void on_ok_button3_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkWidget *fontsel;
  char *font;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  fontsel = GTK_FONT_SELECTION_DIALOG(temp)->fontsel;

  if (gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel))) {
    font =
      l_strdup(gtk_font_selection_get_font_name
	       (GTK_FONT_SELECTION(fontsel)));
    set_font(font);
  }
  gtk_widget_destroy(temp);
}

void on_button_users_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_checkbutton7_toggled(GtkToggleButton * togglebutton, gpointer user_data ATTR_UNUSED)
{

  global.options.show_joins =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));

  setup_preferences(P_SHOW_JOIN);
}


void on_button115_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}

void on_button98_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  scheme_t *scheme1;
  scheme_t *scheme2;

  temp = lookup_widget(global.options_win, "combo_entry15");

  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme1 = scheme_load(text);
  if (!scheme1) {
    l_free(text);
    return;
  }

  scheme2 = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  scheme_destroy(scheme2);
  gtk_object_set_data(GTK_OBJECT(global.options_win), "scheme", scheme1);

  l_free(text);
  scheme_draw(scheme1);
}


void on_button99_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;

  temp = lookup_widget(global.options_win, "combo_entry15");
  text = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme_delete(text);
  l_free(text);
}

void on_play_file_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
			   gpointer user_data ATTR_UNUSED) {
  GtkCList *clist;
  download_t *download;
  upload_t *upload;
  socket_t *socket;

  clist = GTK_CLIST(global.popup_list);

  socket = gtk_clist_get_row_data(clist, global.popup_row);
  if (!socket->data) return;

  if (socket->type == S_UPLOAD) {
    upload = socket->data;
    play_file(upload->file->longname);
  } else if (socket->type == S_DOWNLOAD) {
    download = socket->data;
    if (download->resume)
      play_file(download->resume->filename);
    else
      play_file(download->file->longname);
  }
}

void on_play_file3_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  file_t *file = user_data;

  if (!file) return;
  play_file(file->longname);
}


void on_cancel_button2_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  gtk_widget_destroy(temp);
}

void on_NULL_button2_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  gpointer *pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }
  // color = NULL
  gtk_widget_destroy(temp);

  switch ((int) pointer) {
  case 1:
    set_color(NULL, 1);
    break;
  case 2:
    set_color(NULL, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }

}


void on_NULL_button1_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  set_font(NULL);

  gtk_widget_destroy(temp);

}


void on_private_mode_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;
  
  create_private_page(nu->net, nu->user);
}

void on_whisper_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;
  char *str;
  GtkWidget *temp;
  int num;

  switch_to_page(1);
  
  if (nu->net)
    num = g_list_index(global.net_active, nu->net);
  else return;

  if (num < 0) return;

  temp = lookup_widget(global.win, "chat_entry");
  str = l_strdup_printf("/msg :%d %s ", num+1, nu->user);
  gtk_entry_set_text(GTK_ENTRY(temp), str);
  gtk_widget_grab_focus(temp);
  l_free(str);
}

void on_button133_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  /*
  GtkCList *list;
  int i1;
  transfer_t *transfer;
  socket_t *socket;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t *) (socket->data);
    if (!transfer_in_progress(transfer)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows)
      break;
    socket = (socket_t *) gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t *) (socket->data);
    if ((!transfer_in_progress(transfer))
	|| (transfer->status == S_QUEUED)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  */
}


void on_friend_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  net_user_t* nu = user_data;

  if (nu && nu->user) {
    toggle_friend(nu->user);
  }
}


void on_enemy_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;
  
  if (nu && nu->user) {
    toggle_enemy(nu->user);
  }
}

void on_nodownload_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (nu && nu->user) {
    toggle_nodownload(nu->user);
  }
}

GtkWidget* get_sub_notebook() {
  switch (notebook_page_current()) {
  case 1:
    return lookup_widget(global.win, "notebook3");
  case 2:
    return lookup_widget(global.win, "notebook5");
  case 4:
    return lookup_widget(global.win, "notebook6");
  case 5:
    return lookup_widget(global.win, "notebook9");
  default:
    return NULL;
  }
  return NULL;
}

gboolean
on_window_key_press_event(GtkWidget * widget ATTR_UNUSED,
			  GdkEventKey * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  deactivate_auto_afk();
  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if (event->type == GDK_KEY_PRESS) {
    if ((event->keyval >= 49) &&	// Alt 1-9
	(event->keyval <= 57) && (event->state & 8)) {
      temp = get_sub_notebook();
      if (temp) gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval - 49));
    } else if ((event->keyval >= 49) &&	// CTRL 1-9
	       (event->keyval <= 57) && (event->state & 4)) {
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval - 49));
    } else if ((event->keyval == 97) &&  	// ALT a
	       (event->state & 8)) {
      temp = get_sub_notebook();
      if (temp) gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 115) &&	// ALT s
	       (event->state & 8)) {
      temp = get_sub_notebook();
      if (temp) gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 113) &&	// ALT q
	       (event->state & 8)) {
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 119) &&	// ALT w
	       (event->state & 8)) {
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    } else if (event->keyval == GDK_Page_Up) {	   // page up
      chat_page_up(global.current_page);
    } else if (event->keyval == GDK_Page_Down) {   // page down
      chat_page_down(global.current_page);
    }
  }
  return TRUE;
}

void on_about_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = GTK_WIDGET(object);

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button145_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "about_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_about1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  about_show();
}


void
on_transfer_resize_column(GtkCList * clist,
			  gint column ATTR_UNUSED, gint width ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int i1;
  socket_t *socket;

  i1 = 0;
  while (1) {
    if (i1 >= clist->rows) break;
    socket = gtk_clist_get_row_data(clist, i1);
    if (socket->type == S_DOWNLOAD)
      download_queued_update(socket);
    else if (socket->type == S_UPLOAD)
      upload_update(socket);
    i1++;
  }
}

void on_clear_selected_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCList *clist;
  GList *row_list;
  GtkCTreeNode *node;
  file_t *file;
  search_t* search;

  clist = GTK_CLIST(global.popup_list);
  ctree = GTK_CTREE(global.popup_list);
  search = gtk_object_get_data(GTK_OBJECT(clist), "search");
  gtk_clist_freeze(clist);

  while ((row_list = clist->selection) != NULL) {
    node = GTK_CTREE_NODE(row_list->data);
    file = gtk_ctree_node_get_row_data(ctree, node);
    search_remove_file(ctree, file);
    if (search) 
      sarray_remove_link(search->results, file);
  }
  gtk_clist_thaw(clist);
  search_update_stats(search, 1);
}


void
on_clear_users_files_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  file_t *file;
  char *user;
  search_t *search;
  int i1;

  search = gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");
  if (!search) return;

  clist = GTK_CLIST(global.popup_list);
  file = gtk_clist_get_row_data(clist, global.popup_row);
  user = l_strdup(file->user);

  gtk_clist_freeze(clist);

  for (i1 = 0; i1 < sarray_size(search->results); i1++) {
    file = sarray_item(search->results, i1);
    if (!strcmp(user, file->user)) {
      if (!file->visible) search->invisible--;
      search_remove_file(GTK_CTREE(clist), file);
      sarray_remove(search->results, i1);
      i1--;
    }
  }

  gtk_clist_thaw(clist);
  l_free(user);
  search_update_stats(search, 1);
}


void on_clear_all_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;

  search = gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  search_remove(search);
}

void on_clear_all_searches_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;
  GList* dlist;
  GList* to_remove = NULL;

  for (dlist = global.searches; dlist; dlist = dlist->next) {
    search = dlist->data;
    if (!search) continue;
    if (search->resume) continue;
    to_remove = g_list_prepend(to_remove, search);
  }
  for (dlist = to_remove; dlist; dlist = dlist->next) {
    search = dlist->data;
    search_remove(search);
  }
  g_list_free(to_remove);
}

void on_clear_all_match_activate(GtkMenuItem * menuitem ATTR_UNUSED,
				 gpointer user_data ATTR_UNUSED) {
  search_t *search;
  GList* dlist;
  GList* to_remove = NULL;

  for (dlist = global.searches; dlist; dlist = dlist->next) {
    search = dlist->data;
    if (!search) continue;
    if (search->resume) continue;
    if (sarray_size(search->results) > 0) continue;
    to_remove = g_list_prepend(to_remove, search);
  }
  for (dlist = to_remove; dlist; dlist = dlist->next) {
    search = dlist->data;
    search_remove(search);
  }
  g_list_free(to_remove);
}

void on_search_again_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;

  search = gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");
  if (search) search_queue(search, NULL, 1);
}

void on_search_all_again_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;
  GList* dlist;

  for (dlist = global.searches; dlist; dlist = dlist->next) {
    search = dlist->data;
    if (!search) continue;
    if (search->resume) continue;
    search_queue(search, NULL, 1);
  }
}

void on_client_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.client_win);
  gtk_widget_destroy(global.client_win);
  global.client_win = NULL;
}


void on_button149_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GList *dlist;
  client_t *client;
  net_t* net;

  net = gtk_object_get_data(GTK_OBJECT(global.client_win), "network");
  dlist = global.client_list;
  while (dlist) {
    client = dlist->data;
    l_free(client->info);
    l_free(client);
    dlist = dlist->next;
  }
  g_list_free(global.client_list);
  global.client_list = NULL;

  temp = lookup_widget(global.client_win, "clist8");
  gtk_clist_clear(GTK_CLIST(temp));
  command_send(net, CMD_VERSION_STATS);
}


void on_button150_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.client_win)
    gtk_widget_hide(global.client_win);
}


void on_customize_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCList *clist;
  GtkWidget *win;
  int number = GPOINTER_TO_INT(user_data);
  int* array;

  clist = GTK_CLIST(global.popup_list);
  switch (number) {
  case 1:
    array = global.search_show;
    break;
  case 2:
    array = global.browse_show;
    break;
  case 3:
    array = global.channel_show;
    break;
  case 4:
    array = global.online_show;
    break;
  default:
    array = NULL;
  }
  win = create_customize_win(clist, array);
  gtk_widget_show(win);
}


void on_customize_win_destroy(GtkObject * object, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = GTK_WIDGET(object);
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button1x_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  int i1;
  GtkCList *clist;
  GtkWidget *win;
  GtkToggleButton *tbutton;
  char text[1024];
  int* array;

  win = lookup_widget(GTK_WIDGET(button), "customize_win");
  clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(win), "ref_clist"));
  array = gtk_object_get_data(GTK_OBJECT(win), "ref_array");

  for (i1 = 0; i1 < clist->columns; i1++) {
    sprintf(text, "check%d", i1);
    tbutton = GTK_TOGGLE_BUTTON(lookup_widget(win, text));
    if (gtk_toggle_button_get_active(tbutton)) {
      if (array) array[i1] = 1;
      gtk_clist_set_column_visibility(clist, i1, TRUE);
    } else {
      if (array) array[i1] = 0;
      gtk_clist_set_column_visibility(clist, i1, FALSE);
    }
  }
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button2x_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "customize_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}

void on_button162_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "information_win");
  gtk_widget_destroy(temp);
}

void on_resume_search_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;

  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = gtk_ctree_node_get_row_data(ctree, node);
      resume_search(resume, NULL);
    }
  }
}

void on_resume_play_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  resume_t *resume = user_data;

  if (resume) play_file(resume->filename);
}

void on_resume_delete_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  resume_delete_dialog("Really delete these incomplete files?");
}

void on_resume_cancel_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* to_cancel = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      to_cancel = g_list_append(to_cancel, gtk_ctree_node_get_row_data(ctree, node));
    }
  }
  
  for (dlist = to_cancel; dlist; dlist = dlist->next) {
    resume = dlist->data;
    resume_cancel(resume);
  }
  if (to_cancel) g_list_free(to_cancel);
}

void on_resume_freeze_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* candidates = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);
  if (!ctree) return;

  for (dlist = GTK_CLIST(ctree)->selection; dlist; dlist = dlist->next) {
    node = GTK_CTREE_NODE(dlist->data);
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = gtk_ctree_node_get_row_data(ctree, node);
      candidates = g_list_append(candidates, resume);
    }
  }

  for (dlist = candidates; dlist; dlist = dlist->next) {
    resume = dlist->data;
    resume_freeze(resume);
  }
  g_list_free(candidates);
  resume_save(NULL);
}

void on_resume_thaw_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* candidates = NULL;
  GList* dlist;

  ctree = GTK_CTREE(global.popup_list);
  if (!ctree) return;

  for (dlist = GTK_CLIST(ctree)->selection; dlist; dlist = dlist->next) {
    node = GTK_CTREE_NODE(dlist->data);
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = gtk_ctree_node_get_row_data(ctree, node);
      candidates = g_list_append(candidates, resume);
    }
  }

  for (dlist = candidates; dlist; dlist = dlist->next) {
    resume = dlist->data;
    resume_thaw(resume);
  }
  g_list_free(candidates);
  resume_save(NULL);
}

void on_refresh_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  chat_page_t* page = user_data;
  if (!page) return;
  if (page->type != P_PUBLIC) return;
  if (!page->net || !page->net->active_server) return;
  if (!page->active) return;
  command_send(page->net, CMD_NAMES_LIST, page->name);
}


gboolean
on_clist12_button_press_event(GtkWidget * widget,
			      GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  static net_user_t nu;
  static char user[1000];
  char* text;

  deactivate_auto_afk();
  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;
    if (row == -1) return FALSE;

    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    nu.net = gtk_object_get_data(GTK_OBJECT(global.user_win), "network");
    gtk_clist_get_text(GTK_CLIST(widget), row, 0, &text);
    strcpy(user, text);
    nu.user = user;
    pop = create_user_popup(M_GLOBAL, &nu);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return TRUE;
}

void on_global_users_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
}


void on_user_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_destroy(global.user_win);
  global.user_win = NULL;
}


void on_button164_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  char* args;
  GtkWidget *temp;
  char *text;
  char mode[20];
  int pos = 0;
  net_t* net;

  temp = lookup_widget(global.user_win, "entry74");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  *mode = 0;

  net = 
    gtk_object_get_data(GTK_OBJECT(global.user_win), "network");
  if (!net) return;
  
  temp = lookup_widget(global.user_win, "checkbutton23");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'e';
  temp = lookup_widget(global.user_win, "checkbutton24");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'a';
  temp = lookup_widget(global.user_win, "checkbutton25");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'm';
  temp = lookup_widget(global.user_win, "checkbutton26");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'l';
  temp = lookup_widget(global.user_win, "checkbutton27");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'z';
  temp = lookup_widget(global.user_win, "checkbutton28");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    mode[pos++] = 'c';
  
  if (text && *text) {
    if (*mode) args = l_strdup_printf("%s %s", text, mode);
    else args = l_strdup_printf("%s", text);
  } else {
    if (*mode) args = l_strdup_printf("* %s", mode);
    else args = l_strdup_printf("*");
  }
  show_global_users(net, args);
  l_free(args);
}


void on_button165_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.user_win);
}


void on_spinbutton15_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  int val;
  user_info_t* userinfo;

  temp = lookup_widget(global.win, "spinbutton15");
  userinfo = gtk_object_get_data(GTK_OBJECT(temp), "userinfo");
  if (!userinfo) return;
  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  userinfo->max[0] = val;
}

void on_online_save_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkPaned *paned;
  int i1;

  clist = GTK_CLIST(global.current_page->online);
  for (i1 = 0; i1 < 3; i1++) {
    global.online_width[i1] = clist->column[i1].width;
    global.online_show[i1] = clist->column[i1].visible;
  }

  paned = GTK_PANED(global.current_page->toplevel);
  global.channel_paned = paned->child1_size;
}

void
on_ctree2_tree_select_row(GtkCTree * ctree,
			  GtkCTreeNode * node,
			  gint column, gpointer user_data ATTR_UNUSED)
{
  int row;
  GtkNotebook *notebook;
  GtkWidget *temp;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!global.options_win)
    return;

  notebook = GTK_NOTEBOOK(lookup_widget(global.options_win, "notebook2"));
  row = (int) gtk_ctree_node_get_row_data(ctree, node) - 1;
  if (gtk_notebook_get_current_page(notebook) != row) {
    gtk_notebook_set_page(notebook, row);
    temp = lookup_widget(global.options_win, "label780");
    gtk_ctree_node_get_pixtext(ctree, node, column,
			       &text, &space, &pixmap, &bitmap);

    gtk_label_set_text(GTK_LABEL(temp), text);
  }
}


void
on_notebook2_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page ATTR_UNUSED,
			 gint page_num, gpointer user_data ATTR_UNUSED)
{
  GtkCTree *ctree;
  GtkCTreeNode *node;

  return;
  if (!global.options_win)
    return;

  page_num++;
  ctree = GTK_CTREE(lookup_widget(global.options_win, "ctree2"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, (void *) (page_num));
  gtk_ctree_select(ctree, node);

}


void on_dir_select166(gchar * dir)
{
  GtkWidget *temp;
  size_t len;

  if (!global.options_win)
    return;
  temp = lookup_widget(global.options_win, "entry75");
  if (dir) {
    if (*dir) {
      len = strlen(dir);
      if (dir[len - 1] == DIR_SEP) dir[len - 1] = 0;
    }
    gtk_entry_set_text(GTK_ENTRY(temp), dir);
  }
}

void on_button166_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser("Select Directory", g_get_home_dir(),
			   GTK_SELECTION_SINGLE, on_dir_select166);
  gtk_widget_show(win);
}


void on_button140_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://lopster.sourceforge.net");
}


void on_button139_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://sourceforge.net/project/showfiles.php?group_id=8472");
}


void on_button143_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://lopster.sourceforge.net/?section=cvs");
}


void on_button141_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://sourceforge.net/projects/lopster");
}


void on_button142_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://lopster.sourceforge.net/phpBB2/index.php");
}


void on_button144_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  browse_url("http://lopster.sourceforge.net/phpBB2/viewforum.php?f=2");
}

void on_delete_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
}

void on_button171_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "delete_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void
on_notebook1_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page ATTR_UNUSED,
			 gint page_num, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (page_num == 1) {
    temp = lookup_widget(global.win, "chat_entry");
    gtk_widget_grab_focus(temp);
    temp = lookup_widget(global.win, "label2680");
    gtk_widget_set_style(temp, global.styles[STYLE_TAB1]);
  }
}


void on_log_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  log_show_exit();
}


void on_button173_clicked(GtkButton * button ATTR_UNUSED, 
			  gpointer user_data ATTR_UNUSED)
{
  log_show_exit();
}


void on_logfiles_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  log_show_init();
}


void
on_clist14_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  log_show_session(clist, row);
}


void
on_checkbutton30_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.client_win, "spinbutton19");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

void
on_checkbutton33_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.options_win, "spinbutton32");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

gboolean
on_browse_list_button_event(GtkWidget * widget,
			    GdkEventButton * event, gpointer user_data)
{
  GtkWidget *pop;
  int row, column;
  browse_t* browse = user_data;
  browse_node_t* node;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if (DOUBLE_CLICK(event, row)) return FALSE;

  if (event->button == global.options.popup_create) {
    if (row == -1) {
      pop = create_browse_popup(browse, NULL);
    } else {
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
      node = gtk_clist_get_row_data(GTK_CLIST(widget),
				    global.popup_row);
      
      pop = create_browse_popup(browse, node);
    }
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return TRUE;
}

gboolean
on_clist16_button_press_event(GtkWidget * widget,
			      GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  hot_t* hot;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  hot = gtk_clist_get_row_data(GTK_CLIST(widget), global.popup_row);
  
  if (DOUBLE_CLICK(event, row)) {
    on_refresh_users_files_activate(NULL, hot);
    return TRUE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_hotlist_popup(hot);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return TRUE;
}


void on_browse_files_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (nu && nu->user && nu->net)
    browse_user_files(nu->net, nu->user);
}

void on_dir_select182(gchar * dir)
{
  GtkCList *clist;
  GtkWidget *entry;
  char *mime;
  char *text;
  int i1;
  size_t len;

  if (!global.options_win) return;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist18"));
  entry = lookup_widget(global.options_win, "combo_entry21");
  mime = gtk_entry_get_text(GTK_ENTRY(entry));
  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_text(clist, i1, 0, &text);
    if (!l_strcasecmp(text, mime))
      break;
  }
  if (i1 == clist->rows) return;

  if (dir && *dir) {
    len = strlen(dir);
    if (dir[len - 1] == DIR_SEP) dir[len - 1] = 0;
    gtk_clist_set_text(clist, i1, 1, dir);
  }
}

void on_button182_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser("Select Download Folder", g_get_home_dir(),
			   GTK_SELECTION_EXTENDED, on_dir_select182);
  gtk_widget_show(win);
}


void on_button180_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkWidget *entry;
  char *all_suff;
  char *suff;
  char *mime;
  char *app;
  char *text;
  int i1;

  if (!global.options_win) return;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));

  entry = lookup_widget(global.options_win, "combo_entry20");
  mime = gtk_entry_get_text(GTK_ENTRY(entry));
  if (!mime || !(*mime))
    return;
  strcpy(tstr[1], mime);

  entry = lookup_widget(global.options_win, "entry80");
  all_suff = l_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));

  entry = lookup_widget(global.options_win, "entry82");
  app = gtk_entry_get_text(GTK_ENTRY(entry));
  strcpy(tstr[2], app);

  entry = lookup_widget(global.options_win, "checkbutton55");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(entry)) ||
      !l_strcasecmp("mp3", mime))
    strcpy(tstr[3], "Yes");
  else
    strcpy(tstr[3], "No");

  suff = arg(all_suff, 0);
  while (suff) {
    if (*suff == '.') suff++;
    for (i1 = 0; i1 < clist->rows; i1++) {
      gtk_clist_get_text(clist, i1, 0, &text);
      if (!l_strcasecmp(text, suff))
	break;
    }
    if (i1 == clist->rows) {
      // new entry
      strcpy(tstr[0], suff);
      gtk_clist_append(clist, list);
    } else {
      // update entry
      gtk_clist_set_text(clist, i1, 1, tstr[1]);
      gtk_clist_set_text(clist, i1, 2, tstr[2]);
      gtk_clist_set_text(clist, i1, 3, tstr[3]);
    }
    suff = arg(NULL, 0);
  }
}



void
on_clist17_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *entry;
  char *text;

  if (!global.options_win)
    return;
  gtk_clist_get_text(clist, row, 1, &text);
  entry = lookup_widget(global.options_win, "combo_entry20");
  gtk_entry_set_text(GTK_ENTRY(entry), text);

  gtk_clist_get_text(clist, row, 0, &text);
  entry = lookup_widget(global.options_win, "entry80");
  gtk_entry_set_text(GTK_ENTRY(entry), text);

  gtk_clist_get_text(clist, row, 2, &text);
  entry = lookup_widget(global.options_win, "entry82");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
}

void on_button183_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}


void on_combo_entry17_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  setup_search_fields();
}

void on_changes_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  changes_dialog();
}


void
on_clist18_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *entry;
  char *text;

  if (!global.options_win)
    return;
  gtk_clist_get_text(clist, row, 0, &text);
  entry = lookup_widget(global.options_win, "combo_entry21");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
}


void popup_position(GtkMenu * menu, gint * x, gint * y, gpointer user_data)
{
  GtkRequisition requisition;
  GtkWidget *widget;
  gint screen_width;
  gint screen_height;
      

  if (!user_data)
    return;

  widget = GTK_WIDGET(user_data);

  gdk_window_get_origin(GTK_WIDGET(widget)->window, x, y);

  gtk_widget_size_request(GTK_WIDGET(menu), &requisition);
  screen_width = gdk_screen_width ();
  screen_height = gdk_screen_height ();
  *y -= requisition.height;

  *x = CLAMP (*x, 0, MAX (0, screen_width - requisition.width));
  *y = CLAMP (*y, 0, MAX (0, screen_height - requisition.height));

}


void on_mode_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  int mode = (int) user_data;
  char str[100];
  GList* dlist;
  net_t* net;

  if (mode < 0) return;
  if (mode >= MODE_NUMBER) return;

  for (dlist = global.net_active; dlist; dlist = dlist->next) {
    net = dlist->data;

    if (global.usermode & (1<<mode)) {
      str[0] = '-';
      strcpy(str+1, ModeNames[mode]);
    } else {
      if (net->subtype == N_OPENNAP ||
	  net->subtype == N_OPENNAP_NG) {
	strcpy(str, ModeNames[mode]);
      } else {
	str[0] = '+';
	strcpy(str+1, ModeNames[mode]);
      }
    }
    command_send(net, CMD_SET_USER_MODE, str);
  }
  if (global.usermode & (1<<mode)) {
    global.usermode &= ~(1<<mode);
  } else {
    global.usermode |= (1<<mode);
  }
}

void on_button186_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  char *channel;
  GList *row_list;
  char *user;
  char *ip;
  int row;
  net_t* net;
  char str[1024];

  if (!global.ban_win) return;

  clist = GTK_CLIST(lookup_widget(global.ban_win, "clist3"));
  channel = gtk_object_get_data(GTK_OBJECT(global.ban_win), "channel");
  net = gtk_object_get_data(GTK_OBJECT(global.ban_win), "network");
  if (!net || !net->active_server) return;

  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_get_text(clist, row, 0, &user);
    if (net->subtype == N_SLAVANAP)
      gtk_clist_get_text(clist, row, 0, &ip);
    else ip = NULL;

    if (ip)
      sprintf(str, "%s!%s", user, ip);
    else
      strcpy(str, user);
    if (channel) {
      command_send(net, CMD_CHAN_UNBAN, channel, str, NULL);
    } else {
      command_send(net, CMD_UNBAN, user, NULL);
    }
    gtk_clist_remove(clist, row);
  }
}


void
on_checkbutton16_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.options_win, "spinbutton34");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

void on_kill_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;
  
  if (!nu || !nu->user || !nu->net) return;
  command_send(nu->net, CMD_KILL, nu->user, NULL);
}

void on_locate_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (!nu || !nu->user) return;
  
  command_send(NULL, CMD_WHICH_SERVER, nu->user);
}

void on_send_file_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (nu && nu->user && nu->net)
    dcc_select_file(nu->user, nu->net);
}

void on_nuke_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;
  
  if (!nu || !nu->user || !nu->net) return;
  command_send(nu->net, CMD_NUKE, nu->user);
}

void on_muzzle_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (!nu || !nu->user || !nu->net) return;
  command_send(nu->net, CMD_MUZZLE, nu->user, NULL);
}

void on_chmuzzle_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (!nu || !nu->user || !nu->net) return;

  command_send(nu->net, CMD_CHAN_MUZZLE,
	       global.current_page->name, nu->user, NULL);
}

void on_chban_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (!nu || !nu->user || !nu->net) return;

  command_send(nu->net, CMD_CHAN_BAN,
	       global.current_page->name, nu->user, NULL);
}

void on_kick_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (!nu || !nu->user || !nu->net) return;

  command_send(nu->net, CMD_KICK,
	       global.current_page->name, nu->user, NULL);
}


void popup_position2(GtkMenu * menu, gint * x,
		     gint * y, gpointer user_data)
{
  GtkRequisition requisition;
  GtkWidget *widget;
  gint screen_width;
  gint screen_height;

  if (!user_data)
    return;

  widget = GTK_WIDGET(user_data);

  gdk_window_get_origin(GTK_WIDGET(widget)->window, x, y);

  *y += widget->allocation.height;

  gtk_widget_size_request(GTK_WIDGET(menu), &requisition);
  screen_width = gdk_screen_width();
  screen_height = gdk_screen_height();

  *x = CLAMP(*x, 0, MAX(0, screen_width - requisition.width));
  *y = CLAMP(*y, 0, MAX(0, screen_height - requisition.height));
}

void on_safe_exit_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.status.exiting = E_SAFE;
  if (global.limit.cur_uploads + global.limit.cur_downloads > 0) {
    client_message("Safe exit", "Waiting for %d downloads to be finished",
		   global.limit.cur_downloads);
  }
}


gboolean
on_window_focus_in_event(GtkWidget * widget,
			 GdkEventFocus * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = (chat_page_t *) gtk_object_get_data(GTK_OBJECT(widget),
					     "channel");
  global.current_page = page;
  return TRUE;
}


gboolean
on_window_focus_out_event(GtkWidget * widget ATTR_UNUSED,
			  GdkEventFocus * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = chat_page_get_current_main();
  if (!page) return FALSE;
  global.current_page = page;
  return TRUE;
}

void on_chat_destroy(GtkWidget * window ATTR_UNUSED, gpointer user_data)
{
  chat_page_t *page;

  page = gtk_object_get_data(GTK_OBJECT(user_data), "channel");

  if (page)
    chat_page_attach_to_main(page);
}

void on_chat_leave_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  chat_page_t *page = (chat_page_t *) user_data;

  chat_page_leave(page, NULL);
}

void on_chat_attach_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  chat_page_t *page = (chat_page_t *) user_data;

  gtk_widget_destroy(page->window);
}

void on_button191_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  chat_page_t *page;

  page = chat_page_get_current_main();
  if (!page)
    return;
  chat_page_attach_to_new(page);
}

GtkWidget *create_tab_label(int no)
{
  GtkWidget *hbox;
  GtkWidget *temp;

  switch (no) {
  case 0:
    hbox = lookup_widget(global.win, "hbox216");
    temp = lookup_widget(global.win, "detach_server");
    break;
  case 1:
    hbox = lookup_widget(global.win, "hbox1");
    temp = lookup_widget(global.win, "detach_chat");
    break;
  case 2:
    hbox = lookup_widget(global.win, "hbox7");
    temp = lookup_widget(global.win, "detach_library");
    break;
  case 3:
    hbox = lookup_widget(global.win, "hbox18");
    temp = lookup_widget(global.win, "detach_search");
    break;
  case 4:
    hbox = lookup_widget(global.win, "hbox294");
    temp = lookup_widget(global.win, "detach_hotlist");
    break;
  case 5:
    hbox = lookup_widget(global.win, "hbox22");
    temp = lookup_widget(global.win, "detach_downloads");
    break;
  case 6:
    hbox = lookup_widget(global.win, "hbox419");
    temp = lookup_widget(global.win, "detach_uploads");
    break;
  case 7:
  default:
    hbox = lookup_widget(global.win, "hbox657");
    temp = lookup_widget(global.win, "detach_statistic");
    break;
  }

  if (temp)
    gtk_widget_set_sensitive(temp, TRUE);

  return hbox;
}

gboolean
on_extra_win_delete(GtkWidget * widget,
		    GdkEvent * event ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *win;
  GtkWidget *temp;
  GtkWidget *tab_label;
  GtkNotebook *notebook;
  int no;
  int i1;
  int pos;

  win = widget;
  no = (int) user_data;

  // getting geometry
  if (win->window) {
    gdk_window_get_origin(win->window,
			  &global.geometry[no].x, &global.geometry[no].y);
  }
  global.geometry[no].width = win->allocation.width;
  global.geometry[no].height = win->allocation.height;

  temp = GTK_BIN(win)->child;
  if (!temp)
    return FALSE;

  gtk_widget_ref(temp);
  gtk_container_remove(GTK_CONTAINER(win), temp);

  pos = 0;
  for (i1 = 0; i1 < no; i1++)
    if ((global.extra_win & (1 << i1)) == 0)
      pos++;
  global.extra_win &= (0xFF) ^ (1 << no);

  tab_label = create_tab_label(no);
  gtk_widget_show(tab_label);

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook1"));
  gtk_notebook_insert_page(notebook, temp, tab_label, pos);
  gtk_widget_unref(temp);

  return TRUE;
}

gboolean
on_text_button_press_event(GtkWidget * widget,
			   GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop = NULL;
  guint index;
  word_info_t* winfo;
  static GList* net_list = NULL;

  deactivate_auto_afk();
  if (event->button == global.options.popup_create) {
    index = GTK_TEXT(widget)->cursor_mark.index;
    // get_word result is static string, so we dont need to
    // allocate mem here.
    winfo = text_get_info(widget, index);
    gtk_grab_remove(widget);
    pop = NULL;
    if (!winfo) {
      /*
      if (global.current_page && global.current_page->server) {
	sn.server = global.current_page->server;
	if (server_online(sn.server) != -1)
	  sn.net = sn.server->net;
	else sn.net = NULL;
	winfo2.data = &sn;
	pop = create_server3_popup(&winfo2);
      }
      */
    } else if (winfo->type == TEXT_USER) {
      net_user_t* nu = winfo->data;
      pop = create_user_popup(M_TEXT, nu);
    } else if (winfo->type == TEXT_FILE) {
      pop = create_file_popup(winfo);
    } else if (winfo->type == TEXT_URL) {
      pop = create_url_popup((char*)(winfo->data));
    } else if (winfo->type == TEXT_SERVER) {
      net_t* net = winfo->data;
      if (net_list) g_list_free(net_list);
      net_list = g_list_append(NULL, net);
      pop = create_network_popup(NULL, net_list, 0);
    } else if (winfo->type == TEXT_CHANNEL) {
      channel_entry_t* channel = winfo->data;
      pop = create_channel_popup(channel, 0);
    }
    if (pop) {
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }
  }
  return TRUE;
}


void on_button203_clicked(GtkButton * button, gpointer user_data)
{
  GtkLabel *label;
  net_t* net = user_data;

  label = GTK_LABEL(lookup_widget(GTK_WIDGET(button), "label529"));

  command_send(net, CMD_KILL_SERVER, label->label, NULL);
  on_button204_clicked(button, NULL);
}


void on_button204_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "shutdown_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void on_known_problems_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  problems_get();
}

gboolean
on_drawingarea1_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  draw_band_width(&global.down_width, 1);
  return TRUE;
}


gboolean
on_drawingarea2_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  draw_band_width(&global.up_width, 1);
  return TRUE;
}


void on_button206_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.down_width.maxval >= (1 << 30))
    return;
  global.down_width.maxval *= 2;
  draw_band_width(&global.down_width, 1);
}


void on_button207_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.down_width.maxval <= 1024)
    return;

  global.down_width.maxval /= 2;
  draw_band_width(&global.down_width, 1);
}


void on_button208_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.up_width.maxval >= (1 << 30))
    return;
  global.up_width.maxval *= 2;
  draw_band_width(&global.up_width, 1);
}


void on_button209_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.up_width.maxval <= 1024)
    return;

  global.up_width.maxval /= 2;
  draw_band_width(&global.up_width, 1);
}


gboolean
on_drawingarea1_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int height = widget->allocation.height - 19;
  int x = (int) event->x - 8;
  int y = (int) event->y - 17;

  deactivate_auto_afk();
  if (x < 0) x = 0;
  if (x > width) x = width;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;
  global.down_width.limit = (int) ((double) global.down_width.maxval /
				   (double)width * (double)x);
  draw_band_width(&global.down_width, 1);
  return TRUE;
}


gboolean
on_drawingarea2_button_press_event(GtkWidget * widget,
				   GdkEventButton * event,
				   gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int height = widget->allocation.height - 19;
  int x = (int) event->x - 8;
  int y = (int) event->y - 17;

  deactivate_auto_afk();
  if (x < 0) x = 0;
  if (x > width) x= width;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;
  global.up_width.limit = (int) ((double) global.up_width.maxval /
				 (double)width * (double)x);
  draw_band_width(&global.up_width, 1);

  return TRUE;
}

gboolean
on_window_delete_event(GtkWidget * widget ATTR_UNUSED,
		       GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global_exit();

  return TRUE;
}

void on_show_sockets_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList* clist;
  if (global.socket_win) return;

  global.socket_win = create_socket_win();
  gtk_widget_show(global.socket_win);
  clist = GTK_CLIST(lookup_widget(global.socket_win, "clist20"));
  gtk_clist_set_compare_func(clist, socket_compare);
}


gboolean
on_socket_win_delete_event(GtkWidget * widget ATTR_UNUSED,
			   GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.socket_win = NULL;
  return TRUE;
}

void
on_notebook5_switch_page(GtkNotebook * notebook ATTR_UNUSED,
			 GtkNotebookPage * page,
			 gint page_num ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_t *search;
  GtkObject *clist;

  if (!page) return;

  clist = gtk_object_get_data(GTK_OBJECT(page->child), "ctree");
  if (clist) {
    search = (search_t *) gtk_object_get_data(clist, "search");
    search_update_stats(search, 0);
    search_pattern_show(search->pattern, 0);
  }
  
}


void on_button218_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  search_fields_detach();
}

gboolean
on_drawingarea1_motion_notify_event(GtkWidget * widget,
				    GdkEventMotion * event,
				    gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int x = (int) event->x - 8;

  if (x < 0) x = 0;
  if (x > width) x = width;
  global.down_width.limit = (int) ((double) global.down_width.maxval /
				   (double)width * (double)x);
  draw_band_width(&global.down_width, 1);
  return TRUE;
}


gboolean
on_drawingarea2_motion_notify_event(GtkWidget * widget,
				    GdkEventMotion * event,
				    gpointer user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 16;
  int x = (int) event->x - 8;

  if (x < 0) x = 0;
  if (x > width) x = width;
  global.up_width.limit = (int) ((double) global.up_width.maxval /
				 (double)width * (double)x);
  draw_band_width(&global.up_width, 1);

  return TRUE;
}


void on_button217_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  if (global.socket_win)
    gtk_widget_destroy(global.socket_win);
}


void on_socket_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.socket_win = NULL;
}


void
on_clist20_select_row(GtkCList * clist,
		      gint row,
		      gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  socket_t *socket;

  socket = (socket_t *) gtk_clist_get_row_data(clist, row);
  socket_show_clist(socket);
}


void on_window_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{

}


void on_detach_server_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(0);
}


void on_detach_chat_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(1);
}


void on_detach_library_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(2);
}


void on_detach_search_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(3);
}


void on_detach_hotlist_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(4);
}


void
on_detach_downloads_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(5);
}


void on_detach_uploads_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(6);
}


void on_button229_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *temp;
  scheme_t *scheme;

  win = create_prefix_win();
  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme) {
    temp = lookup_widget(win, "entry122");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->server_prefix);
    temp = lookup_widget(win, "entry123");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->client_prefix);
    temp = lookup_widget(win, "entry124");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->join_prefix);
    temp = lookup_widget(win, "entry125");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->part_prefix);
  }

  gtk_widget_show(win);
}


gboolean
on_ignore_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  deactivate_auto_afk();
  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;
    if (row == -1)
      return FALSE;

    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_user_popup(M_IGNORE, NULL);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return TRUE;
}


void on_ok_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void on_button231_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  char *text;
  GtkSignalFunc func[2];
  char *buttons[2];

  temp = lookup_widget(global.win, "entry84");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (*text == 0) {
    func[0] = (GtkSignalFunc) on_ok_clicked;
    func[1] = NULL;
    buttons[0] = l_strdup("Ok");
    buttons[1] = NULL;

    temp = create_info_win("No filename specified!", buttons, func);
    gtk_widget_show(temp);

    l_free(buttons[0]);
    return;
  }
  if (global.lib) lib_save(global.lib, text);
}


void on_button230_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  
  deactivate_auto_afk();
  pop = create_files_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}

void on_button232_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED) {
  lib_refresh(global.lib);
}

void
on_search_select_row(GtkCList * clist ATTR_UNUSED,
		     gint row ATTR_UNUSED,
		     gint column ATTR_UNUSED, GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  //  file_t* file;

  //  file = (file_t*)gtk_clist_get_row_data(clist, row);
  //  if (file) printf("ping: %d\n", file->ping);
}

void on_button237_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *widget;

  win = lookup_widget(GTK_WIDGET(button), "retry_win");
  widget = lookup_widget(win, "spinbutton43");
  global.options.retry_timeout[0] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton44");
  global.options.retry_timeout[1] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton45");
  global.options.retry_timeout[2] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton46");
  global.options.retry_timeout[3] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton47");
  global.options.retry_timeout[4] =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
  retry_timeout_check();
}


void on_button238_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "retry_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void on_button243_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  resume_t* resume;
  GList* dlist;

  gtk_clist_freeze(GTK_CLIST(DownloadTree[0]));
  
  // remove finished downloads
  dlist = global.incomplete;
  while (dlist) {
    resume = dlist->data;
    dlist = dlist->next;
    if (resume->flags & RESUME_FINISHED)
      resume_remove(resume);
  }

  gtk_clist_thaw(GTK_CLIST(DownloadTree[0]));
}


void on_button244_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  printf("remove aborted deactivated\n");
  /*
    GtkCTree *ctree;
  GtkCTreeNode *node;
  resume_t* resume;

  // remove aborted downloads

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree4"));
  gtk_clist_freeze(GTK_CLIST(ctree));

  node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);
  
  while (node) {
    resume = gtk_ctree_node_get_row_data(ctree, node);
    node = GTK_CTREE_ROW (node)->sibling;
    if (!(resume->flags & RESUME_FINISHED) &&
	!resume->active && !resume_has_potentials(resume)) {
      resume_show(resume, 2);
    }
  }
  gtk_clist_thaw(GTK_CLIST(ctree));
  */
}


void on_button241_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *s = NULL;
  GList *dlist;
  socket_t *socket;
  upload_t *upload;
  int i1;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  gtk_clist_freeze(clist);

  for (i1 = 0; i1 < clist->rows; i1++) {
    socket = gtk_clist_get_row_data(clist, i1);
    if (!socket) continue;
    upload = socket->data;
    if (!upload) continue;
    if (upload->data->status == S_FINISHED)
      s = g_list_append(s, socket);
  }

  for (dlist = s; dlist; dlist = dlist->next) {
    socket = dlist->data;
    socket_end(socket, S_DELETE);
  }
  g_list_free(s);
  gtk_clist_thaw(clist);
}


void on_button242_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  int i1;
  GList *s = NULL;
  GList *dlist;
  socket_t *socket;
  upload_t *upload;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  gtk_clist_freeze(clist);
  for (i1 = 0; i1 < clist->rows; i1++) {
    socket = gtk_clist_get_row_data(clist, i1);
    if (!socket) continue;
    upload = socket->data;
    if (!upload) continue;
    if (upload->data->status == S_FINISHED)
      continue;
    if (upload->data->status == S_QUEUED)
      continue;
    if (upload_in_progress(upload))
      continue;
    s = g_list_append(s, socket);
  }

  for (dlist = s; dlist; dlist = dlist->next) {
    socket = dlist->data;
    socket_end(socket, S_DELETE);
  }
  g_list_free(s);
  gtk_clist_thaw(clist);
}


void on_button245_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  resume_search_all(NULL, 1);
}


void on_spinbutton49_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  int val;
  user_info_t* userinfo;

  temp = lookup_widget(global.win, "spinbutton49");
  userinfo = gtk_object_get_data(GTK_OBJECT(temp), "userinfo");
  if (!userinfo) return;
  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  userinfo->max[1] = val;
  check_uploads_again();
}


void
on_transfer_up_select_row(GtkCList * clist,
			  gint row,
			  gint column ATTR_UNUSED,
			  GdkEvent * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  upload_t *upload;
  socket_t *socket;

  socket = gtk_clist_get_row_data(clist, row);
  upload = socket->data;
  if (!upload) return;
  
  user_info_show(upload->data->user_info, 0, 0);
}


void
on_checkbutton48_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (!global.options_win)
    return;

  temp = lookup_widget(global.options_win, "spinbutton51");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }

}


void
on_checkbutton49_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (!global.options_win)
    return;

  temp = lookup_widget(global.options_win, "entry85");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}


void
on_checkbutton45_toggled(GtkToggleButton * togglebutton ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    global.options.ping_search = 1;
  } else {
    global.options.ping_search = 0;
  }
  setup_preferences(P_PINGS);
}

void on_combo_entry25_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  temp = lookup_widget(global.options_win, "spinbutton56");

  if (!l_strcasecmp(text, "Recent Users"))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}


void
on_detach_statistic_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  main_tab_detach(7);
}


void on_search_close_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  search_t *search = user_data;
  
  if (!search) return;
  search_remove(search);
}


gboolean
on_drawingarea3_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_graphs(&global.statistic, 1);
  return TRUE;
}


gboolean
on_drawingarea4_expose_event(GtkWidget * widget ATTR_UNUSED,
			     GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  statistic_draw_graphs(&global.statistic, 1);
  return TRUE;
}

void on_button275_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  resume_t *resume;
  GtkWidget *win;
  GtkWidget *temp;
  char *text;
  GtkCList* clist;
  file_segment_t** segment;
  file_segment_t* prev_segment;
  int i1;
  long size;

  win = lookup_widget(GTK_WIDGET(button), "resume_options_win");
  resume = gtk_object_get_data(GTK_OBJECT(win), "resume");

  if (!g_list_find(global.incomplete, resume))
  {
    gtk_widget_destroy(win);
    return;
  }

  temp = lookup_widget(win, "checkbutton53");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "entry107");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (resume->dirname)
      l_free(resume->dirname);
    resume->dirname = NULL;
    if (*text)
      resume->dirname = l_strdup(text);
  }
  temp = lookup_widget(win, "checkbutton51");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "entry106");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    if (resume->search_string)
      l_free(resume->search_string);
    resume->search_string = NULL;
    if (*text)
      resume->search_string = l_strdup(text);
    if (resume->search) {
      if (resume->search->pattern->include)
	l_free(resume->search->pattern->include);
      resume->search->pattern->include = l_strdup(text);
    }
  }
  temp = lookup_widget(win, "checkbutton88");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "entry155");
    text = gtk_entry_get_text(GTK_ENTRY(temp));
    size = extract_bytes(text);
    if (resume->search) {
      resume->search->pattern->size_lo = size;
      resume->search->pattern->size_hi = size;
    }
    resume->comp_size = size;
  }

  temp = lookup_widget(win, "checkbutton52");

  prev_segment = NULL;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    clist = GTK_CLIST(lookup_widget(win, "clist37"));
    i1 = 0;
    while (1) {
      if (i1 >= clist->rows) break;
      segment = gtk_clist_get_row_data(clist, i1);

      if (!segment[0]->socket) {
	resume->inc_size -= segment[0]->size;
	resume->inc_size += segment[1]->size;

	// delete check error flag if stop position has changed
	if (segment[0]->start + segment[0]->size > 
	    segment[1]->start + segment[1]->size)
	  segment[0]->flags &= ~PART_CHECK_ERROR;
	// delete check error flag of previous segment
	// if start position has changed
	if (prev_segment && 
	    (segment[0]->start != segment[1]->start ||
	     segment[1]->size < 1000))
	  prev_segment->flags &= ~PART_CHECK_ERROR;
	  
	segment[0]->start = segment[1]->start;
	segment[0]->size = segment[1]->size;
	segment[0]->stop = segment[0]->start+segment[0]->size;
	if (segment[0]->size < 1000) 
	  file_segment_remove(resume, segment[0]);
	prev_segment = segment[0];
      }

      i1++;
    }
    resume->flags |= RESUME_FREE_SEGMENT;
  }

  resume_queued_update(resume);
  resume_save(NULL);
  gtk_widget_destroy(win);
}


void on_button276_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(button), "resume_options_win");
  gtk_widget_destroy(temp);
}

void on_resume_configure(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *win;
  GtkWidget *temp;
  resume_t *resume;
  char *pos;
  char str[128];

  resume = (resume_t *) user_data;
  if (!resume) return;

  win = create_resume_options_win();
  gtk_object_set_data(GTK_OBJECT(win), "resume", resume);

  if (resume->dirname) {
    temp = lookup_widget(win, "entry107");
    gtk_entry_set_text(GTK_ENTRY(temp), resume->dirname);
  }
  
  temp = lookup_widget(win, "entry106");
  if (resume->search_string) {
    gtk_entry_set_text(GTK_ENTRY(temp), resume->search_string);
  } else {
    // have to copy since extract filename only returns a pointer
    // to the original filename, and get_search_string() modifies
    // the string
    pos = l_strdup(get_file_name(resume->filename));
    gtk_entry_set_text(GTK_ENTRY(temp), get_search_string(pos));
    l_free(pos);
  }

  temp = lookup_widget(win, "entry155");
  gtk_entry_set_text(GTK_ENTRY(temp), 
		     print_bytes(str, resume->comp_size));

  if (!resume->parts) {
    temp = lookup_widget(win, "checkbutton52");
    gtk_widget_set_sensitive(temp, FALSE);
  }
  /*allow all file to be reset
  if (resume->comp_size) {
    temp = lookup_widget(win, "checkbutton88");
    gtk_widget_set_sensitive(temp, FALSE);
  }
  */
  gtk_widget_realize(win);
  gtk_widget_show(win);
  resume_options_setup(win, resume);
}


void
on_checkbutton51_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "entry106");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}


void
on_checkbutton52_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "hbox759");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}


void
on_checkbutton53_toggled(GtkToggleButton * togglebutton,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "entry107");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);

}

void on_combo_entry13_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  temp = lookup_widget(GTK_WIDGET(editable), "button107");
  if (!l_strcasecmp(text, "transfer_running") ||
      !l_strcasecmp(text, "transfer_waiting") ||
      !l_strcasecmp(text, "transfer_bar1") ||
      !l_strcasecmp(text, "transfer_bar2") ||
      !l_strcasecmp(text, "transfer_bar2") ||
      !l_strcasecmp(text, "library_marked")) {
    gtk_widget_set_sensitive(temp, FALSE);
  } else {
    gtk_widget_set_sensitive(temp, TRUE);
  }
}


void on_entry80_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp;
  GtkCList *clist;
  int row;
  char *suff;
  char *text;
  int mime;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));
  suff = gtk_entry_get_text(GTK_ENTRY(editable));
  for (row = 0; row < clist->rows; row++) {
    gtk_clist_get_text(clist, row, 0, &text);
    if (!l_strcasecmp(text, suff))
      break;
  }
  temp = lookup_widget(global.options_win, "button180");
  temp = GTK_BIN(temp)->child;
  if (row == clist->rows) {
    gtk_label_set_text(GTK_LABEL(temp), "Add Suffix");
    temp = lookup_widget(global.options_win, "entry82");
    gtk_entry_set_text(GTK_ENTRY(temp), "");
    temp = lookup_widget(global.options_win, "combo_entry20");
    mime = guess_mime(suff);
    if (mime != MIME_NONE)
      gtk_entry_set_text(GTK_ENTRY(temp), MimeNames(mime, 2));
    temp = lookup_widget(global.options_win, "checkbutton55");
    if (mime == MIME_MP3)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  } else {
    gtk_label_set_text(GTK_LABEL(temp), "Update Suffix");

    gtk_clist_get_text(clist, row, 1, &text);
    temp = lookup_widget(global.options_win, "combo_entry20");
    gtk_entry_set_text(GTK_ENTRY(temp), text);

    gtk_clist_get_text(clist, row, 2, &text);
    temp = lookup_widget(global.options_win, "entry82");
    gtk_entry_set_text(GTK_ENTRY(temp), text);

    gtk_clist_get_text(clist, row, 3, &text);
    temp = lookup_widget(global.options_win, "checkbutton55");
    if (!l_strcasecmp(text, "Yes"))
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  }
}

void on_combo_entry20_changed(GtkEditable * editable, gpointer user_data ATTR_UNUSED)
{
  char *text;
  GtkWidget *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  temp = lookup_widget(global.options_win, "checkbutton55");
  if (!l_strcasecmp("mp3", text)) {
    gtk_widget_set_sensitive(temp, FALSE);
  } else {
    gtk_widget_set_sensitive(temp, TRUE);
  }
}


gboolean
on_drawingarea10_expose_event(GtkWidget * widget,
			      GdkEventExpose * event ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  int width, height;

  width = widget->allocation.width;
  height = widget->allocation.height;
  gdk_draw_rectangle(widget->window, widget->style->black_gc, TRUE,
		     0, 0, width, height);

  return TRUE;
}

void on_spinbutton61_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp1;
  GtkWidget *temp2;
  GtkWidget *temp3;

  temp1 = lookup_widget(global.win, "spinbutton61");
  temp2 = lookup_widget(global.win, "spinbutton62");
  temp3 = lookup_widget(global.win, "checkbutton64");
  global.options.access_timeout =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp1)) * 24 +
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp2));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp3))) {
    if (global.options.access_timeout < 0)
      global.options.access_timeout = -global.options.access_timeout;
  } else {
    if (global.options.access_timeout > 0)
      global.options.access_timeout = -global.options.access_timeout;
  }
  access_cleanup(1);
}

void
on_checkbutton64_toggled(GtkToggleButton * togglebutton ATTR_UNUSED,
			 gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp1;
  GtkWidget *temp2;
  GtkWidget *temp3;

  temp1 = lookup_widget(global.win, "spinbutton61");
  temp2 = lookup_widget(global.win, "spinbutton62");
  temp3 = lookup_widget(global.win, "checkbutton64");
  global.options.access_timeout =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp1)) * 24 +
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp2));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp3))) {
    if (global.options.access_timeout < 0)
      global.options.access_timeout = -global.options.access_timeout;
  } else {
    if (global.options.access_timeout > 0)
      global.options.access_timeout = -global.options.access_timeout;
  }
  access_cleanup(1);
}


void on_spinbutton62_changed(GtkEditable * editable ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *temp1;
  GtkWidget *temp2;
  GtkWidget *temp3;

  temp1 = lookup_widget(global.win, "spinbutton61");
  temp2 = lookup_widget(global.win, "spinbutton62");
  temp3 = lookup_widget(global.win, "checkbutton64");
  global.options.access_timeout =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp1)) * 24 +
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp2));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp3))) {
    if (global.options.access_timeout < 0)
      global.options.access_timeout = -global.options.access_timeout;
  } else {
    if (global.options.access_timeout > 0)
      global.options.access_timeout = -global.options.access_timeout;
  }
  access_cleanup(1);
}

gboolean
on_ctree3_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  deactivate_auto_afk();
  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;

    global.popup_row = row;
    global.popup_list = widget;

    if (row != -1) {
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
      pop = create_access_popup();
      if (pop) {
	gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		       event->button, event->time);
      }
    }
  }

  return TRUE;
}

void on_latest_version_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  latest_version_get(1);
}


void on_button308_clicked(GtkButton * button, gpointer user_data ATTR_UNUSED)
{
  global.options.time_display++;
  if (global.options.time_display > 3) {
    global.options.time_display = 0;
  }
  print_topright_corner();
  
  gtk_widget_queue_resize(GTK_WIDGET(button));
}


void on_ok1_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *temp;
  char *filename;

  temp = GTK_WIDGET(user_data);
  if (!temp)
    return;

  filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(temp));
  if (filename && (*filename))
    resume_load(filename, 1);
  gtk_widget_destroy(temp);
}

void on_cancel1_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(user_data);
  if (temp)
    gtk_widget_destroy(temp);
}

void on_button311_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *filesel;
  GtkWidget *temp;

  filesel = gtk_file_selection_new("Import incomplete list");
  gtk_widget_show(filesel);

  temp = GTK_FILE_SELECTION(filesel)->ok_button;
  if (temp)
    gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		       GTK_SIGNAL_FUNC(on_ok1_clicked), filesel);
  temp = GTK_FILE_SELECTION(filesel)->cancel_button;
  if (temp)
    gtk_signal_connect(GTK_OBJECT(temp), "clicked",
		       GTK_SIGNAL_FUNC(on_cancel1_clicked), filesel);
}


void on_button313_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkNotebook *notebook;
  GtkWidget *current;
  int no;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  if (!notebook->cur_page) return;
  current = notebook->cur_page->child;
  no = gtk_notebook_page_num(notebook, current);
  if (no > 0)
    gtk_notebook_reorder_child(notebook, current, no - 1);
}


void on_button314_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkNotebook *notebook;
  GtkWidget *current;
  int no;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  if (!notebook->cur_page) return;
  current = notebook->cur_page->child;
  no = gtk_notebook_page_num(notebook, current);
  if (no < (int)g_list_length(notebook->children) - 1)
    gtk_notebook_reorder_child(notebook, current, no + 1);
}


void on_user_list_win_destroy(GtkObject * object ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.string_win);
  gtk_widget_destroy(global.string_win);
  global.string_win = NULL;
}

void on_button315_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  gtk_widget_hide(global.string_win);
}


gboolean
on_string_list_button_press_event(GtkWidget * widget,
				  GdkEventButton * event,
				  gpointer user_data)
{
  int slist = (int) user_data;
  GtkWidget *pop;
  int row, column;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  if (row < 0)
    return FALSE;

  global.popup_row = row;
  global.popup_list = widget;

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_string_list_popup(slist);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return TRUE;
}

void
on_string_list_entry_activate(GtkEditable * editable, gpointer user_data)
{
  char *text;
  int slist = (int) user_data;
  char *temp;
  char* text2;

  deactivate_auto_afk();
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!text) return;

  if (slist == LIST_BANREASON || 
      slist == LIST_AFKREASON) {
    text2 = l_strdup(text);
    convert_quotes(text2);
    string_list_add(slist, text2);
    l_free(text2);
  } else {
    temp = l_strdup(text);
    text = arg(temp, 0);
    while (text) {
      string_list_add(slist, text);
      text = arg(NULL, 0);
    }
    l_free(temp);
  }
  gtk_entry_set_text(GTK_ENTRY(editable), "");
}

void on_user_list_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GtkEntry *entry;
  int i1;
  GList *dlist;
  int row;

  if (global.string_win) {
    if (global.string_win->window)
      gdk_window_raise(global.string_win->window);
    gtk_widget_show(global.string_win);
    return;
  }

  global.string_win = create_string_list_win();
  gtk_widget_show(global.string_win);

  // now insert list items and adding signal handler
  for (i1 = 0; i1 < STRING_LIST_NO; i1++) {
    clist = string_list_get_clist(i1);
    for (dlist = global.string_list[i1]; dlist; dlist = dlist->next) {
      strcpy(tstr[0], (char *) (dlist->data));
      row = gtk_clist_append(clist, list);
      gtk_clist_set_row_data(clist, row, dlist->data);
    }
    gtk_signal_connect(GTK_OBJECT(clist), "button_press_event",
		       GTK_SIGNAL_FUNC(on_string_list_button_press_event),
		       (gpointer) i1);
    entry = string_list_get_entry(i1);
    gtk_signal_connect(GTK_OBJECT(entry), "activate",
		       GTK_SIGNAL_FUNC(on_string_list_entry_activate),
		       (gpointer) i1);
  }
}

gboolean
on_ctree4_button_press_event(GtkWidget * widget,
			     GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if (DOUBLE_CLICK(event, row)) return FALSE;

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    pop = create_download_popup();
    if (pop)
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
  }
  return TRUE;
}

void
on_enter_bandwidth1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  user_info_t* ui = user_data;
  create_bandwidth_win(ui, 1);
}

void
on_enter_bandwidth2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  user_info_t* ui = user_data;
  create_bandwidth_win(ui, 0);
}

void
on_download_man_activate               (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  create_bandman_win(1);
}


void
on_upload_man_activate                 (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  create_bandman_win(0);
}


void
on_button318_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkObject* win;
  GtkAdjustment* adj;
  GtkToggleButton* temp;

  if (!user_data) return;
  win = user_data;

  adj = gtk_object_get_data(win, "adj1");
  if (adj) {
    global.options.resume_abort[0] = (int)(adj->value*100);
  }
  temp = gtk_object_get_data(win, "check");
  if (temp && gtk_toggle_button_get_active(temp)) {
    global.options.resume_abort[1] = 1;
  } else {
    global.options.resume_abort[1] = 0;
  }

  adj = gtk_object_get_data(win, "adj2");
  if (adj) {
    global.options.resume_abort[2] = (int)(adj->value);
  }
  adj = gtk_object_get_data(win, "adj3");
  if (adj) {
    global.options.resume_abort[3] = (int)(adj->value);
  }
  on_button319_clicked(button, user_data);

  {
    GtkCTree* ctree;
    GtkCTreeNode* node;
    resume_t *resume;
    int i1;

    for (i1 = 1; i1 < 4; i1++) {
      ctree = DownloadTree[i1];
      node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);
      while (node) {
	resume = gtk_ctree_node_get_row_data(ctree, node);
	node = GTK_CTREE_ROW (node)->sibling;
	resume_queued_update(resume);
      }
    }
  }
}


void
on_button319_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data)
{
  if (user_data)
    gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_ctree4_tree_select_row              (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  socket_t *socket;
  download_t* download;

  if (GTK_CTREE_ROW(node)->parent != NULL) {
    socket = gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node));
  } else {
    socket = NULL;
  }
  if (!socket) return;
  download = socket->data;
  if (!download) return;
  
  user_info_show(download->data->user_info, 1, 0);
}


gboolean
on_drawingarea12_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 1, 0);
  return TRUE;
}


gboolean
on_drawingarea12_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int height = widget->allocation.height-1;
  int x = (int) event->x;
  int y = (int) event->y;
  user_info_t* userinfo;

  deactivate_auto_afk();
  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0) x = 0;
  if (x > width) x = width;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;

  userinfo->limit[0] = (int) ((double) global.down_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 1, 1);
  
  return TRUE;
}


gboolean
on_drawingarea12_leave_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 1, 0);

  return TRUE;
}


gboolean
on_drawingarea12_enter_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 1, 1);

  return TRUE;
}

gboolean
on_drawingarea12_motion_notify_event   (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 1;
  int x = (int) event->x;
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0) x = 0;
  if (x > width) x = width;
  
  userinfo->limit[0] = (int) ((double) global.down_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 1, 1);

  return TRUE;
}

gboolean
on_drawingarea11_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 0, 0);

  return TRUE;
}


gboolean
on_drawingarea11_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int height = widget->allocation.height-1;
  int x = (int) event->x;
  int y = (int) event->y;
  user_info_t* userinfo;

  deactivate_auto_afk();
  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0) x = 0;
  if (x > width) x = width;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;

  userinfo->limit[1] = (int) ((double) global.up_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 0, 1);
  
  return TRUE;
}


gboolean
on_drawingarea11_enter_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 0, 1);

  return TRUE;
}


gboolean
on_drawingarea11_motion_notify_event   (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width - 1;
  int x = (int) event->x;
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  if (!userinfo) return FALSE;

  if (x < 0) x = 0;
  if (x > width) x = width;

  userinfo->limit[1] = (int) ((double) global.up_width.limit /
			      (double)width * (double)x);
  user_info_show(userinfo, 0, 1);

  return TRUE;
}

gboolean
on_drawingarea11_leave_notify_event    (GtkWidget       *widget,
                                        GdkEventCrossing *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  user_info_t* userinfo;

  userinfo = gtk_object_get_data(GTK_OBJECT(widget), "userinfo");
  user_info_show(userinfo, 0, 0);

  return TRUE;
}

void
on_button322_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* win;

  win = create_abort_win();
  gtk_widget_show(win);
}


void
on_queue_win_destroy                   (GtkObject       *object,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* win = GTK_WIDGET(object);

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
  global.queue_win = NULL;
}


void
on_button323_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;
  file_t* file;

  ctree = GTK_CTREE(lookup_widget(global.queue_win, "ctree6"));
  node = GTK_CTREE_NODE (GTK_CLIST (ctree)->row_list);

  while (node) {
    file = gtk_ctree_node_get_row_data(ctree, node);
    if (file)
      download_file_without_check(file, NULL, NULL);
    node = GTK_CTREE_ROW (node)->sibling;
  }
  on_button324_clicked(button, user_data);
}


void
on_button325_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;
  file_t* file;
  GList* row_list;

  ctree = GTK_CTREE(lookup_widget(global.queue_win, "ctree6"));
  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    file = gtk_ctree_node_get_row_data(ctree, node);
    if (file)
      download_file_without_check(file, NULL, NULL);
    row_list = row_list->next;
  }
  on_button324_clicked(button, user_data);
}

void
on_button324_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCTree* ctree;

  if (!global.queue_win) return;

  ctree = GTK_CTREE(lookup_widget(global.queue_win, "ctree6"));
  gtk_clist_clear(GTK_CLIST(ctree));
  gtk_widget_hide(global.queue_win);
}

void
on_button326_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(GTK_WIDGET(button), "entry122");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 0);
  temp = lookup_widget(GTK_WIDGET(button), "entry123");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 1);
  temp = lookup_widget(GTK_WIDGET(button), "entry124");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 2);
  temp = lookup_widget(GTK_WIDGET(button), "entry125");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  set_prefix(text, 3);

  on_button327_clicked(button, user_data);
}


void
on_button327_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "prefix_win");
  if (temp) gtk_widget_destroy(temp);
}

void
on_clist34_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column ATTR_UNUSED,
                                        GdkEvent        *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  search_pattern_t* pattern;

  pattern = gtk_clist_get_row_data(clist, row);
  if (pattern) search_pattern_show(pattern, 0);
}


gboolean
on_clist34_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  search_pattern_t *pattern;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if (row >= 0)
    pattern = gtk_clist_get_row_data(GTK_CLIST(widget), row);
  else pattern = NULL;
  if (!pattern) return FALSE;

  if (DOUBLE_CLICK(event, row) && pattern) {
    search_pattern_search(pattern, NULL);
    return TRUE;
  }

  if (event->button == global.options.popup_create) {
    if (row >= 0) gtk_clist_select_row(GTK_CLIST(widget), row, 0);

    pop = create_search_pattern_popup(pattern);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
    return TRUE;
  }

  /*
  if ((event->button == 1) && (row >= 0) && (column == 0)) {
    clist_row = g_list_nth(GTK_CLIST(widget)->row_list, row)->data;
    if (clist_row->state == GTK_STATE_SELECTED) {
      search_pattern_rename(pattern);
      return TRUE;
    }
  }
  */
  return TRUE;
}


gboolean
on_clist34_key_press_event             (GtkWidget       *widget ATTR_UNUSED,
                                        GdkEventKey     *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  return TRUE;
}

void
on_button328_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  send_search_request(FALSE);
}


void
on_button330_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_button331_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_button332_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  char* data = NULL;
  net_t* net = NULL;

  if (global.ban_win) {
    data = gtk_object_get_data(GTK_OBJECT(global.ban_win), "channel");
    net = gtk_object_get_data(GTK_OBJECT(global.ban_win), "network");
  }
  if (net) show_bans(net, data);
}

void
on_button334_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;
  GtkWidget *widget;

  win = lookup_widget(GTK_WIDGET(button), "priority_win");
  widget = lookup_widget(win, "spinbutton63");
  global.options.upload_priority[PRI_FRIEND] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton64");
  global.options.upload_priority[PRI_DOWNLOAD] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton65");
  global.options.upload_priority[PRI_SHARE] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
  widget = lookup_widget(win, "spinbutton66");
  global.options.upload_priority[PRI_NONE] =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_button335_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "priority_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_show_subscriptions_activate         (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GList* dlist;
  subscription_t* sub;
  GtkWidget* temp;

  if (global.subscription_win) {
    if (global.subscription_win->window)
      gdk_window_raise(global.subscription_win->window);
    gtk_widget_show(global.subscription_win);
    return;
  }

  global.subscription_win = create_subscription_win();
  gtk_widget_show(global.subscription_win);

  temp = lookup_widget(global.subscription_win, "ctree7");
  gtk_drag_dest_set(temp, GTK_DEST_DEFAULT_ALL,
		    &(lib_list_targets[0]), 2, GDK_ACTION_ASK);
  for (dlist = global.subscriptions; dlist; dlist = dlist->next) {
    sub = dlist->data;
    subscription_user_add_ctree(sub);
  }
}


void
on_subscription_win_destroy            (GtkObject       *object ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  global.subscription_win = NULL;
  return;
}


gboolean
on_ctree7_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  if (row == -1) return FALSE;

  global.popup_row = row;
  global.popup_list = widget;

  gtk_clist_get_pixtext(GTK_CLIST(widget), row, 0,
			&text, &space, &pixmap, &bitmap);
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_subscription_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return TRUE;
}


#define ROW_FROM_YPIXEL(clist, y)  (((y) - (clist)->voffset) / \
                                    ((clist)->row_height + 1))

int drag_dest_row (GtkCList         *clist,
		   gint              y)
{
  GtkWidget *widget;
  int row;

  widget = GTK_WIDGET (clist);

  y -= (GTK_CONTAINER (clist)->border_width +
        widget->style->klass->ythickness +
        clist->column_title_area.height);

  row = ROW_FROM_YPIXEL (clist, y);
  if (row >= clist->rows) row = clist->rows - 1;
  if (row < -1) row = -1;
  return row;
}

static void sub_add_node(subscription_t* sub, file_node_t* node) {
  file_node_t* child;

  if (!node) return;
  if (node->file) {
    subscription_file_add(sub, node->file->longname);
  } else {
    child = node->child;
    while (child) {
      sub_add_node(sub, child);
      child = child->next;
    }
  }
}


void
on_ctree7_drag_data_received           (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x ATTR_UNUSED,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCTree* ctree = GTK_CTREE(widget);
  GtkCList* clist;
  int row;
  GList* selection;
  GList* dlist;
  subscription_t* sub;
  file_node_t* lib_node;
  GtkCTreeNode* node;

  // getting subscription (node)
  row = drag_dest_row (GTK_CLIST(ctree), y);
  node = gtk_ctree_node_nth(ctree, row);
  if (!node) return;
  while (GTK_CTREE_ROW(node)->parent)
    node = GTK_CTREE_ROW(node)->parent;
  sub = gtk_ctree_node_get_row_data(ctree, node);
  if (!sub) return;

  if (info == 0) {
    selection = *((GList**)(data->data));
    if (!selection) return;
  
    clist = GTK_CLIST(gtk_drag_get_source_widget(drag_context));
    if (!clist) return;

    for (dlist = selection; dlist; dlist = dlist->next) {
      row = (int) dlist->data;
      lib_node = gtk_clist_get_row_data(clist, row);
      sub_add_node(sub, lib_node);
    }
  } else if (info == 1) {
    lib_node = *((file_node_t**)(data->data));
    if (!lib_node) return;
    sub_add_node(sub, lib_node);
  }
}

void
on_button336_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  if (global.subscription_win) gtk_widget_hide(global.subscription_win);

  return;
}


void
on_entry131_activate                   (GtkEditable     *editable,
                                        gpointer         user_data ATTR_UNUSED)
{
  char *text;
  char *temp;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!text) return;
  temp = l_strdup(text);
  text = arg(temp, 0);
  while (text) {
    subscription_user_add(text);
    text = arg(NULL, 0);
  }
  l_free(temp);
  gtk_entry_set_text(GTK_ENTRY(editable), "");
}

void on_sub_remove_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  char *filename = (char*)user_data;
  subscription_t* sub;

  sub = subscription_data_search(filename);
  if (sub) subscription_file_remove(sub, filename);
}

void on_add_subscription_activate(GtkMenuItem * menuitem ATTR_UNUSED, 
				  gpointer user_data ATTR_UNUSED) {
  GtkCList *clist;
  GList *row_list;
  int row;
  socket_t *socket;
  upload_t *upload;
  subscription_t* sub;
  
  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int) row_list->data;
    row_list = row_list->next;
    socket = gtk_clist_get_row_data(clist, row);
    if (socket->type != S_UPLOAD) continue;
    upload = socket->data;
    if (!upload) continue;
    if (upload->data->status == S_FINISHED) continue;
    sub = subscription_user_search(upload->data->user_info->nick);
    if (!sub)
      sub = subscription_user_add(upload->data->user_info->nick);
    subscription_file_add(sub, upload->file->longname);
  }
}


void
on_button337_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  search_fields_detach2();
}


void
on_button338_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  download_remove_dead();
}


void
on_button339_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  upload_remove_dead();
}


gboolean
on_ctree8_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  lib_node_t* node;

  deactivate_auto_afk();
  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;

    global.popup_row = row;
    global.popup_list = widget;

    if (row != -1) {
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
      node = gtk_clist_get_row_data(GTK_CLIST(global.popup_list),
				    global.popup_row);

      pop = create_lib2_popup(node);
      if (pop) {
	gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		       event->button, event->time);
      }
    }
  }

  return TRUE;
}


gboolean
on_clist36_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  file_node_t *node;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if (DOUBLE_CLICK(event, row)) {
    node = gtk_clist_get_row_data(GTK_CLIST(widget),
				  global.popup_row);
    if (node && node->file) play_file(node->file->longname);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    if (row == -1) {
      pop = create_lib1_popup(NULL);
    } else {
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
      node = gtk_clist_get_row_data(GTK_CLIST(widget),
				    global.popup_row);
      
      pop = create_lib1_popup(node);
    }
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return TRUE;
}

void
on_clist36_drag_begin                  (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gpointer         user_data ATTR_UNUSED)
{
  if (!GTK_CLIST(widget)->selection) return;
  g_dataset_set_data (drag_context, "selected_files", 
		      GTK_CLIST(widget)->selection);
}


void
on_clist36_drag_data_get (GtkWidget       *widget ATTR_UNUSED,
			  GdkDragContext  *drag_context,
			  GtkSelectionData *data,
			  guint            info ATTR_UNUSED,
			  guint            time ATTR_UNUSED,
			  gpointer         user_data ATTR_UNUSED)
{
  GList* selection;

  selection = g_dataset_get_data (drag_context, "selected_files");
  if (selection) {
    gtk_selection_data_set (data, gdk_atom_intern("files", TRUE),
			    GTK_TYPE_POINTER, (void*)(&selection),
			    sizeof(selection));
  }
  return;
}


void
on_clist36_drag_end(GtkWidget       *widget ATTR_UNUSED,
		    GdkDragContext  *drag_context ATTR_UNUSED,
		    gpointer         user_data ATTR_UNUSED)
{
}


void
on_button343_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = create_dir_browser("Select Directory", g_get_home_dir(),
			   GTK_SELECTION_EXTENDED, on_dir_select343);
  gtk_widget_show(win);
}


void
on_button344_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist19"));
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}

gboolean
on_ctree10_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  GtkCTreeNode* node;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;

  global.popup_row = row;
  global.popup_list = widget;

  if (DOUBLE_CLICK(event, row)) return FALSE;
  /*
  if (DOUBLE_CLICK(event, row)) {
    on_connect3_activate(NULL, NULL);
    return FALSE;
  }
  */

  if (event->button == global.options.popup_create) {
    GtkCTree* ctree = GTK_CTREE(widget);
    int depth = 0;
    GtkCTreeNode* node2;

    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    node = gtk_ctree_node_nth(ctree, row);
    
    if (node) {
      node2 = node;
      while ((node2 = GTK_CTREE_ROW(node2)->parent))
	depth++;
    }

    if (!node || depth == 2) {
      server_t* server;
      if (node) server = gtk_ctree_node_get_row_data(ctree, node);
      else server = NULL;
      pop = create_server1_popup(server);
    } else if (depth == 0) {
      net_group_t* ng = gtk_ctree_node_get_row_data(ctree, node);
      pop = create_netgroup1_popup(ng);
    } else if (depth == 1) {
      net_t* network = gtk_ctree_node_get_row_data(ctree, node);
      pop = create_network1_popup(network);
    } else pop = NULL;
    if (pop) {
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }
  }

  return TRUE;
}

gboolean
on_channel_button_press_event(GtkWidget * widget,
			      GdkEventButton * event, gpointer user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  channel_entry_t* channel;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;
  
  if (row >= 0)
    channel = gtk_clist_get_row_data(GTK_CLIST(widget), row);
  else channel = NULL;

  if (!channel) return FALSE;

  if (DOUBLE_CLICK(event, row)) {
    join_channel(channel->net, channel->name);
    return TRUE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), global.popup_row, 0);
    pop = create_channel_popup(channel, 1);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return TRUE;
}

void
on_cancel_connect_activate             (GtkMenuItem     *menuitem ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  net_group_cancel_connect(NULL);
}


void
on_button347_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* nentry;
  GtkWidget* sentry;
  GtkWidget* pentry;
  GtkWidget* checkbutton;
  GtkWidget* temp;
  char* network;
  char* server;
  char* pos;
  int port;
  server_t* serv;
  net_t* net;
  net_group_t* ng;

  nentry = lookup_widget(global.win, "entry136");
  sentry = lookup_widget(global.win, "entry138");
  pentry = lookup_widget(global.win, "spinbutton70");
  checkbutton = lookup_widget(global.win, "checkbutton72");
  
  network = gtk_entry_get_text(GTK_ENTRY(nentry));
  if (!network || !(*network)) return;
  server = gtk_entry_get_text(GTK_ENTRY(sentry));
  if (!server || !(*server)) return;
  port = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pentry));

  net = net_group_search_network(network);
  if (!net) {
    ng = net_group_create("Private Networks", 0, -1);

    temp = lookup_widget(global.win, "combo_entry31");
    pos = gtk_entry_get_text(GTK_ENTRY(temp));
    if (!l_strcasecmp(pos, "IRC"))
      net = network_new(network, NETWORK_IRC);
    else
      net = network_new(network, NETWORK_NAPSTER);

    net_group_add_net(ng, net);
  }
  serv = network_search_server(net, server);
  if (serv) {
    // FIXME: update server
  } else {
    serv = server_create(server, NULL, port, 
			 "0", "0", "0", "0", 1);

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton)))
      serv->flags |= SERVER_REDIRECT;
    else
      serv->flags &= ~SERVER_REDIRECT;

    network_add_server(net, serv);
  }

  server_save();
  gtk_entry_set_text(GTK_ENTRY(sentry), "");
}


gboolean
on_drawingarea13_button_press_event    (GtkWidget       *widget ATTR_UNUSED,
                                        GdkEventButton  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{

  return TRUE;
}


gboolean
on_drawingarea13_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  resume_t *resume;
  GtkWidget *win;
  GtkWidget* temp;
  file_segment_t** segment;

  win = lookup_widget(GTK_WIDGET(widget), "resume_options_win");
  resume = gtk_object_get_data(GTK_OBJECT(win), "resume");

  temp = lookup_widget(win, "drawingarea13");
  segment = gtk_object_get_data(GTK_OBJECT(temp), "segment");
  resume_draw_segments(win, temp->window, resume, segment);

  return TRUE;
}


void
on_clist37_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column ATTR_UNUSED,
                                        GdkEvent        *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  resume_t *resume;
  GtkWidget *win;
  file_segment_t** segment;
  
  win = lookup_widget(GTK_WIDGET(clist), "resume_options_win");
  resume = gtk_object_get_data(GTK_OBJECT(win), "resume");
  
  segment = gtk_clist_get_row_data(clist, row);
  if (segment)
    change_segment(win, segment);
}


gboolean
on_drawingarea14_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;
  file_segment_t** segment;

  win = lookup_widget(GTK_WIDGET(widget), "resume_options_win");
  segment = gtk_object_get_data(GTK_OBJECT(widget), "segment");
  
  if (segment)
    resume_draw_segment(win, widget->window, segment);

  return TRUE;
}


void
on_button348_clicked                   (GtkButton       *button,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(button), "resume_options_win");
  resume_modify_values(win);
}


void
on_entry134_activate                   (GtkEditable     *editable,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(editable), "resume_options_win");
  resume_modify_values(win);
}


void
on_entry135_activate                   (GtkEditable     *editable,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *win;

  win = lookup_widget(GTK_WIDGET(editable), "resume_options_win");
  resume_modify_values(win);
}


gboolean
on_drawingarea14_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int height = widget->allocation.height-1;
  int x = (int) event->x;
  int y = (int) event->y;
  file_segment_t** segment;
  double percent;
  long new_val;
  GtkWidget* win;
  
  deactivate_auto_afk();
  segment = gtk_object_get_data(GTK_OBJECT(widget), "segment");
  if (!segment || segment[0]->socket) return FALSE;

  ev_button = event->button;
  if (ev_button != 1 && ev_button != 3) return FALSE;

  if (y < height-7) return FALSE;
  if (y > height-1) return FALSE;
  
  if (x < 5) percent = 0.;
  else if (x > width-5) percent = 1.;
  else percent = (double)(x - 5)/(double)(width-10);
  new_val = segment[0]->start+percent*segment[0]->size;
  
  if (ev_button == 1) {
    segment[1]->stop = new_val;
    segment[1]->start = CLAMP(segment[1]->start, segment[0]->start,
			      segment[1]->stop);
  } else {
    segment[1]->start = new_val;
    segment[1]->stop = CLAMP(segment[1]->stop, segment[1]->start,
			     segment[0]->start+segment[0]->size);
  }
    
  win = lookup_widget(GTK_WIDGET(widget), "resume_options_win");
  segment[1]->size = segment[1]->stop-segment[1]->start;

  change_segment(win, segment);
  
  return TRUE;
}


gboolean
on_drawingarea14_motion_notify_event   (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int x = (int) event->x;
  file_segment_t** segment;
  double percent;
  long new_val;
  GtkWidget* win;
  
  segment = gtk_object_get_data(GTK_OBJECT(widget), "segment");
  if (!segment || segment[0]->socket) return FALSE;
  if (ev_button != 1 && ev_button != 3) return FALSE;

  if (x < 5) percent = 0.;
  else if (x > width-5) percent = 1.;
  else percent = (double)(x - 5)/(double)(width-10);
  new_val = segment[0]->start+percent*segment[0]->size;
  
  if (ev_button == 1) {
    segment[1]->stop = new_val;
    segment[1]->start = CLAMP(segment[1]->start, segment[0]->start,
			      segment[1]->stop);
  } else {
    segment[1]->start = new_val;
    segment[1]->stop = CLAMP(segment[1]->stop, segment[1]->start,
			     segment[0]->start+segment[0]->size);
  }
    
  win = lookup_widget(GTK_WIDGET(widget), "resume_options_win");
  segment[1]->size = segment[1]->stop-segment[1]->start;

  change_segment(win, segment);
  
  return TRUE;
}


void
on_button349_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* nentry;
  GtkWidget* centry;
  GtkWidget* temp;
  char* network;
  char* channels;
  net_t* net;
  char* pos;

  nentry = lookup_widget(global.win, "entry136");
  network = gtk_entry_get_text(GTK_ENTRY(nentry));
  if (!network || !(*network)) return;

  net = net_group_search_network(network);
  if (!net) return;

  centry = lookup_widget(global.win, "entry137");
  channels = gtk_entry_get_text(GTK_ENTRY(centry));
  if (channels) 
    make_list_from_string(&(net->auto_join), channels, " ");

  temp = lookup_widget(global.win, "combo_entry31");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (!l_strcasecmp(pos, "IRC"))
    net->type = NETWORK_IRC;
  else
    net->type = NETWORK_NAPSTER;
  
  server_save();
}


void
on_ctree10_tree_select_row             (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  net_t *net;
  GtkWidget* temp;
  GtkCTreeNode* node2;
  int depth = 0;

  node2 = GTK_CTREE_NODE(node);
  while ((node2 = GTK_CTREE_ROW(node2)->parent))
    depth++;

  if (depth != 1) return;

  net = gtk_ctree_node_get_row_data(ctree, GTK_CTREE_NODE(node));
  if (!net) return;

  temp = lookup_widget(global.win, "entry136");
  gtk_entry_set_text(GTK_ENTRY(temp), net->name);
  temp = lookup_widget(global.win, "entry137");
  gtk_entry_set_text(GTK_ENTRY(temp), 
		     make_string_from_list(net->auto_join, " "));

  temp = lookup_widget(global.win, "combo_entry31");
  switch (net->type) {
  case NETWORK_IRC:
    gtk_entry_set_text(GTK_ENTRY(temp), "IRC");
    break;
  case NETWORK_NAPSTER:
  default:
    gtk_entry_set_text(GTK_ENTRY(temp), "Napster");
    break;
  }

}


void
on_entry137_activate                   (GtkEditable     *editable ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  on_button349_clicked(NULL, NULL);
}


void
on_button350_clicked(GtkButton *button ATTR_UNUSED,
		     gpointer  user_data ATTR_UNUSED)
{
  resume_scan_dead();
}


void
on_clist39_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column ATTR_UNUSED,
                                        GdkEvent        *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  log_show_network(clist, row);
}


void
on_clist40_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column ATTR_UNUSED,
                                        GdkEvent        *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  log_show_file(clist, row);
}

void
on_checkbutton74_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data ATTR_UNUSED)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    global.options.search_show_folder = 1;
  } else {
    global.options.search_show_folder = 0;
  }
}


gboolean
on_clist40_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  lib_node_t *node;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  if (row == -1) return FALSE;

  global.popup_row = row;
  global.popup_list = widget;

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    node = gtk_clist_get_row_data(GTK_CLIST(widget),
				  global.popup_row);
    
    pop = create_log_popup(widget);
    if (pop) {
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }
  }

  return TRUE;
}


gboolean
on_drawingarea15_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int height = widget->allocation.height-1;
  int x = (int) event->x;
  int y = (int) event->y;
  int temp;
  
  deactivate_auto_afk();
  if (x < 0) x = 0;
  if (x > width) x = width;
  if (y < 0)
    return FALSE;
  if (y > height)
    return FALSE;

  // range from 0..20 
  // means: 2^10..2^30
  // means: 1KB - 1GB
  temp = (x*19+width/2)/width; 
  if (temp > 19) temp = 19;
  segment_size_show(widget, temp+1);
  
  return TRUE;
}


gboolean
on_drawingarea15_expose_event          (GtkWidget       *widget,
                                        GdkEventExpose  *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  int cnt = 0;
  long temp = global.limit.min_segment_size;

  while (temp > 1) {
    temp /= 2;
    cnt++;
  }
  segment_size_show(widget, cnt);

  return TRUE;
}


gboolean
on_drawingarea15_motion_notify_event   (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  int width = widget->allocation.width-1;
  int x = (int) event->x;
  int temp;
  
  deactivate_auto_afk();
  if (x < 0) x = 0;
  if (x > width) x = width;

  // range from 0..20 
  // means: 2^10..2^30
  // means: 1KB - 1GB
  temp = (x*19+width/2)/width; 
  if (temp > 19) temp = 19;
  segment_size_show(widget, temp+1);
  
  return TRUE;
}


void
on_entry141_activate (GtkEditable     *editable ATTR_UNUSED,
		      gpointer         user_data ATTR_UNUSED)
{
  char* ip;
  GtkWidget* wid;
  int ip1[4];
  int ip2[4];
  bannetworks_t* bn;
  int row;

  wid = lookup_widget(global.options_win, "entry140");
  ip = gtk_entry_get_text(GTK_ENTRY(wid));
  if (!ip || *ip == 0) return;
  if (sscanf(ip, "%d.%d.%d.%d", &ip1[0], &ip1[1],
	     &ip1[2], &ip1[3]) != 4) return;
  wid = lookup_widget(global.options_win, "entry141");
  ip = gtk_entry_get_text(GTK_ENTRY(wid));
  if (!ip || *ip == 0) return;
  if (sscanf(ip, "%d.%d.%d.%d", &ip2[0], &ip2[1], 
	     &ip2[2], &ip2[3]) != 4) return;

  wid = lookup_widget(global.options_win, "clist41");
  bn = l_malloc(sizeof(*bn));
  bn->ip_from = 
    (((unsigned long)ip1[0]) << 24) +
    (((unsigned long)ip1[1]) << 16) +
    (((unsigned long)ip1[2]) <<  8) +
    (((unsigned long)ip1[3])      );
  bn->ip_to = 
    (((unsigned long)ip2[0]) << 24) +
    (((unsigned long)ip2[1]) << 16) +
    (((unsigned long)ip2[2]) <<  8) +
    (((unsigned long)ip2[3])      );
  sprintf(tstr[0], "%d.%d.%d.%d", ip1[0], ip1[1], ip1[2], ip1[3]);
  sprintf(tstr[1], "%d.%d.%d.%d", ip2[0], ip2[1], ip2[2], ip2[3]);
  row = gtk_clist_append(GTK_CLIST(wid), list);
  gtk_clist_set_row_data_full(GTK_CLIST(wid), row, bn, l_free);
}

void
on_radiobutton6_toggled                (GtkToggleButton *togglebutton ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* temp;

  if (!global.options_win) return;

  temp = lookup_widget(global.options_win, "table11");
  gtk_widget_set_sensitive(GTK_WIDGET(temp), FALSE);
}


void
on_radiobutton7_toggled                (GtkToggleButton *togglebutton ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* temp;

  if (!global.options_win) return;

  temp = lookup_widget(global.options_win, "table11");
  gtk_widget_set_sensitive(GTK_WIDGET(temp), TRUE);
}


void
on_spinbutton74_changed                (GtkEditable     *editable ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "spinbutton74");
  global.limit.max_uploads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  check_uploads_again();
  setup_preferences(P_U_LIMIT);
}


void
on_spinbutton75_changed                (GtkEditable     *editable ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "spinbutton75");
  global.limit.default_uploads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  check_uploads_again();
  setup_preferences(P_U_ULIMIT);
}

void
on_scan_progress_win_destroy           (GtkObject       *object ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  scan_end(1);
}


gboolean
on_scan_progress_win_delete_event      (GtkWidget       *widget ATTR_UNUSED,
                                        GdkEvent        *event ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  scan_end(1);
  return TRUE;
}


void
on_button355_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  scan_start_real();
}


void
on_button354_clicked                   (GtkButton       *button ATTR_UNUSED,
                                        gpointer         user_data ATTR_UNUSED)
{
  scan_end(1);
}


gboolean
on_clist43_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  browse_t* browse;

  deactivate_auto_afk();
  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int) event->x, (int) event->y,
				      &row, &column))
      row = -1;

    global.popup_row = row;
    global.popup_list = widget;

    if (row != -1) {
      gtk_clist_select_row(GTK_CLIST(widget), row, 0);
      browse = gtk_clist_get_row_data(GTK_CLIST(global.popup_list),
				      global.popup_row);

      pop = create_saved_browse_popup(browse);
      if (pop) {
	gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		       event->button, event->time);
      }
    }
  }

  return TRUE;
}

gboolean
on_browse_tree_button_event(GtkWidget * widget,
			    GdkEventButton * event,
			    gpointer user_data) {
  GtkWidget *pop;
  int row, column;
  browse_t* browse = user_data;
  browse_node_t* node;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if (DOUBLE_CLICK(event, row)) return FALSE;

  if (event->button == global.options.popup_create) {
    if (row == -1) return FALSE;

    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    node = gtk_clist_get_row_data(GTK_CLIST(global.popup_list),
				  global.popup_row);
    pop = create_browse2_popup(browse, node);
    if (pop) {
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }
  }
  return TRUE;
}


void
on_spinbutton78_changed (GtkEditable     *editable ATTR_UNUSED,
			 gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "spinbutton78");
  global.limit.max_downloads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  setup_preferences(P_D_LIMIT);
}

void
on_spinbutton79_changed (GtkEditable     *editable,
			 gpointer         user_data ATTR_UNUSED)
{
  global.limit.default_downloads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));
  setup_preferences(P_D_ULIMIT);
}

void
on_checkbutton68_toggled (GtkToggleButton *togglebutton,
			  gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (!global.options_win) return;

  temp = lookup_widget(global.options_win, "combo41");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

void
on_button357_clicked(GtkButton       *button ATTR_UNUSED,
		     gpointer         user_data ATTR_UNUSED)
{
  on_entry141_activate(NULL, NULL);
}


void
on_button358_clicked (GtkButton       *button ATTR_UNUSED,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkCList *clist;
  GList *row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist41"));
  while ((row_list = clist->selection) != NULL) {
    row = (int) row_list->data;
    gtk_clist_remove(clist, row);
  }
}

void
on_button359_clicked  (GtkButton       *button,
		       gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  GtkWidget *temp;

  temp = lookup_widget(global.win, "label2680");
  gtk_widget_set_style(temp, global.styles[STYLE_TAB1]);

  deactivate_auto_afk();

  if (!global.user_reply.user) return;

  pop = create_user_popup(M_REPLY, &global.user_reply);
  if (pop) {
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		   (GtkMenuPositionFunc) popup_position, button, 1, 0);
  }
}


void
on_button185_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_mode_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}


void
on_button187_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  net_t* net;
  static GList* net_list = NULL;

  deactivate_auto_afk();
  if (global.current_page)
    net = global.current_page->net;
  else net = NULL;

  if (net_list) g_list_free(net_list);
  net_list = NULL;
  if (net) net_list = g_list_append(net_list, net);

  pop = create_network_popup(NULL, net_list, 1);
  if (pop) {
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		   (GtkMenuPositionFunc) popup_position, button, 1, 0);
  }
}


void
on_button345_clicked  (GtkButton       *button,
		       gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_stats_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position, button, 1, 0);
}


void
on_button316_clicked(GtkButton       *button,
		     gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_advanced_popup();
  if (!pop) return;
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void
on_button216_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_ul_remove_popup(global.options.ul_autoremove);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void
on_button356_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_advanced_popup2(global.options.auto_retry);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void
on_button215_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_retry_popup(global.options.auto_retry);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}

void
on_button214_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;

  deactivate_auto_afk();
  pop = create_dl_remove_popup(global.options.dl_autoremove);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void
on_button360_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  int value;
  GtkWidget *pop;

  deactivate_auto_afk();
  value = (int) gtk_object_get_data(GTK_OBJECT(button), "value");

  pop = create_pipe_popup(value);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void
on_button189_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  static char user[1000];
  static net_user_t nu;
  GtkWidget* temp;

  deactivate_auto_afk();
  temp = lookup_widget(global.whois_win, "label527");
  strcpy(user,GTK_LABEL(temp)->label);
  nu.user = user;
  nu.net = gtk_object_get_data(GTK_OBJECT(global.whois_win), "network");

  pop = create_user_popup(M_WHOIS, &nu);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}


void
on_button346_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  net_t* net;

  deactivate_auto_afk();
  net = gtk_object_get_data(GTK_OBJECT(global.whois_win), "network");

  pop = create_join_popup(net);
  if (pop)
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		   (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}

void
on_button361_clicked (GtkButton       *button,
		      gpointer         user_data ATTR_UNUSED)
{
  int value;
  GtkWidget *pop;

  deactivate_auto_afk();
  value = (int) gtk_object_get_data(GTK_OBJECT(button), "value");

  pop = create_pipe2_popup(value);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc) popup_position2, button, 1, 0);
}

void
on_combo_entry33_changed (GtkEditable     *editable,
			  gpointer         user_data ATTR_UNUSED)
{
  char* text;

  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if (!text || *text == 0) return;
  search_show_template(text);
}


void
on_combo_entry28_changed (GtkEditable     *editable ATTR_UNUSED,
			  gpointer         user_data ATTR_UNUSED)
{
  setup_search_fields();
}

void
on_checkbutton83_toggled (GtkToggleButton *togglebutton,
			  gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "combo43");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}


gboolean
on_clist39_button_press_event(GtkWidget       *widget,
			      GdkEventButton  *event,
			      gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *pop;
  int row, column;
  lib_node_t *node;

  deactivate_auto_afk();
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int) event->x, (int) event->y,
				    &row, &column))
    row = -1;
  if (row == -1) return FALSE;

  global.popup_row = row;
  global.popup_list = widget;

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row(GTK_CLIST(widget), row, 0);
    node = gtk_clist_get_row_data(GTK_CLIST(widget),
				  global.popup_row);
    
    pop = create_log2_popup(widget);
    if (pop) {
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }
  }

  return TRUE;
}


void
on_checkbutton88_toggled(GtkToggleButton *togglebutton,
			 gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "entry155");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

void
on_checkbutton89_toggled(GtkToggleButton *togglebutton,
			 gpointer         user_data ATTR_UNUSED)
{
  GtkWidget *temp;

  if (!global.options_win) return;

  temp = lookup_widget(global.options_win, "combo44");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}


gboolean
on_drawingarea3_button_press_event     (GtkWidget       *widget ATTR_UNUSED,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* pop;

  if (!global.statistic.band[0]) return FALSE;

  pop = create_band_popup(global.statistic.band[0]);
  if (pop)
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  return TRUE;
}


gboolean
on_drawingarea4_button_press_event     (GtkWidget       *widget ATTR_UNUSED,
                                        GdkEventButton  *event,
                                        gpointer         user_data ATTR_UNUSED)
{
  GtkWidget* pop;

  if (!global.statistic.band[1]) return FALSE;

  pop = create_band_popup(global.statistic.band[1]);
  if (pop)
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  return TRUE;
}


void
on_ctree8_drag_begin(GtkWidget       *widget,
		     GdkDragContext  *drag_context,
		     gpointer         user_data ATTR_UNUSED)
{
  GtkCTreeNode* node;
  file_node_t* fnode;

  if (!GTK_CLIST(widget)->selection) return;
  node = GTK_CTREE_NODE(GTK_CLIST(widget)->selection->data);
  if (!node) return;
  fnode = gtk_ctree_node_get_row_data(GTK_CTREE(widget), node);
  if (!fnode) return;
  g_dataset_set_data (drag_context, "selected_dir", fnode);
}


void
on_ctree8_drag_data_get (GtkWidget       *widget ATTR_UNUSED,
			 GdkDragContext  *drag_context,
			 GtkSelectionData *data,
			 guint            info ATTR_UNUSED,
			 guint            time ATTR_UNUSED,
			 gpointer         user_data ATTR_UNUSED)
{
  file_node_t* node;

  node = g_dataset_get_data (drag_context, "selected_dir");
  if (node) {
    gtk_selection_data_set (data, gdk_atom_intern("files", TRUE),
			    GTK_TYPE_POINTER, (void*)(&node),
			    sizeof(node));
  }
}


void
on_ctree8_drag_end(GtkWidget       *widget ATTR_UNUSED,
		   GdkDragContext  *drag_context ATTR_UNUSED,
		   gpointer         user_data ATTR_UNUSED)
{
}

