#include <stdio.h>
#include <string.h>
#include "tlmpmod.h"

struct TLMP_MODULE_PRIVATE{
	_F_TLMP_MODULE *c;
	SSTRING modname;
};


PUBLIC TLMP_MODULE::TLMP_MODULE(
	_F_TLMP_MODULE &_c,
	const char *modname,
	const char *pkgrev)
	: LINUXCONF_MODULE(modname)
{
	priv = new TLMP_MODULE_PRIVATE;
	priv->c = &_c;
	priv->modname.setfrom(modname);
	linuxconf_loadmsg (modname,pkgrev);
	priv->c->init();
}

void _F_TLMP_MODULE::init ()
{
}

void _F_TLMP_MODULE::setmenu (M_DIALOG &, MENU_CONTEXT)
{
}

PUBLIC void TLMP_MODULE::setmenu (
	M_DIALOG &dia,
	MENU_CONTEXT context)
{
	priv->c->setmenu (dia,context);
}

int _F_TLMP_MODULE::domenu (MENU_CONTEXT,const char *)
{
	return LNCF_NOT_APPLICABLE;
}


PUBLIC int TLMP_MODULE::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	return priv->c->domenu (context,key);
}

int _F_TLMP_MODULE::dohtml (const char *)
{
	return LNCF_NOT_APPLICABLE;
}


PUBLIC int TLMP_MODULE::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (priv->modname.cmp(key)==0){
		ret = priv->c->dohtml (key);
	}
	return ret;
}

int _F_TLMP_MODULE::message (const char *, int argc, const char *argv[])
{
	return LNCF_NOT_APPLICABLE;
}


PUBLIC int TLMP_MODULE::message (
	const char *msg,
	int argc,
	const char *argv[])
{
	return priv->c->message(msg,argc,argv);
}

void _F_TLMP_MODULE::printusage()
{
	SSTRINGS tb;
	usage(tb);
	for (int i=0; i<tb.getnb(); i++){
		fprintf (stderr,"%s\n",tb.getitem(i)->get());
	}
}


PUBLIC void TLMP_MODULE::usage(SSTRINGS &tb)
{
	priv->c->usage(tb);
}

int _F_TLMP_MODULE::execmain (const char *, int, char *[], bool)
{
	return LNCF_NOT_APPLICABLE;
}
int _F_TLMP_MODULE::othermain (const char *, int, char *[], bool)
{
	return LNCF_NOT_APPLICABLE;
}


PUBLIC int TLMP_MODULE::execmain (int argc , char *argv[], bool standalone)
{
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	int ret = LNCF_NOT_APPLICABLE;
	if (priv->modname.cmp(pt)==0){
		ret = priv->c->execmain (pt,argc,argv,standalone);
	}else{
		ret = priv->c->othermain (pt,argc,argv,standalone);
	}
	return ret;
}


int _F_TLMP_MODULE::probe(int, int, bool)
{
	return 0;
}


PUBLIC int TLMP_MODULE::probe (
	int level,	// Current level being probed
			// Only service of this level should do something.
	int target,	// target network runlevel of the probe
			// In which runlevel the machine is going to be
			// after the probe has completed
	bool simulation )	// simulation mode ?
{
	return priv->c->probe (level,target,simulation);
}

