#!/bin/sh
# Install an anonymous ftp root using a reference version
# $1 is the source/reference $2 is the directory
if [ $# != 2 ] ; then
	install-anom-ftp.sh reference-dir new-dir
elif [ ! -d $1 ] ; then
	echo directory $1 does not exist
else
	SRC=$1
	DST=$2
	copyif(){
		if [ -d $1 ] ; then
			cp -a $1 $DST/.
		fi
	}
	mkdir -p $2
	chown root.root $2
	chmod 755 $2
	cd $1
	copyif bin
	copyif lib
	copyif usr
	copyif dev
	copyif etc
	mkdir $2/pub
	chmod 755 $2/pub
fi

