
#include <stdio.h>
#include <string.h>
#include "wineconf.h"
#include "wineconf.m"

#include <unistd.h>
#include <sys/types.h>

#include "wineconf_global_defs.h"
#include "wineconf_menu_drives.cc"
#include "wineconf_internal_dirs.cc"
#include "wineconf_devices.cc"
#include "wineconf_advanced.cc"
#include "wineconf_appbehaviour.cc"

/* note: if is_global !=0 then user_name is not used */
void manage_main_window(CONFIG_FILE &cf_wineconf, int needs_root_access, int is_global, const char *user_name)
{
    VIEWITEMS_PARSER pre_vitems_wineconf;
    VIEWITEMS vitems_wineconf(pre_vitems_wineconf);
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;
    int    may_i_enter=0;
    SSTRING my_title, my_intro;

    if(is_global){
        my_title.setfrom(MSG_U(T_GLOBALWINECONFIG, "Global Wine configuration"));
        my_intro.setfrom(MSG_U(X_GLOBALWINECONFIG, "Note: these settings affects only the users\nwhich haven't their own personal Wine configuration.\n"));
    }else{
        my_title.setfromf(MSG_U(T_WINEUSERCONFIG, "Wine configuration for \"%s\""), user_name);
        my_intro.setfrom(MSG_U(X_WINEUSERCONFIG, "Note: the global settings\nwill NOT affect this user.\n"));
    }

    pre_vitems_wineconf.linecont=false;
    vitems_wineconf.read(cf_wineconf);// load variables with data from file

    dia_mymenu.new_menuitem("", MSG_U(M_DRIVESASSIGNMENTS, "Virtual Drives"));
    dia_mymenu.new_menuitem("", MSG_U(M_INTERNALDIRS, "Internal Directories"));
    dia_mymenu.new_menuitem("", MSG_U(M_DEVICES, "Assigned devices"));
    dia_mymenu.new_menuitem("", MSG_U(M_APPSBEHAVIOUR, "Application behavior under Wine")); // includes appearance config
    dia_mymenu.new_menuitem("", MSG_U(M_ADVOPTS, "Advanced options"));
//    dia_mymenu.new_menuitem("", "Easy Configuration");

    while(1){
//        MSG_U(I_WINECONFIGURATOR, "If you're configurating Wine for the first time\nyou may want to try the \"Easy Configuration\" option below.")
        if(is_global){
            my_button=dia_mymenu.editmenu(my_title.get(), my_intro.get(), help_nil, my_selection, MENUBUT_QUIT);
        }else{
            my_button=dia_mymenu.editmenu(my_title.get(), my_intro.get(), help_nil, my_selection, MENUBUT_QUIT|MENUBUT_DEL);
        }

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_DEL:
            {
                SSTRING my_text;

                my_text.setfromf(MSG_U(X_REMOVEUSERCONFIG, "You're about to remove the Wine settings\nfor the user \"%s\".\n\nWine will use the global settings\nfor this user if you decide to proceed.\n\nConfirm these settings' removal?\n\n"), user_name);
                if(dialog_yesno(MSG_U(T_REMOVUSERCONFIG, "Removing configuration"), my_text.get(), help_nil)==MENU_YES){
                    cf_wineconf.unlink();
                    return;
                }
            }
            break;
        default:
            break;
        }

        /* user selected some menu option.. */

        if(needs_root_access){
            if(perm_rootaccess(""))
                may_i_enter=1;
        } else {
            may_i_enter=1;
        }

        if(may_i_enter){
            switch(my_selection){
            case 0:
                manage_drives_settings(vitems_wineconf, cf_wineconf);
                break;
            case 1:
                manage_internal_directories_settings(vitems_wineconf, cf_wineconf);
                break;
            case 2:
                manage_devices_settings(vitems_wineconf, cf_wineconf);
                break;
            case 3:
                manage_application_behaviour(vitems_wineconf, cf_wineconf);
                break;
            case 4:
                manage_advanced_options(vitems_wineconf, cf_wineconf);
                break;
            case 5:
            //            easy_configuration_menu();
                break;
            }
        }
    }
}

void root_loop(void)
{
    /* builds dialog */
    MENU_STATUS my_button=MENU_STATUS(0);
    DIALOG my_dialog;
    FIELD_LIST *fl_users;
    char selected_type='\0'; // 0-main 1-some user's
    SSTRINGS usernames, homedirs;
    int is_global;
    SSTRING return_username, return_homepath;

    return_userlist_homedir(usernames, homedirs);
    if(!usernames.getnb()){
        return_username.setfrom("");
    }else{
        return_username.setfrom(usernames.getitem(0)->get());
    }
    my_dialog.newf_radio("", selected_type, 0, MSG_U(F_SELECTGLOBALCONFIG, "Global configuration"));
    my_dialog.newf_radio("", selected_type, 1, MSG_U(F_SELECTUSERCONFIG, "Configuration for user:"));
    fl_users=my_dialog.newf_list("", return_username);
    dump_sstrings_to_fieldlist(usernames, fl_users);

    while(1){
        /* displays dialog */
        my_button=my_dialog.edit(MSG_U(T_WINECONFIGURATOR, "Wine configurator"), MSG_U(I_SELECTWHAT2CONFIGURE, "Select what to configure.\n(user configuration, when present,\noverrides the global configuration)"), help_nil);
        if(my_button==MENU_ACCEPT){
            if(!selected_type){
                is_global=1;
            }else{
                is_global=0;
            }
            return_homepath.setfrom(homedirs.getitem(usernames.lookup(return_username.get()))->get());
        }else{
            return; // user cancelled dialog
        }

        /* ok, user selected something */
        if(is_global){
            manage_main_window(cf_etcwineconf, 1, 1, "");
        }else{
            SSTRING filename_fullpath;
            filename_fullpath.setfromf("%s/%s", return_homepath.get(), ".winerc");
            CONFIG_FILE cf_userwineconf(filename_fullpath.get(), help_nil, CONFIGF_MANAGED|CONFIGF_OPTIONAL);

            if(!cf_userwineconf.exist()){ // uh, oh! this file does NOT exist!
                if(dialog_yesno(MSG_U(T_NOWINECONFIG, "No Wine configuration"), MSG_U(X_NOWINECONFIG, "No personal Wine configuration for this user.\n\nDo you want to create a new one and edit?\n(the settings will be copied\nfrom the global configuration)\n\nIf you decide to do so the global configuration\nwill no longer affect this user.\n\n"), help_nil)==MENU_YES){
                    if(!copy_configfile_into_another(cf_etcwineconf, cf_userwineconf))
                       manage_main_window(cf_userwineconf, 1, 0, return_username.get());
                }
            }else{
                manage_main_window(cf_userwineconf, 1, 0, return_username.get());
            }
        }
    }
}

void start_as_standalone(void)
{
    SSTRING my_username, my_homepath;
    SSTRING filename_fullpath;

    get_current_user_homepath(my_username, my_homepath);
    filename_fullpath.setfromf("%s/%s", my_homepath.get(), ".winerc");
    CONFIG_FILE cf_userwineconf(filename_fullpath.get(), help_nil, CONFIGF_MANAGED|CONFIGF_OPTIONAL);
    if(!cf_userwineconf.exist()){ // uh, oh! this file does NOT exist!
        if(!copy_configfile_into_another(cf_etcwineconf, cf_userwineconf))
        {
            manage_main_window(cf_userwineconf, 0, 0, my_username.get());
        }
    }else{
        manage_main_window(cf_userwineconf, 0, 0, my_username.get());
    }
}

void start_things(void)
{
    root_loop();
}

