#include <stdio.h>
#include <string.h>
#include <misc.h>
#include "internal.h"
#include "uucp.h"
#include "uucp.m"
#include "../paths.h"

extern UUCP_HELP_FILE help_uucp;
static CONFIG_FILE f_poll (VAR_LIB_UUCP_POLL
	,help_uucp
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
	,"uucp","uucp",0660,subsys_uucp);


PUBLIC POLL::POLL (const char *_system)
{
	system.setfrom (_system);
}

PUBLIC POLL::POLL (const POLL *p)
{
	system.setfrom(p->system);
	sched.setfrom (p->sched);
}

PUBLIC POLL::POLL (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	comments.setfrom (_comments);
	comments.strip_end();
	err[0] = '\0';
	buf = system.copyword (buf);
	buf = str_skip(buf);
	sched.setfrom (buf);
}

/*
	Write one record in the Permissions file
*/
PUBLIC void POLL::write (FILE_CFG *fout)
{
	comment_write (comments,fout);
	fprintf (fout,"%s\t%s\n",system.get(),sched.get());
}

PUBLIC POLLS::POLLS()
	: CONFIG_OBJS (f_poll)
{
}

PUBLIC POLL *POLLS::getitem(int no)
{
	return (POLL*)ARRAY::getitem(no);
}

/*
	Locate one machine Permission spec
*/
PUBLIC POLL *POLLS::getitem(const char *system)
{
	int n = getnb();
	POLL *ret = NULL;
	for (int i=0; i<n; i++){
		POLL* p = getitem(i);
		if (p->system.cmp(system)==0){
			ret = p;
			break;
		}
	}
	return ret;
}

PUBLIC void POLLS::delsystem (const char *system)
{
	POLL *p = getitem(system);
	remove_del (p);
}

PROTECTED CONFIG_OBJ *POLLS::newobj (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	return new POLL (buf,_comments,err);
}



