#!/bin/bash
# This script will synchronise the bookmarks of a bunch of users
# it expect the name of the reference user as the first argument.
if [ $# -lt 3 ] ; then
	echo install-bookmark.sh ref-user -- user1 user2 ...
	exit 1
else
	refuser=$1
	shift
	if [ "$1" != "--" ] ; then
		echo install-bookmark.sh ref-user -- user1 user2 ...
		exit 1
	else
		# Playing games with bash so that is maps ~$refuser to the home
		# directory of $refuser
		HOMEREF=`eval echo ~$refuser`		
		shift
		for user in $*
		do
			echo Updating "$user's bookmarks from $refuser"
			HOMEUSER=`eval echo ~$user`
			mkdir $HOMEUSER/.netscape
			chown $user $HOMEUSER/.netscape
			cp $HOMEREF/.netscape/bookmarks.html $HOMEUSER/.netscape/bookmarks.html
			chown $user $HOMEUSER/.netscape/bookmarks.html
		done
	fi
fi

