#
# Support functions for linuxconf perl modules
#
# shellmod-lib.pl 1.6 1999/12/01 19:42:42
#
# Written by David Hinds, dhinds@valinux.com
#

# Force flushing of standard output
$| = 1;

use IO::Handle;

if ($DBGSHELLMOD) {
    open(LOG, ">/tmp/shellmod.log");
    LOG->autoflush(1);
}

sub dispatch
{
    my(%var) = ();
    print LOG "dispatch\n";
    while (<STDIN>) {
	chop;
	exit if (/^$/);
	last if (/^go$/);
	if (/^exec cd (.*)/) {
	    print LOG "chdir($1);\n" if ($DBGSHELLMOD);
	    chdir($1);
	    print "endscope\n";
	} elsif (/^(\w+)=(.*)/) {
	    print LOG "\$$_;\n" if ($DBGSHELLMOD);
	    my($n,$v) = ($1,$2);
	    $v = $1 if ($v =~ /^'(.*)'\s*$/);
	    $var{$n} = $v;
	} else {
	    s/exec (\w+) [^"](.*)[^"]/\1 "\2"/;
	    s/" "/", "/g;
	    print LOG "$_;\n" if ($DBGSHELLMOD);
	    eval("$_;");
	    print "endscope\n";
	}
    }
    return %var;
}

sub vreg_do
{
	print "vreg_do\n";
	dispath
}

sub do_cmd
{
    print shift(@_);
    foreach (@_) { print " \"$_\""; }
    print "\n";
}

# Shorthand functions for all the shellmod protocol commands

sub dialog		{ print "DIALOG\n"; }
sub dialog_menu		{ print "DIALOG_MENU\n"; }
sub dialog_list		{ print "DIALOG_LIST\n"; }
sub dialog_liste	{ print "DIALOG_LISTE\n"; }
sub regmenu		{ do_cmd("regmenu", @_); }
sub comanager	{ do_cmd("comanager", @_); }
sub error		{ do_cmd("error", @_); }
sub retcode		{ do_cmd("retcode", @_); }
sub notice		{ do_cmd("notice", @_); }
sub defval		{ do_cmd("defval", @_); }
sub new_menuitem	{ do_cmd("new_menuitem", @_); }
sub editmenu		{ do_cmd("editmenu", @_); }
sub edit		{ do_cmd("edit", @_); }
sub show		{ do_cmd("show", @_); }
sub enumitem		{ do_cmd("enumitem", $_) foreach (@_); }
sub listitem		{ do_cmd("listitem", $_) foreach (@_); }
sub comboitem		{ do_cmd("comboitem", $_) foreach (@_); }
sub newf_head		{ do_cmd("newf_head", @_); }
sub newf_title		{ do_cmd("newf_title", @_); }
sub newf_enum		{ do_cmd("newf_enum", @_); }
sub newf_combo		{ do_cmd("newf_combo", @_); }
sub newf_chk		{ do_cmd("newf_chk", @_); }
sub newf_chkm		{ do_cmd("newf_chkm", @_); }
sub newf_str		{ do_cmd("newf_str", @_); }
sub newf_pass		{ do_cmd("newf_pass", @_); }
sub newf_list		{ do_cmd("newf_list", @_); }
sub newf_radio		{ do_cmd("newf_radio", @_); }
sub newf_num		{ do_cmd("newf_num", @_); }
sub newf_gauge		{ do_cmd("newf_gauge", @_); }
sub newf_slider		{ do_cmd("newf_slider", @_); }
sub newf_dbl		{ do_cmd("newf_dbl", @_); }
sub newf_hexnum		{ do_cmd("newf_hexnum", @_); }
sub end			{ print "end\n"; }

sub yesno
{
    do_cmd("yesno", @_);
    my(%f) = dispatch();
    return $f{CODE};
}

1;
