#pragma interface
#ifndef PROTOCOL_H
#define PROTOCOL_H

#include <time.h>

#ifndef POPEN_H
	#include <popen.h>
#endif


class SHELL_DIALOG;

class SHELL_DIALOGS: public ARRAY{
public:
	/*~PROTOBEG~ SHELL_DIALOGS */
public:
	SHELL_DIALOG *getitem (int no)const;
	/*~PROTOEND~ SHELL_DIALOGS */
};


class MENUENTRIES;
class COMANAGERS;
class DICTIONARY;

class SHELL_INSTANCE{
	POPEN pop;
	SHELL_DIALOGS dias;
	/*~PROTOBEG~ SHELL_INSTANCE */
public:
	SHELL_INSTANCE (const char *path);
	int collect (MENUENTRIES&entries,
		 COMANAGERS&managers);
	int comanage (DIALOG *dia,
		 DICTIONARY&dict,
		 const char *func_prefix,
		 const char *func_suffix,
		 int *nof);
private:
	void dump (void);
public:
	bool isalive (void);
private:
	int parse (MENUENTRIES *entries,
		 COMANAGERS *managers,
		 int *nof);
	int parse_butopt (const char *s,
		 SHELL_DIALOG *sdia);
public:
	int runfunc (const char *key);
	void sendvar (const char *var, const char *val);
	/*~PROTOEND~ SHELL_INSTANCE */
};

class MENUENTRY: public ARRAY_OBJ{
public:
	SSTRING title;			// Title of the menu
	SSTRING func;			// Function to call in the script to execute
							// the menu entry
	SSTRING context;		// MENU context or menu NAME where we
							// register this entry
	/*~PROTOBEG~ MENUENTRY */
public:
	MENUENTRY (const char *_func,
		 const char *_context,
		 const char *_title);
	/*~PROTOEND~ MENUENTRY */
};
class MENUENTRIES: public ARRAY{
	/*~PROTOBEG~ MENUENTRIES */
public:
	MENUENTRY *getitem (int no)const;
	/*~PROTOEND~ MENUENTRIES */
};

class COMANAGER: public ARRAY_OBJ{
public:
	SSTRING dialog;			// Dialog in which this shell act as a co-manager
	SSTRING func;			// Prefix of the function to call for the different
							// part of the co-manager process (setup,validate,save)
	/*~PROTOBEG~ COMANAGER */
public:
	COMANAGER (const char *_func, const char *_dialog);
	/*~PROTOEND~ COMANAGER */
};

class COMANAGERS: public ARRAY{
	/*~PROTOBEG~ COMANAGERS */
public:
	COMANAGER *getitem (int no)const;
	/*~PROTOEND~ COMANAGERS */
};

class SHELLMOD: public ARRAY_OBJ{
public:
	SSTRING path;
	MENUENTRIES entries;
	COMANAGERS managers;
	time_t revdate;		// Revision date of the script
	SHELL_INSTANCE *instance;
	/*~PROTOBEG~ SHELLMOD */
public:
	SHELLMOD (const char *_path);
	int collect (void);
	int deluser (DICTIONARY&dict,
		 const char *func_prefix);
	void exec (const char *func);
private:
	SHELL_INSTANCE *newinst (void);
public:
	int save (DICTIONARY&dict, const char *func_prefix);
	void setupdia (DICTIONARY&dict,
		 const char *func_prefix,
		 DIALOG&dia);
	int validate (DICTIONARY&dict,
		 const char *func_prefix,
		 int &nof);
	void write (void);
	/*~PROTOEND~ SHELLMOD */
};

class SHELLMODS: public ARRAY{
	/*~PROTOBEG~ SHELLMODS */
public:
	SHELLMODS (void);
	SHELLMOD *getitem (int no)const;
	int write (void);
	/*~PROTOEND~ SHELLMODS */
};

#endif

