#include <usercomng.h>
#include "shellmod.h"
#include "protocol.h"
#include "shellmod.m"

class MODULES_COMNG: public USERACCT_COMNG{
	SHELLMOD  *mod;	// Shell module handling this comanager
	COMANAGER *mng;	// Specific comanager inside this shell
	/*~PROTOBEG~ MODULES_COMNG */
public:
	MODULES_COMNG (SHELLMOD *_mod,
		 COMANAGER *_mng,
		 DICTIONARY&_dict);
	int deluser (PRIVILEGE *);
	int save (PRIVILEGE *);
	void setupdia (DIALOG&dia);
	int validate (DIALOG&, int &nof);
	/*~PROTOEND~ ALIAS_COMNG */
};


PUBLIC MODULES_COMNG::MODULES_COMNG(
	SHELLMOD *_mod,
	COMANAGER *_mng,
	DICTIONARY &_dict)
	: USERACCT_COMNG (_dict)
{
	mod = _mod;
	mng = _mng;
}

PUBLIC void MODULES_COMNG::setupdia (
	DIALOG &dia)
{
	mod->setupdia (dict,mng->func.get(),dia);
}	

PUBLIC int MODULES_COMNG::save(
	PRIVILEGE *)
{
	return mod->save (dict,mng->func.get());
}

PUBLIC int MODULES_COMNG::validate(
	DIALOG &,
	int &nof)
{
	return mod->validate (dict,mng->func.get(),nof);
}

PUBLIC int MODULES_COMNG::deluser (
	PRIVILEGE *)
{
	return mod->deluser (dict,mng->func.get());
}

USERACCT_COMNG *modules_newcomng(
	const char *key,
	DICTIONARY &dict)
{
	USERACCT_COMNG *ret = NULL;
	modules_loadcur();
	bool found = false;
	extern SHELLMODS *cur;
	for (int i=0; i<cur->getnb() && !found; i++){
		SHELLMOD *mod = cur->getitem(i);
		for (int j=0; j<mod->managers.getnb(); j++){
			COMANAGER *mng = mod->managers.getitem(j);
			if (mng->dialog.cmp(key)==0){
				ret = new MODULES_COMNG (mod,mng,dict);
				found = true;
				break;
			}
		}
	}
	return ret;
}

static REGISTER_USERACCT_COMNG xxx (modules_newcomng);

