#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <errno.h>

static char *check_read (FILE *fin)
{
	char *ret = NULL;
	int size = 0;
	int maxsize = 0;
	char  buf[1000];
	while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
		if (buf[0] == '[' && strncmp(buf,"[global]",8)!=0) break;
		int len = strlen(buf);
		if (size + len >= maxsize){
			maxsize += 8192;
			ret = (char*)realloc (ret,maxsize);
			if (ret == NULL){
				fprintf (stderr,"samba-check: Out of memory\n");
				exit (-1);
			}
		}
		strcpy (ret + size,buf);
		size += len;
	}
	return ret;
}
/*
	Read the effective samba configuration, but only the global section
*/
static char *check_readconf ()
{
	char *ret = NULL;
	FILE *fin = popen ("/usr/bin/testparm -s","r");
	if (fin == NULL){
		fprintf (stderr,"Can't execute /usr/bin/testparm (%s)\n",strerror(errno));
	}else{
		ret = check_read (fin);
		pclose (fin);
	}
	return ret;
}	

/*
	Read the content of a file
*/
static char *check_readfile (const char *file)
{
	char *ret = NULL;
	FILE *fin = fopen (file,"r");
	if (fin == NULL){
		fprintf (stderr,"Can't read file %s (%s)\n",file,strerror(errno));
	}else{
		ret = check_read (fin);
		fclose (fin);
	}
	return ret;
}	
		

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc == 3 && strcmp(argv[1],"--logstart")==0){
		char *conf = check_readconf();
		if (conf != NULL){
			FILE *fout = fopen (argv[2],"w");
			if (fout == NULL){
				fprintf (stderr,"Can't open log file %s (%s)\n",argv[2]
					,strerror(errno));
			}else{
				fputs (conf,fout);
				ret = fclose (fout);
				chmod (argv[2],0600);
			}
			free (conf);
		}
	}else if (argc == 3 && strcmp(argv[1],"--test")==0){
		char *conf = check_readconf();
		char *oldconf = check_readfile (argv[2]);
		if (conf != NULL
			&& oldconf != NULL){
			ret = 0;
			if (strcmp(conf,oldconf)!=0){
				printf ("restart\n");
			}
		}
		free (conf),
		free (oldconf);
	}else{
		fprintf (stderr
			,"samba-check --logstart log-file\n"
			 "    Must be called when samba is started\n"
			 "    Log file will contain relevant information\n"
			 "samba-check --test log-file\n"
			 "    The content of the log-file (created by logstart)\n"
			 "    will be compared with the current state\n"
			 "    restart will be echoed if they differs\n");
	}
}

