
/* this configuration deals with the 'naslist' file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_tools.h"

void edit_naslist_entry(VIEWITEMS &given_vitems, int which_one)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     dialog_title;

    /* loads vars.. */
    /* builds gui.. */
    EASY_STR2(hstname,0,MSG_U(F_HOSTNAMEORIP2,"Host name (or IP):"));
    EASY_STR2(shortname,1,MSG_U(F_SHORTNAME,"Short name:"));
    EASY_FC2(c_nastype,nastype,2,MSG_U(F_TYPE,"Type:"));
    EASY_ADD_FC(c_nastype,"cisco");
    EASY_ADD_FC(c_nastype,"computone");
    EASY_ADD_FC(c_nastype,"livingston");
    EASY_ADD_FC(c_nastype,"max40xx");
    EASY_ADD_FC(c_nastype,"multitech");
    EASY_ADD_FC(c_nastype,"pathras");
    EASY_ADD_FC(c_nastype,"portslave");
    EASY_ADD_FC(c_nastype,"tc");
    EASY_ADD_FC(c_nastype,"usrhiper");
    EASY_ADD_FC(c_nastype,"other");

    while(1){
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_NASENTRYN,"NAS entry %d"), which_one+1);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), "", hf_naslist, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                /* save vars.. */
                SSTRING my_line;

                if((invalid_entry(hstname.get()))||(invalid_entry(shortname.get()))||(invalid_entry(nastype.get()))){
                    informative_window(MSG_U(T_INVALIDENTRY4,"Invalid entry"), MSG_U(E_INVALIDENTRY4,"None of these fields may be left empty\nneither have space characters."));
                }else{
                    my_line.setfromf("%s\t%s\t%s", hstname.get(), shortname.get(), nastype.get());
                    given_vitems.getitem(which_one)->line.setfrom(my_line);
                    given_vitems.write(cf_naslist, 0);
                    return;
                }
            }
            break;
        case MENU_DEL:
            /* remove this entry */
            given_vitems.remove_del(which_one);
            given_vitems.write(cf_naslist, 0);
            return;
            break;
        default:
            break;
        }
    }

}

void show_nas_list(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    my_vitems.read(cf_naslist);

    my_dialog.newf_head("", MSG_U(F_NASNAMESHORTNAMETYPE,"NAS name\tshort name\ttype"));

    while(1){
        int         progressive_counter=0,
                    regressive_counter;
        SSTRING     primary_entry, secondary_entry1,
                    secondary_entry2,
                    secondary_entry;

        /* fills list.. */
        regressive_counter=my_vitems.getnb();
        while(regressive_counter--){
            gimme_word_from_string(my_vitems.getitem(progressive_counter)->line.get(), primary_entry, 0);
            gimme_word_from_string(my_vitems.getitem(progressive_counter)->line.get(), secondary_entry1, 1);
            gimme_word_from_string(my_vitems.getitem(progressive_counter)->line.get(), secondary_entry2, 2);
            secondary_entry.setfromf("%s\t%s", secondary_entry1.get(), secondary_entry2.get());
            my_dialog.set_menuitem(progressive_counter, primary_entry.get(), secondary_entry.get());
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_LISTOFNASES,"List of NASes"), MSG_U(I_LISTOFNASES,"This file contains a list of NASes\n(Network Access Servers, also known\nas terminal servers) which we know."), hf_general_list, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int how_many;

                how_many=my_vitems.getnb();
                my_vitems.add(new VIEWITEM(MSG_U(X_NEWENTRY_JUSTADDED2,"new_entry.just_added")));
                edit_naslist_entry(my_vitems, how_many);
                my_vitems.write(cf_naslist, 0);
            }
            break;
        default:
            edit_naslist_entry(my_vitems, my_selection);
            break;
        }
    }


}






/* kak u nas? khorosho.. */
