#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pythonmod.h"
#include "pythonmod.m"
#include <dlfcn.h>

MODULE_DEFINE_VERSION(pythonmod);

PUBLIC MODULE_pythonmod::MODULE_pythonmod()
	: LINUXCONF_MODULE("pythonmod")
{
	linuxconf_loadmsg ("pythonmod",PACKAGE_REV);
}

// static const char *keymenu=NULL;

PUBLIC void MODULE_pythonmod::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	signal(SIGCHLD, SIG_DFL);
	pmods.setmenu(dia,context);
	popen_initsignal();
	/*
	if (context == MENU_MAIN_CONFIG){
		keymenu = MSG_U(M_pythonmod,"Python Wrapper");
		dia.new_menuitem ("pythonmod","",keymenu);
	}
	*/
}

PUBLIC int MODULE_pythonmod::domenu (
	MENU_CONTEXT context,
	const char *keyword)
{
	signal(SIGCHLD, SIG_DFL);
	pmods.domenu(context,keyword);
	popen_initsignal();
	/*
	if (context == MENU_MAIN_CONFIG){
		if (key == keymenu){
			// ### Place the call to the edit function here
		}
	}
	*/
	return 0;
}


PUBLIC int MODULE_pythonmod::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"pythonmod")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain pythonmod usage\n"
		 "\n"
		 "    pythonmod --option ...\n")
		);
}

PUBLIC void MODULE_pythonmod::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_pythonmod::message (const char *msg, int argc, const char *argv[])
{
	if (strcmp(msg,"about")==0) {
                SSTRINGS *tb = (SSTRINGS*)argv[0];
                tb->add (new SSTRING(MSG_U(X_ABOUT,"Module pythonmod was written by Gustavo Niemeyer (niemeyer@conectiva.com)")));
	}
	signal(SIGCHLD, SIG_DFL);
	int ret = pmods.message(msg,argc,argv);
	popen_initsignal();
	return ret;
}

PUBLIC int MODULE_pythonmod::execmain (int argc , char *argv[], bool standalone)
{
	signal(SIGCHLD, SIG_DFL);
	int ret = pmods.execmain(argc, argv, standalone);
	popen_initsignal();
	return ret;
	/*
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"pythonmod")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
	*/
}

PUBLIC int MODULE_pythonmod::probe (int state, int target, bool simul)
{
	signal(SIGCHLD, SIG_DFL);
	int ret = pmods.probe(state,target,simul);
	popen_initsignal();
	return ret;
}

static MODULE_pythonmod pythonmod;

