#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static struct PyMethodDef LCPrivilege_methods[] = {
	{NULL, NULL}
};

static void
LCPrivilege_dealloc(LCPrivilegeObject *self)
{
	if (self->p != NULL && self->owner)
		delete self->p;
	PyMem_DEL(self);
}

static PyObject *
LCPrivilege_getattr(LCPrivilegeObject *self, char *name)
{
	return Py_FindMethod(LCPrivilege_methods, (PyObject*) self, name);
}

PyTypeObject LCPrivilege_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCPrivilege",
	sizeof(LCPrivilegeObject),
	0,
	(destructor) LCPrivilege_dealloc,
	(printfunc) 0,
	(getattrfunc) LCPrivilege_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCPrivilege_New(char *id, char *title, char *section)
{
	LCPrivilegeObject *self;
	self = PyObject_NEW(LCPrivilegeObject, &LCPrivilege_Type);
	if (self == NULL)
		return NULL;
	self->p = new PRIVILEGE(id,title,section);
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCPrivilege_FromPriv(PRIVILEGE *p)
{
	LCPrivilegeObject *self;
	self = PyObject_NEW(LCPrivilegeObject, &LCPrivilege_Type);
	if (self == NULL)
		return NULL;
	self->p = p;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCPrivilege_FromPrivDealloc(PRIVILEGE *p)
{
	LCPrivilegeObject *self;
	self = PyObject_NEW(LCPrivilegeObject, &LCPrivilege_Type);
	if (self == NULL)
		return NULL;
	self->p = p;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lcprivilege_LCPrivilege(PyObject *self, PyObject *args)
{
	char *id, *title, *section;
	if (!PyArg_ParseTuple(args, "|sss", &id, &title, &section))
		return NULL;
	return LCPrivilege_New(id, title, section);
}

static PyObject *
lcprivilege_perm_access(PyObject *self, PyObject *args)
{
	LCPrivilegeObject *priv;
	char *str;
	if (!PyArg_ParseTuple(args,"Os", &priv, &str))
		return NULL;
	return PyInt_FromLong(perm_access(priv->p, "%s", str));
}

static PyObject *
lcprivilege_privilege_lookup(PyObject *self, PyObject *args)
{
	PRIVILEGE *priv;
	char *id;
	if (!PyArg_ParseTuple(args,"s",&id))
		return NULL;
	priv = privilege_lookup(id);
	if (priv == NULL) {
		Py_INCREF(Py_None);
		return Py_None;
	}
	return LCPrivilege_FromPriv(priv);
}

static struct PyMethodDef lcprivilege_methods[] = {
	{"LCPrivilege", lcprivilege_LCPrivilege, 1},
	{"perm_access", lcprivilege_perm_access, 1},
	{"privilege_lookup", lcprivilege_privilege_lookup, 1},
	{NULL,NULL}
};

extern "C" void
initlcprivilege()
{
	PyObject *m, *d;
	m = Py_InitModule("lcprivilege", lcprivilege_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcprivilege.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcprivilege");
}
