#ifndef pymodule_h
#define pymodule_h

#include <Python.h>

class PYMODULE: public ARRAY_OBJ
{
	private:
		PyObject *pmod, *pinst;
		PyObject *psetmenu, *pdomenu, *pmessage;
		PyObject *ptbfe;
		PyObject *pstrjoin;
		char *modname;
		int initialized;
		bool err();
	public:
		PYMODULE(const char *modname, PyObject *_ptbfe, PyObject *_pstrjoin);
		~PYMODULE();

		void init();
		void setmenu(DIALOG &dia, MENU_CONTEXT context);
		void domenu(MENU_CONTEXT context, const char *keyword);
		int execmain (int argc , char *argv[], bool standalone);
		int probe(int state, int target, bool simul);
		int message(const char *msg, int argc, const char *argv[]);
};

class PYMODULES: public ARRAY
{
	private:
		PyObject *psysmod, *psys_stderr;
		PyObject *ptbmod, *ptbfe;
		PyObject *pstrmod, *pstrjoin;
		bool ok;
		int initialized;
		const char *dirname;

	public:
		PYMODULES();
		void init();
		void readdir(const char *dirname);
		void setmenu(DIALOG &dia, MENU_CONTEXT context);
		void domenu(MENU_CONTEXT context, const char *keyword);
		int execmain(int argc , char *argv[], bool standalone);
		int probe(int state, int target, bool simul);
		int message(const char *msg, int argc, const char *argv[]);
		PYMODULE* getitem(int no);
};

#endif /* pymodule_h */
