/*
 Printer configurator for Linuxconf v1.9.2
 (1.0 released on 1.18r5)
 by Daniel Mealha Cabrita (dancab@conectiva.com)
 April 9th, 2001
*/

/*
 this module needs:
 rhs-printfilters-1.57-3cl (used by or part of RH's printtool)
 because the /usr/lib/rhs/rhs-printfilters/ files
*/

/*
 look at
 printer_common_data.*
 for defines' table
*/

/*
 module features:
 - edit/add/remove printers and their filter configuration
 - manages hosts allowed to access local queues
 - manages printers' queues
 - detects if lpd is being started automatically for current
   runlevel and, if it isn't and user confirms action,
   configures lpd for starting automatically
 - fills gui fields with common/default values so the user doesn't
   need to provide data (s)he doesn't know or gives hint on what
   kind of data he must provide
 - LPRng-aware (doesn't support newstyled printcap file, though)
*/

/*
 v1.0 first release in Linuxconf package (1.18r5).

 v1.1 released June 1st, 2000
 - GUI is changed. instead tall scrollable windows now we
   have 'selection by section'.
 - suggests an unique printer name instead always 'lp' as
   before.
 - data in printer properties' window is not lost after selecting
   a new filter (except the filter settings -- can't be avoided).
 - now the module can be directly called from the command line.
 - main menu is now recognized this way in treemenu mode.
   (the [+] now appears)
 - other minor fixes i don't remember

 v1.2 (1.21)
 - lprm program wasn't referred in printer.daemons file so user
   could not delete queue. fixed.
 - now if unable to create spool dir asks user if he wants to use
   the existing one (does not verify if it is really a directory,
   though).
 - fixed bug in the routine for executing external commands
   and returning their stdout (it could miss some characters).
 - now module is LPRng-aware (but doesn't support newstyled
   printcap file).
 - fixed the '-dBitsPerPixel' wrongly added in 'uniprint' drivers
   (should be appended only to other drivers)
 - changed types from FILE to FILE_CFG (oops.. it was the source
   of module compilation problems in Linuxconf 1.20)

 v1.3
 - _now_ printer module appears correctly in treemenu mode
   (so you can see how often i use treemenu mode)
 - no more hardcoded limit for total of printers the module can
   deal with (memory available is now the limit, so it's virtually
   unlimited).
 -> printfconf assimilated to printer module

 v1.4
 - file permitions for LPRng now seem to be 100% correct
 - memory invasion was occuring for large 'About: ' entries in
   printerdb file, corrected.
 - now module recognizes correctly ppa drivers in printerdb
   file (wrong printers were being reported even if the configfile
   was correct).
 - now fast_ascii is automatically disabled if a PPA filter is
   selected. -- the fast_ascii option also doesn't appear on
   configuration window (it would be bad if some 'smart' user
   re-enable it).

 v1.5  (1.21r6)
 - added printer test options (in printer properties window)
 - fixed usr filter button so now it appears in html mode
 - now rp (printcap entry) is always defined when remote queue
   (no longer ommited if it is 'lp')
 - now the module makes sure /var/spool/lpd exists

 v1.6 (present in 1.22) 25 oct, 2000
 - now test jobs are sent correctly to printer with aliases.
 - for filters which had the same driver in some cases the configurator
   showed a different filter description. fixed. (better to say it was
   workarounded).
 - after selecting a new filter, in some cases, the configurator
   presented something like '-dBitsPerPixel=3' in color depth. fixed.
 - corrected queue manager, so status are shown correctly for LPRng too.

 v1.7 (1.23)
 - now user may specify a spool directory when creating a new printer,
   if (s)he don't wants the directory suggestion.
 - module now permits creating a printername with '|' (printer aliases),
   AND verification for duplicated name is smart now (ex.: it sees lp3
   as duplicated for blah|lp3)
 - now when adding a new remote printer, if LPRng is used, the tag
   lpd_bounce will be added, so the local filter may be used.
 - now printers' list no longer flashes (dialog is updated instead
   being completely rebuilt).

 v1.8 (1.23r2)
 - now the 'Network Authorizations' menu only appears if old lpr
   system is used (old_lpr-specific stuff, not used in lprng/etc).
 - fixed a missing free() somewhere.
 - now the if='' entry points to 'filter' when SMB and NCP printers,
   instead directly the smb/ncp filters (so the postscript may be
   translated into something else too). -- general.cfg file now is
   generated just after the printer is created (instead only after
   the filter is configured) this way smb/ncp printers will be
   accessible just after the printer entry is created (this is needed
   because the 'if=''' entry now points to 'filter' instead pointing
   directly to the smb/ncp filter.

 v1.8.1 (present in 1.24r4)
 - changed the way the informative windows are displayed, so they
   appear as normal windows even when in treemenu mode (instead
   showing it as a new tab).
 - now the 'if=' entries are created correctly if the user changes
   the printer name (it relied on printername instead spool directory
   name).

 v1.9 (present in 1.24r8)
 - major reorganization in the source code.
 - implemented the interface for printer guru (in order to avoid
   more mess in the code).
 - when cancelling the filter selection the filter was changed
   too (it shouldn't). fixed.

 v1.9.1 (present in 1.25r3) March 4th, 2001
 - added setting for default printer (LPRng only)

 v1.9.2
 - now it support permissions dependant on which distribution
   it runs (RH likes 755, Conectiva prefers 700..)
 - bugfix: when creating the first printer entry, garbage was
   appearing in the printer name and spool directory fields.
 - general.cfg file wasn't being properly updated. fixed.
 - for smb printers instead suggesting 'my_hostname' gives
   'printer_hostname' to avoid explosion of user's brain.


 TODOs:
 - include management for lprng-style printcap files.


 */


/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "printer.h"
#include "printer.m"
#include <netconf.h>
#include "printer_fi.h"

MODULE_DEFINE_VERSION(printer);

PUBLIC MODULE_printer::MODULE_printer()
	: LINUXCONF_MODULE("printer")
{
	linuxconf_loadmsg ("printer",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_printer::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_HARDWARE){
		keymenu = MSG_U(M_printer,"Printer");
		dia.new_menuitem ("printer","",keymenu);
	}
}

PUBLIC int MODULE_printer::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_HARDWARE){
		if (key == keymenu){
                    printer_ed();
                    // ### Place the call to the edit function here
		}
	}
	return 0;
}


PUBLIC int MODULE_printer::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"printer")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
    xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain printer usage\n"
		 "\n"
		 "    printer --option ...\n")
		);
}

PUBLIC void MODULE_printer::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_printer::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}

        if (strcmp(pt,"printer")==0){
            ret = -1;
                if (argc == 1){
                    // ### Place call to main menu of the module
                    printer_ed();
                }else{
                    // ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


PUBLIC int MODULE_printer::probe (int level, int target, bool simul)
{
/*    printf("------\n");
    printf("level: %d\ntarget: %d\n", level, target);

    if(level==2){
        if(simul==true){
            net_prtlog(NETLOG_CMD, "i'm going to do nice tricks on your computer!\n");
            printf("simul==true\n");
        } else {
            net_title("fsdfaguoihrgior");
            net_prtlog(NETLOG_CMD, "i'm going to do nice tricks on your computer! .\n");
            printf("simul==false\n");
        }
    }
  */
    return(0);
}


static MODULE_printer printer;


#include <stdlib.h>
#include <ctype.h>

#include "modregister.h"
static void printers_change_filter (const char *v, bool setting)
{
	int whichone=-1;
	int loop;

	//Load the printcap entries.  Must "free_buffers_of_mine" later.
	load_printcap();

	//If the printer exists as a name, use that.
	{
		for (loop=0; loop < total_printer_entries; loop++) {
			if (general_printer_index[loop].exists) {
				if (strcmp(v,general_printer_index[loop].devname) == 0) {
					whichone=loop;
				}
			}
		}
	}
	if (whichone == -1) {
		if (isdigit(v[0])) {
			whichone=atoi(v);
		}
	}
	if (whichone >= 0 && whichone < total_printer_entries)
	{
		char   overrider_printer[500]; 
		char   dotconfig_fullpath[500]; 
		overrider_printer[0]=0;
		sprintf(dotconfig_fullpath, "%s/%s", my_printcap[whichone].sd, DOTCONFIG_FILENAME);
		/* load seconday configfiles */
		load_initialise_secondary_configfiles(whichone);
		/* load .config, if present */
		load_dotconfig_data(dotconfig_fullpath);
		/*call the change printfilter dialog */
        	select_printer_filter(overrider_printer, true);
		if(*overrider_printer){
	 		new_filter_so_reset_some_things(overrider_printer);
		        load_to_gui_variables();
		        write_filter_description(whichone, overrider_printer);
		        save_all_the_filters_stuff(whichone);
		        save_dotconfig_data(dotconfig_fullpath);
		}
	}
	free_buffers_of_mine();
}               

/* vregistry setup for the main printer edit menu */
static void printers_editprinter (const char *v, bool setting)
{
	int whichone=-1;
	int loop;

	//Load the printcap entries.  Must "free_buffers_of_mine" later.
	load_printcap();

	//If the printer exists as a name, use that.
	{
		for (loop=0; loop < total_printer_entries; loop++) {
			if (general_printer_index[loop].exists) {
				if (strcmp(v,general_printer_index[loop].devname) == 0) {
					whichone=loop;
				}
			}
		}
	}
	if (whichone == -1) {
		if (isdigit(v[0])) {
			whichone=atoi(v);
		}
	}
	if (whichone >= 0 && whichone < total_printer_entries)
	{
        	editprinter_window (whichone);
	}
	free_buffers_of_mine();
}               

/* change spool directory */
static void vreg_change_sdir (const char *v, bool setting)
{
	int whichone=-1;
	int loop;

	//Load the printcap entries.  Must "free_buffers_of_mine" later.
	load_printcap();
	kind_of_lpr_system_installed=return_lpr_system_installed_in_this_system();

	//If the printer exists as a name, use that.
	{
		for (loop=0; loop < total_printer_entries; loop++) {
			if (general_printer_index[loop].exists) {
				if (strcmp(v,general_printer_index[loop].devname) == 0) {
					whichone=loop;
				}
			}
		}
	}
	if (whichone == -1) {
		if (isdigit(v[0])) {
			whichone=atoi(v);
		}
	}
	if (whichone >= 0 && whichone < total_printer_entries)
	{
		printer_change_printer_name_or_spooldir(whichone);
	}
	free_buffers_of_mine();
}               

/* Change printer type */
static void vreg_change_ptype (const char *v, bool setting)
{
	int whichone=-1;
	int loop;

	//Load the printcap entries.  Must "free_buffers_of_mine" later.
	load_printcap();
	kind_of_lpr_system_installed=return_lpr_system_installed_in_this_system();

	//If the printer exists as a name, use that.
	{
		for (loop=0; loop < total_printer_entries; loop++) {
			if (general_printer_index[loop].exists) {
				if (strcmp(v,general_printer_index[loop].devname) == 0) {
					whichone=loop;
				}
			}
		}
	}
	if (whichone == -1) {
		if (isdigit(v[0])) {
			whichone=atoi(v);
		}
	}
	if (whichone >= 0 && whichone < total_printer_entries)
	{
		printer_change_printer_type(whichone);
	}
	free_buffers_of_mine();
}               
void vreg_add_printer()
{
	//Load the printcap entries.  Must "free_buffers_of_mine" later.
	load_printcap();
	kind_of_lpr_system_installed=return_lpr_system_installed_in_this_system();
	addprinter_window(true);
	free_buffers_of_mine();
}
void vreg_remove_printer()
{
	//Load the printcap entries.  Must "free_buffers_of_mine" later.
	load_printcap();
	kind_of_lpr_system_installed=return_lpr_system_installed_in_this_system();
	remove_printer_window();
	free_buffers_of_mine();
}
static void printers_list (SSTRINGS &tb)
{
	load_printcap();
	for (int loop=0; loop < total_printer_entries; loop++) {
		if (general_printer_index[loop].exists) {
			tb.add (new SSTRING (general_printer_index[loop].devname));
		}
	}
	free_buffers_of_mine();
}


static PUBLISH_VARIABLES_MSG printer_var_list1[]={
    {"maxfilesize",P_MSG_R(M_MAXFILESIZE)},
    {"supressheaders",P_MSG_R(M_SUPRESSHEADERS)},
    {"local_connectedto",P_MSG_R(M_LOCALCONNECTEDTO)},

    {"remote_machine",P_MSG_R(M_REMOTEMACHINE)},
    {"remote_queue",P_MSG_R(M_REMOTEQUEUE)},

    {"smb_user",P_MSG_R(M_SSMBUSER)},
    {"smb_passwd",P_MSG_R(M_SSMBPASSWD)},
    {"smb_hostname",P_MSG_R(M_SSMBHOSTNAME)},
    {"smb_prtname",P_MSG_R(M_SSMBPRTNAME)},
    {"smb_hostname",P_MSG_R(M_SSMBHOSTNAME)},
    {"smb_hostip",P_MSG_R(M_SSMBHOSTIP)},
    {"smb_workgroup",P_MSG_R(M_SSMBWORKGP)},

    {"sncp_user",P_MSG_R(M_SNCPUSER)},
    {"sncp_server",P_MSG_R(M_SNCPSERVER)},
    {"sncp_passwd",P_MSG_R(M_SNCPPASSWD)},
    {"sncp_queue",P_MSG_R(M_SNCPQUEUE)},

    {"direct_printer_ip",P_MSG_R(M_DIRECTPRINTERIP)},
    {"direct_port",P_MSG_R(M_DIRECTPORT)},

    {"filter_current",P_MSG_R(M_FILTCURRSELECTED)},
    {"filter_resolution",P_MSG_R(M_FLRESOLUTION)},
    {"filter_papersize",P_MSG_R(M_FLPAPERSIZE)},
    {"filter_colordepth",P_MSG_R(M_FLCOLORDEPTH)},
    {"filter_printedpages",P_MSG_R(M_FLPRINTEDPAGES)},
    {"filter_sendeof",P_MSG_R(M_SENDEOF)},
    {"filter_fixcrlf",P_MSG_R(M_FIXCRLF)},
    {"filter_fastascii",P_MSG_R(M_FASTASCII)},
    {"filter_horizontalmargins",P_MSG_R(M_HORIZMARGINS)},
    {"filter_verticalmargins",P_MSG_R(M_VERTMARGINS)},
    {"filter_gsextraoptions",P_MSG_R(M_GSEXTOPTIONS)},
    { NULL , NULL  }
};
static PUBLISH_VARIABLES_MSG printer_var_list2[]={
    {"name",P_MSG_R(M_CHANGEPNAME)},
    {"spooldir",P_MSG_R(M_CHANGESDIR)},
    {NULL,NULL}
};
static PUBLISH_VARIABLES_MSG printer_var_list3[]={
    {"type",P_MSG_R(M_CHANGETYPE_REG)},
    {NULL,NULL}
};
static PUBLISH_VARIABLES_MSG printer_var_list5[]={
    {"filter_name",P_MSG_R(M_VREG_CHANGEFILTER)},
    {NULL,NULL}
};
               
static REGISTER_VARIABLES printer_registry1("printer","printers"
	,printer_var_list1
	,NULL,printers_editprinter,printers_list);
static REGISTER_VARIABLES printer_registry2("printer","printers"
	,printer_var_list2
	,NULL,vreg_change_sdir,NULL);
static REGISTER_VARIABLES printer_registry3("printer","printers"
	,printer_var_list3
	,NULL,vreg_change_ptype,NULL);
static REGISTER_VARIABLES printer_registry5("printer","printers"
	,printer_var_list5
	,NULL,printers_change_filter,NULL);

static REGISTER_VARIABLE_LOOKUP_MSG printer_var_list4[]={
	        { "add", NULL, P_MSG_R(M_NEWPRINTERNAME), &vreg_add_printer, NULL},
	        { "del", NULL, P_MSG_R(M_DELETENAME), &vreg_remove_printer, NULL},
		        { NULL, NULL, NULL, NULL }
};
 
static REGISTER_VARIABLES printer_registry4("printer",printer_var_list4);
        


