// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings for miscellaneous Postfix configuration parameters 
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::miscellaneous_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;

	// always_bcc
	st = data.getvarvariable(V_ALWAYS_BCC);
	dia.newf_str(MSG_U(F_ALWAYBCC,"Always bcc"),*st);

	// daemon_timeout
	st = data.getvarvariable(V_DAEMON_TIMEOUT);
	int val_daemontout = st->getval();
	dia.newf_num (MSG_U(F_DAEMONTOUT,"Daemon timeout"), val_daemontout);

	// default_database_type
	st = data.getvarvariable(V_DEFAULT_DATABASE_TYPE);
	char var_defdtbtype = 0;
	if ( st->cmp("dbm")==0 )
			var_defdtbtype = 0;
	else 	if ( st->cmp("hash")==0 )
			var_defdtbtype = 1;
	else	if ( st->cmp("btree")==0 )
			var_defdtbtype = 2;
	const char *opt_defdtbtype[] = {MSG_U(X_DBM,"dbm"),MSG_U(X_HASH,"hash"),MSG_U(X_BTREE,"btree"),NULL};
	dia.newf_chkm (MSG_U(F_DEFDATABASETYPE,"Default database type"),var_defdtbtype,opt_defdtbtype);

	// default_transport
	st = data.getvarvariable(V_DEFAULT_TRANSPORT);
	char var_deftransp;
	if ( st->cmp("smtp")==0 )
		var_deftransp = 0;
	else 	if ( st->cmp("uucp")==0 )
		var_deftransp = 1;
	const char *opt_deftransp[] = {MSG_U(X_SMTP,"smtp"),MSG_U(X_UUCP,"uucp"),NULL};
	dia.newf_chkm (MSG_U(F_DEFTRANSP,"Default transport"),var_deftransp,opt_deftransp);

	// double_bounce_sender
	st = data.getvarvariable(V_DOUBLE_BOUNCE_SENDER);
	dia.newf_str(MSG_U(F_DBLBNCESND,"Double bounce sender"),*st);

	// hash_queue_depth	
	st = data.getvarvariable(V_HASH_QUEUE_DEPTH);
	int val_hsquedpth = st->getval();
	dia.newf_num (MSG_U(F_HASHQUEUEDEPTH,"Hash queue depth"), val_hsquedpth);

	// hash_queue_names
	st = data.getvarvariable(V_HASH_QUEUE_NAMES);
	dia.newf_str(MSG_U(F_HASHQUEUENAM,"Hash queue names"),*st);

	// hopcount_limit
	st = data.getvarvariable(V_HOPCOUNT_LIMIT);
	int val_hopcntlim = st->getval();
	dia.newf_num (MSG_U(F_HOPCOUNTLIM,"Hopcount limit"), val_hopcntlim);
	
	// ipc_idle
	st = data.getvarvariable(V_IPC_IDLE);
	int val_ipcidle = st->getval();
	dia.newf_num (MSG_U(F_IPCIDLE,"Ipc idle"), val_ipcidle);

	// ipc_timeout
	st = data.getvarvariable(V_IPC_TIMEOUT);
	int val_ipctout = st->getval();
	dia.newf_num (MSG_U(F_IPCTIMEOUT,"Ipc timeout"), val_ipctout);

	// mail_name
	st = data.getvarvariable(V_MAIL_NAME);
	dia.newf_str(MSG_U(F_MAILNAME,"Mail name"),*st);
	
	// mail_version
	st = data.getvarvariable(V_MAIL_VERSION);
	dia.newf_str(MSG_U(F_MAILVERSION,"Mail version"),*st);
	
	// max_idle
	st = data.getvarvariable(V_MAX_IDLE);
	int val_maxidle = st->getval();
	dia.newf_num (MSG_U(F_MAXIDLE,"Max idle"), val_maxidle);

	// max_use
	st = data.getvarvariable(V_MAX_USE);
	int val_maxuse = st->getval();
	dia.newf_num (MSG_U(F_MAXUSE,"Max use"), val_maxuse);

	// notify_classes
	st = data.getvarvariable(V_NOTIFY_CLASSES);
	dia.newf_str(MSG_U(F_NOTIFYCLASSES,"Notify classes"),*st);

	// The following parameters specify who gets postmaster notices if
	// one of the above error conditions is recognized. All parameters
	//  default to "postmaster".
	//dia.newf_title (MSG_U(T_NOTICES,"notices"),1,"",MSG_R(T_NOTICES));

	// bounce_notice_recipient
	st = data.getvarvariable(V_BOUNCE_NOTICE_RECIPIENT);
	dia.newf_str(MSG_U(F_BNCNOTREC,"Bounce notice recipient"),*st);

	// 2bounce_notice_recipient
	st = data.getvarvariable(V_2BOUNCE_NOTICE_RECIPIENT);
	dia.newf_str(MSG_U(F_2BNCNOTREC,"2Bounce notice recipient"),*st);

	// delay_notice_recipient
	st = data.getvarvariable(V_DELAY_NOTICE_RECIPIENT);
	dia.newf_str(MSG_U(F_DELAYNOTREC,"Delay notice recipient"),*st);

	// error_notice_recipient
	st = data.getvarvariable(V_ERROR_NOTICE_RECIPIENT);
	dia.newf_str(MSG_U(F_ERRORNOTREC,"Error notice recipient"),*st);
	
	// process_id_directory
	st = data.getvarvariable(V_PROCESS_ID_DIRECTORY);
	dia.newf_str(MSG_U(F_PROCIDDIR,"Process id directory"),*st);
	
	// program_directory
	st = data.getvarvariable(V_PROGRAM_DIRECTORY);
	dia.newf_str(MSG_U(F_PRGMDIR,"Program directory"),*st);

	// sun_mailtool_compatibility
	st = data.getvarvariable(V_SUN_MAILTOOL_COMPATIBILITY);
	char var_sunmailtoolcomp = getvalue_yesno (st);
	const char *opt_sunmailtoolcomp[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_SUNMAILTOOLCOMP,"Sun mailtool compatibility"),var_sunmailtoolcomp,opt_sunmailtoolcomp);
	
	// trigger_timeout
	st = data.getvarvariable(V_TRIGGER_TIMEOUT);
	int val_triggertout = st->getval();
	dia.newf_num (MSG_U(F_TRIGGERTOUT,"Trigger timeout"), val_triggertout);

	// delay_warning_time
	st = data.getvarvariable(V_DELAY_WARNING_TIME);
	int val_delaywrngtime = st->getval();
	dia.newf_num (MSG_U(F_DELAYWARNINGTOUT,"Delay warning timeout"), val_delaywrngtime);
	
	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
		
	while (1){
		MENU_STATUS code = dia.edit(
			 MSG_U(T_MISCELLANEOUSCONF,"Miscellaneous configuration")
			,MSG_U(I_MISCELLANEOUSCONF,"Here you can configure the miscellaneous postfix parameters")
			,help_postfix_miscellaneous
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);	
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
			
			// daemon_timeout
			data.getvarvariable(V_DAEMON_TIMEOUT)->setfrom(val_daemontout);

			// default_database_type
			st = data.getvarvariable(V_DEFAULT_DATABASE_TYPE);
			switch (var_defdtbtype){
				case 0:
					st->setfrom("dbm");
					break;
				case 1:
					st->setfrom("hash");
					break;
				case 2:
					st->setfrom("btree");
			}

			// default_transport
			st = data.getvarvariable(V_DEFAULT_TRANSPORT);
			switch (var_deftransp){
				case 0:
					st->setfrom("smtp");
					break;
				case 1:
					st->setfrom("uucp");
			}
			
			// hash_queue_depth
			data.getvarvariable(V_HASH_QUEUE_DEPTH)->setfrom(val_hsquedpth);
			
			// hopcount_limit
			data.getvarvariable(V_HOPCOUNT_LIMIT)->setfrom(val_hopcntlim);
		
			// ipc_idle
			data.getvarvariable(V_IPC_IDLE)->setfrom(val_ipcidle);
			
			// ipc_timeout
			data.getvarvariable(V_IPC_TIMEOUT)->setfrom(val_ipctout);
			
			// max_idle
			data.getvarvariable(V_MAX_IDLE)->setfrom(val_maxidle);
			
			// max_use
			data.getvarvariable(V_MAX_USE)->setfrom(val_maxuse);
			
			// sun_mailtool_compatibility
			setvalue_yesno (data.getvarvariable(V_SUN_MAILTOOL_COMPATIBILITY), var_sunmailtoolcomp);
	
			// program_directory
			if (data.is_varempty(V_PROGRAM_DIRECTORY) ){
				nof=20;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}
			
			// trigger_timeout
			data.getvarvariable(V_TRIGGER_TIMEOUT)->setfrom(val_triggertout);

			// delay_warning_time
			data.getvarvariable(V_DELAY_WARNING_TIME)->setfrom(val_delaywrngtime);

			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_ALWAYS_BCC,
						V_DAEMON_TIMEOUT,
						V_DEFAULT_DATABASE_TYPE,
						V_DEFAULT_TRANSPORT,
						V_DOUBLE_BOUNCE_SENDER,
						V_HASH_QUEUE_DEPTH,
						V_HASH_QUEUE_NAMES,
						V_HOPCOUNT_LIMIT,
						V_IPC_IDLE,
						V_IPC_TIMEOUT,
						V_MAIL_NAME,
						V_MAIL_VERSION,
						V_MAX_IDLE,
						V_MAX_USE,
						V_NOTIFY_CLASSES,
						V_BOUNCE_NOTICE_RECIPIENT,
						V_2BOUNCE_NOTICE_RECIPIENT,
						V_DELAY_NOTICE_RECIPIENT,
						V_ERROR_NOTICE_RECIPIENT,
						V_PROCESS_ID_DIRECTORY,
						V_PROGRAM_DIRECTORY,
						V_SUN_MAILTOOL_COMPATIBILITY,
						V_TRIGGER_TIMEOUT,
						V_DELAY_WARNING_TIME,
						-1
				};
				data.setdefaultvarvalues(values);
	
				// daemon_timeout
				st = data.getvarvariable(V_DAEMON_TIMEOUT);
				val_daemontout = st->getval();

				// default_database_type
				st = data.getvarvariable(V_DEFAULT_DATABASE_TYPE);
				if ( st->cmp("dbm")==0 )
						var_defdtbtype = 0;
				else 	if ( st->cmp("hash")==0 )
						var_defdtbtype = 1;
				else	if ( st->cmp("btree")==0 )
						var_defdtbtype = 2;

				// default_transport
				st = data.getvarvariable(V_DEFAULT_TRANSPORT);
				if ( st->cmp("smtp")==0 )
					var_deftransp = 0;
				else 	if ( st->cmp("uucp")==0 )
					var_deftransp = 1;

				// hash_queue_depth	
				st = data.getvarvariable(V_HASH_QUEUE_DEPTH);
				val_hsquedpth = st->getval();
				
				// hopcount_limit
				st = data.getvarvariable(V_HOPCOUNT_LIMIT);
				val_hopcntlim = st->getval();
				
				// ipc_idle
				st = data.getvarvariable(V_IPC_IDLE);
				val_ipcidle = st->getval();

				// ipc_timeout
				st = data.getvarvariable(V_IPC_TIMEOUT);
				val_ipctout = st->getval();

				// max_idle
				st = data.getvarvariable(V_MAX_IDLE);
				val_maxidle = st->getval();

				// max_use
				st = data.getvarvariable(V_MAX_USE);
				val_maxuse = st->getval();

				// sun_mailtool_compatibility
				st = data.getvarvariable(V_SUN_MAILTOOL_COMPATIBILITY);
				var_sunmailtoolcomp = getvalue_yesno (st);
				
				// trigger_timeout
				st = data.getvarvariable(V_TRIGGER_TIMEOUT);
				val_triggertout = st->getval();

				// delay_warning_time
				st = data.getvarvariable(V_DELAY_WARNING_TIME);
				val_delaywrngtime = st->getval();
				
				dia.reload();
			}
		}
	}
	return ret;
}
