// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of Postfix configuration parameters that control local delivery
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::ctrllocaldeliv_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	
	// - - - OVERRIDE LOCAL TRANSPORT - - -
	dia.newf_title (MSG_U(T_OVERRLOCALTRANSP,"Override local transport"),1,"",MSG_R(T_OVERRLOCALTRANSP));

	// local_transport
	st = data.getvarvariable(V_LOCAL_TRANSPORT);
	dia.newf_str(MSG_U(F_LOCAL_TRANSP,"Local transport"),*st);
	

	// - - - SECURITY CONTROLS - - -
	dia.newf_title (MSG_U(T_SECURITYCTRL,"Security controls"),1,"",MSG_R(T_SECURITYCTRL));
	
	// local_command_shell
	st = data.getvarvariable(V_LOCAL_COMMAND_SHELL);
	dia.newf_str(MSG_U(F_LOCALCOMMSHELL,"Local command shell"),*st);

	// forward_path
	st = data.getvarvariable(V_FORWARD_PATH);
	dia.newf_str(MSG_U(F_FWDPATH,"Forward path"),*st);

	// allow_mail_to_commands
	st = data.getvarvariable(V_ALLOW_MAIL_TO_COMMANDS);
	dia.newf_str(MSG_U(F_ALLOWMAILTOCMD,"Allow mail to commands"),*st);
	
	// allow_mail_to_files
	st = data.getvarvariable(V_ALLOW_MAILTO_FILES);
	dia.newf_str(MSG_U(F_ALLOWMAILTOFILES,"Allow mail to files"),*st);
	
	// - - - DELIVERED-TO - - -
	dia.newf_title (MSG_U(T_DELIVTO,"Delivered-to"),1,"",MSG_R(T_DELIVTO));

	// local_destination_recipient_limit
	st = data.getvarvariable(V_LOCAL_DESTINATION_RECIPIENT_LIMIT);
	int val_locdestrecplim = st->getval();
	dia.newf_num (MSG_U(F_LOCDESTRECLIM,"Local destination recipient limit"), val_locdestrecplim);
	
	// prepend_delivered_header
	st = data.getvarvariable(V_PREPEND_DELIVERED_HEADER);
	dia.newf_str(MSG_U(T_PREPDELIVHEADER,"Prepend delivered header"),*st);

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_CTRLLOCALDELIV,"Control local delivery")
			,MSG_U(I_CTRLLOCALDELIV,"Here you can configure postfix options that control local delivery")
			,help_postfix_ctrllocaldeliv
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
			
			// local_destination_recipient_limit
			data.getvarvariable(V_LOCAL_DESTINATION_RECIPIENT_LIMIT)->setfrom(val_locdestrecplim);
			
			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_LOCAL_TRANSPORT,
						V_LOCAL_COMMAND_SHELL,
						V_FORWARD_PATH,
						V_ALLOW_MAIL_TO_COMMANDS,
						V_ALLOW_MAILTO_FILES,
						V_LOCAL_DESTINATION_RECIPIENT_LIMIT,
						V_PREPEND_DELIVERED_HEADER,
						-1
				};
				data.setdefaultvarvalues(values);
	
				// local_destination_recipient_limit
				st = data.getvarvariable(V_LOCAL_DESTINATION_RECIPIENT_LIMIT);
				val_locdestrecplim = st->getval();
				
				dia.reload();
			}
		}
	}
	return ret;
}
