#ifndef INETDCONF_API_H
#define INETDCONF_API_H

#include <module_apis/inetdconf_apidef.h>
static const char INETDCONF_API_KEY[]="inetdconf";
static const int  INETDCONF_API_REV=1;

inline INETDCONF_API *inetdconf_api_init(const char *client)
{
	return (INETDCONF_API*)module_get_api (INETDCONF_API_KEY,INETDCONF_API_REV
		,client);
}

inline void inetdconf_api_end(INETDCONF_API *api)
{
	module_release_api (INETDCONF_API_KEY,(void*)api);
}

inline bool inetdconf_api_available(const char *client)
{
	return module_api_available (INETDCONF_API_KEY,INETDCONF_API_REV,client);
}


#endif
