
#include "marsconf.h"
#include "mc_tools.h"
#include "mc_parser.h"

#include "fviews.h"

#include <stdio.h>
#include <string.h>

/* if reading_var!=0 then "-" is supposed to be converted to ""
   if reading_var==0 the "" is supposed to be converted to "-" */
void empty_is_dash(SSTRING &given_string, int reading_var)
{
    if(reading_var){
        if(!strcmp(given_string.get(), "-"))
            given_string.setfrom("");
    }else{
        if(!*(given_string.get()))
            given_string.setfrom("-");
    }
}

void set_bit_status(int &provided_mask, int which_bit, const char bit_status)
{
    int my_bit;

    my_bit=1<<which_bit;

    provided_mask|=my_bit;
    if(!bit_status)
        provided_mask^=my_bit;
}

char get_bit_status(int provided_mask, int which_bit)
{
    if((provided_mask & (1<<which_bit)))
        return(1);
    return(0);
}

/* converts a string hex number to int
   skips heading '0x' if present */
/* first character must be a part of the number already! */
int hextoi(const char *given_string)
{
    const char *current_point; // the point which starts after '0x'
    char current_char;
    int my_number=0;

    current_point=given_string;

    /* skip heading '0x' if present */
    if(!strncmp(current_point, "0x", 2))
        current_point+=2;

    while((current_char=*current_point++)){
        if((current_char>='0')&&(current_char<='9')){
            my_number<<=4;
            my_number+=(current_char-'0');
        }else{
            if((current_char>='a')&&(current_char<='f')){
                my_number<<=4;
                my_number+=(current_char-'a'+0x0a);
            }else{
                if((current_char>='A')&&(current_char<='F')){
                    my_number<<=4;
                    my_number+=(current_char-'A'+0x0a);
                }else{
                    return(my_number);
                }
            }
        }
    }
    return(my_number);
}

/* return !=0 if given_flag is present in the string */
char check_charflag(const char *given_string, char given_flag)
{
    if(strchr(given_string, given_flag))
        return(1);
    return(0);
}

/* remove or add the flag into the string according flag_status */
void set_charflag(SSTRING &modify_this_one, char given_flag, char flag_status)
{
    // flag previously absent
    if(!strchr(modify_this_one.get(), given_flag)){
        if(flag_status)
            modify_this_one.appendf("%c", given_flag);
        return;
    }

    // flag previously present
    if(!flag_status){
        char blah[500]; // you didn't see this
        char *zero_here;

        strcpy(blah, modify_this_one.get());
        zero_here=strchr(blah, given_flag);
        *zero_here=0;
        modify_this_one.setfromf("%s%s", blah, (zero_here+1));
    }
}

/* useful to check if the user didn't enter duplicated drives and things like that */
/* skip_this_line point to the item being edited */
/* !=0 IS duplicated, ==0 is NOT duplicated */
int check_if_duplicated_entry(VIEWITEMS &my_vitems, const char *data_to_check, int which_group, int skip_this_line, int which_word)
{
    int my_loop=0;
    SSTRING current_line;
    SSTRING current_word;

    while(parser_load_line(my_vitems, current_line, which_group, my_loop)){
        if(my_loop!=skip_this_line){
            gimme_word_from_string(current_line.get(), current_word, which_word);
            if(!strcmp(current_word.get(), data_to_check))
                return(1);
        }
        my_loop++;
    }
    return(0);
}

void minor_adjust(SSTRING &given_string)
{
    if(!strcmp(given_string.get(), "ihavemydigits")){
        given_string.setfrom("no_you_do_not");
        xconf_error("the Marsconf module was written by\nDaniel Mealha Cabrita (dancab@conectiva.com)\n(first version in march 22th, 2001)\n\n");
    }
}

/* this one here uses the parser routines and fills the my_dialog
 with all the items of the specified group. */
/* returns the total of lines inserted to list */
int insert_to_dialog_records(DIALOG_RECORDS &my_dialog, VIEWITEMS &my_vitems, int group_number, int first_field, int second_field)
{
    SSTRING my_line, field_1, field_2;
    int my_loop=0;

    while(parser_load_line(my_vitems, my_line, group_number, my_loop)){
        gimme_word_from_string(my_line.get(), field_1, first_field);
        gimme_word_from_string(my_line.get(), field_2, second_field);
        my_dialog.set_menuitem(my_loop, field_1.get(), field_2.get());
        my_loop++;
    }
    my_dialog.remove_last(my_loop+1);

    return(my_loop);
}

int replace_word_to_eol(SSTRING &affected_string, const char *new_data, int which_word, int what_is_illegal)
{
    return(replace_word(affected_string, new_data, which_word, what_is_illegal, 1)); // replace to the end of the line
}

int replace_word(SSTRING &affected_string, const char *new_data, int which_word, int what_is_illegal)
{
    return(replace_word(affected_string, new_data, which_word, what_is_illegal, 0)); // pick only the specific word
}

/* replace some specific word (referred by a number starting from 0) by another */
/* return 0 if ok, !=0 if error (space detected, for example) */
/* if to_eol!=0 then fill up to the end of the line */
int replace_word(SSTRING &affected_string, const char *new_data, int which_word, int what_is_illegal, int to_eol)
{
    SSTRING my_temp;
    SSTRING single_word_storage;
    int my_loop=0;
    int my_size;

    if(has_illegal_chars(new_data, what_is_illegal))
        return(1);

    while(gimme_word_from_string(affected_string.get(), single_word_storage, my_loop)){
        if(which_word!=my_loop){
            if((!to_eol)||(to_eol&&(which_word>my_loop)))
                my_temp.appendf("%s\t", single_word_storage.get());
        }else{
            my_temp.appendf("%s\t", new_data);
        }
        my_loop++;
    }

    /* if that word didn't exist previously.. insert it */
    if(which_word==my_loop)
        my_temp.appendf("%s\t", new_data);

    if((my_size=my_temp.getlen()))    // remove the tailing tab
        my_temp.truncate(my_size-1);

    affected_string.setfrom(my_temp.get());
    return(0);
}

/* returns !=0 if illegal chars are found */
int has_illegal_chars(const char *given_string, int what_is_illegal)
{
    const char *current_char;

    if((ILLEGAL_EMPTYNESS&what_is_illegal)&&(!*given_string))
        return(1);

    current_char=given_string;
    while(*current_char){
        if(ILLEGAL_SPACES&what_is_illegal){
            if(*current_char==' ')
                return(1);
        }
        if(UPPERCASE_ONLY&what_is_illegal){
            if((*current_char >= 'a') && (*current_char <= 'z'))
                return(1);
        }
        if(DIGITS_ONLY&what_is_illegal){
            if((*current_char < '0') || (*current_char > '9'))
                return(1);
        }
        if(*current_char<' ')
            return(1);

        current_char++;
    }
    return(0);
}

/* loads a very specific variable */
/* returns!=0 if line found (returned data may be empty though) */
int load_standalone_vardata(SSTRING &write_here, VIEWITEMS &my_vitems, int which_group, int which_word)
{
    SSTRING full_line_storage;
    int return_this;

    if((return_this=parser_load_line(my_vitems, full_line_storage, which_group, 0)))
        gimme_word_from_string(full_line_storage.get(), write_here, which_word);
    return(return_this);
}

/* saves a very specific variable */
void save_standalone_vardata(const char *write_this, VIEWITEMS &my_vitems, int which_group, int which_word)
{
    SSTRING full_line_storage;

    parser_load_line(my_vitems, full_line_storage, which_group, 0);
    // in this case, if the line wasn't found is not a problem
    replace_word(full_line_storage, write_this, which_word, 0, 0);
    parser_write_line(my_vitems, full_line_storage, which_group, 0);
}

/* loads a specific flag in a specific variable */
char load_standalone_bin_flag(VIEWITEMS &my_vitems, int which_group, int which_word, int which_bit)
{
    SSTRING my_flags;

    load_standalone_vardata(my_flags, my_vitems, which_group, which_word);
    if(get_bit_status(hextoi(my_flags.get()), which_bit))
        return(1);
    return(0);
}
/* saves a specific flag in a specific variable */
void save_standalone_bin_flag(const char write_this, VIEWITEMS &my_vitems, int which_group, int which_word, int which_bit)
{
    SSTRING my_flags;
    int my_flags_i;

    load_standalone_vardata(my_flags, my_vitems, which_group, which_word);
    my_flags_i=hextoi(my_flags.get());
    set_bit_status(my_flags_i, which_bit, write_this);
    my_flags.setfromf("0x%x", my_flags_i);
    save_standalone_vardata(my_flags.get(), my_vitems, which_group, which_word);
}


