
#include <stdlib.h>
#include <string.h>

#include "mc_parser.h"
#include "fviews.h"

void parser_remove_line(VIEWITEMS &my_vitems, int which_group, int which_line)
{
    int my_loop=0;
    const char *current_string;
    VIEWITEM *my_vitem;
    int current_internal_line=0;

    while((my_vitem=my_vitems.getitem(my_loop))){
        current_string=my_vitem->line.get();
        if(return_line_id(current_string)==which_group){
            if(current_internal_line==which_line){
                my_vitems.remove_del(my_loop);
                return;
            }else{
                current_internal_line++;
            }
        }
        my_loop++;
    }
}

/* return the line number which the added line belongs now */
int parser_add_line(VIEWITEMS &my_vitems, const char *write_this, int which_group)
{
    SSTRING my_temp;
    int my_loop=0;

    while(parser_load_line(my_vitems, my_temp, which_group, my_loop))
        my_loop++;
    // now my_loop is the number of the next available line

    my_temp.setfrom(write_this);
    parser_write_line(my_vitems, my_temp, which_group, my_vitems.getnb()); // my_vitems.getnb() is a trick to ensure the provided line code will never exist

    return(my_loop);
}

/* NOTE: which_line is a line dumber within the group, not the general line number */
/* return !=0 if ok, 0 if error (line not found) */
int parser_load_line(VIEWITEMS &my_vitems, SSTRING &dump_here, int which_group, int which_line)
{
    int my_loop=0;
    const char *current_string;
    VIEWITEM *my_vitem;
    int current_internal_line=0;

    while((my_vitem=my_vitems.getitem(my_loop))){
        current_string=my_vitem->line.get();
        if(return_line_id(current_string)==which_group){
            if(current_internal_line==which_line){
                gimme_word_from_string(current_string, dump_here, 1, 1);
                return(1);
            }else{
                current_internal_line++;
            }
        }
        my_loop++;
    }

    dump_here.setfrom("");
    return(0);
}

/* NOTE: which_line is a line number within the group, not the general line number */
void parser_write_line(VIEWITEMS &my_vitems, SSTRING &read_from_here, int which_group, int which_line)
{
    int my_loop=0;
    const char *current_string;
    VIEWITEM *my_vitem;
    int current_internal_line=0;
    SSTRING data_to_write;

    /* if given data is empty, simply remove the whole line */
    if(this_string_is_like_empty(read_from_here.get())){
        parser_remove_line(my_vitems, which_group, which_line);
        return;
    }

    data_to_write.setfromf("%d\t%s", which_group, read_from_here.get());

    while((my_vitem=my_vitems.getitem(my_loop))){
        current_string=my_vitem->line.get();
        if(return_line_id(current_string)==which_group){
            if(current_internal_line==which_line){
                my_vitems.getitem(my_loop)->line.setfrom(data_to_write.get());
                return;
            }else{
                current_internal_line++;
            }
        }
        my_loop++;
    }

    /* entry not found, let's create a new one.. */
    my_loop=0;
    while((my_vitem=my_vitems.getitem(my_loop))){
        current_string=my_vitem->line.get();
        if(return_line_id(current_string)>which_group){
            int real_pos;

            if(my_loop){ // not the first item
                real_pos=my_vitems.lookup(my_vitems.getitem(my_loop-1), true);
                my_vitems.insert(real_pos+1, new VIEWITEM(data_to_write.get()), -1);
            }else{ // uh-oh, the first item
                my_vitems.insert(my_loop, new VIEWITEM(data_to_write.get()));
            }
            return;
        }
        my_loop++;
    }

    /* not wrote yet? seems that we'll need to insert this item at the bottom of the file.. */
    my_vitems.add(new VIEWITEM(data_to_write.get()));
}

/* return the heading number which identifies the line's group */
/* will return 0 if 0 or nothing defined */
int return_line_id(const char *given_line)
{
    SSTRING write_here;

    gimme_word_from_string(given_line, write_here, 0);
    return(atoi(write_here.get()));
}

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number)
{
    return(gimme_word_from_string(given_string, write_here, word_number, 0));
}

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* ignores heading spaces */
    while((*read_from)&&(*read_from<=' '))
        read_from++;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        while((*read_from)&&(*read_from>' '))
            read_from++;
        while((*read_from)&&(*read_from<=' '))
            read_from++;
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        if(!to_eol){
            while((*read_from)&&(*read_from>' ')){
                read_from++;
                my_counter++;
            }
        }else{
            while(*read_from++)
                my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

/* returns !=0 if given_string had nothing but space of tabs */
int this_string_is_like_empty(const char *given_string)
{
    const char *my_position;
    char my_char;

    my_position=given_string;
    while((my_char=*my_position++)){
        if(my_char>' ')
            return(0);
    }
    return(1);
}


