
/* if is_new_entry!=0 then the 'del' button is not shown */
/* retuns !=0 if user confirmed, ==0 if cancelled or removed the entry */
int section_edit_queues_prop(VIEWITEMS &my_vitems, int which_group, int which_item, int is_new_entry)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;
    int did_user_accept=0; // 0 user cancelled, !=0 user confirmed

    INIT_PROPERTIES_EDITION;

    CREATE_STR_FIELD(my_queuename,0,MSG_U(F_QUEUENAME, "Queue name:"));
    CREATE_OPT_STR_FIELD(my_queuedir,1,MSG_U(F_QUEUEDIRECTORY, "Directory:"));
    CREATE_STR_FIELD_TO_EOL(my_prtcomm,2,MSG_U(F_PRINTCOMMAND, "Print command:"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        if(is_new_entry){
            my_button=my_dialog.edit(MSG_U(T_INSERTINGQUEUE, "Inserting queue..."), "", hf_prtqueue_props, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);
        }else{
            my_button=my_dialog.edit(MSG_U(T_EDITINGQUEUE, "Editing queue..."), "", hf_prtqueue_props, my_selection, MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_QUIT);
        }

        did_user_accept=0;
        switch(my_button){
        case MENU_DEL:
            if(askuser_for_deletion()){
                parser_remove_line(my_vitems, which_group, which_item);
                SAVE_FILE_NWSERVCONF;
                return(0);
            }
            illegal_entry_found=1;
            break;
        case MENU_ACCEPT:
            did_user_accept=1;

            illegal_entry_found|=replace_word(line_storage, my_queuename.get(), 0, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|UPPERCASE_ONLY);
            empty_is_dash(my_queuedir, 0);
            illegal_entry_found|=replace_word(line_storage, my_queuedir.get(), 1, ILLEGAL_SPACES|ILLEGAL_EMPTYNESS);
            illegal_entry_found|=replace_word_to_eol(line_storage, my_prtcomm.get(), 2, 0);

            if(!illegal_entry_found){
                CLOSE_PROPERTIES_EDITION;
                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
    return(did_user_accept);
}

void section_edit_queues(void)
{
    INIT_FILE_NWSERVCONF;

    DIALOG_RECORDS my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int which_group=21;

    my_dialog.newf_head("", MSG_U(X_QUEUENAME_QUEUEDIR, "Queue name\tQueue directory"));

    while(1){
        insert_to_dialog_records(my_dialog, my_vitems, which_group, 0, 1);

        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_DEFINEDPRTQUEUES, "Defined print queues"), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            /* adds item, but if used does not confirm the properties' window the item is removed */
            if(!section_edit_queues_prop(my_vitems, which_group, parser_add_line(my_vitems, MSG_U(X_NEWQUEUEENTRY, "QUEUE_NAME\t/printer/queue/"), which_group), 1)){
                my_vitems.remove_all();
                my_vitems.read(cf_nwservconf);
            }
            break;
        default:
            section_edit_queues_prop(my_vitems, which_group, my_selection, 0);
            break;
        }
    }
}


