#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"

static const char KMAILCONF[] = "mailconf";
extern MAILCONF_HELP_FILE help_mailconf;

CONFIG_FILE f_sendmail_cw (ETC_MAIL_SENDMAIL_CW,help_mailconf
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
	,subsys_mail);


const char *confread_getval (const char *key, const char *defval)
{
	const char *val = linuxconf_getval(KMAILCONF,key);
	if (val == NULL){
		val = defval;
	}
	return val;
}

static int confread_getval(const char *key, int defval)
{
	char valstr[20];
	sprintf (valstr,"%d",defval);
	return atoi(confread_getval(key,valstr));
}

static void confread_getall (const char *key, SSTRINGS &strs)
{
	linuxconf_getall (KMAILCONF,key,strs,1);
}

static const char DNSNEEDED[] = "dnsneeded";
static const char NODNS[] = "nodns";
static const char UUCPNOBATCH[] = "uucpnobatch";
static const char MAINSERV[] = "mainserv";
static const char HOSTSERV[] = "hostserv";
static const char DBFORMAT[] = "dbformat";
static const char DONTMASQUE[] = "dontmasque";
static const char DELIVERLOCAL[] = "deliverlocal";
static const char SMARTHOST[] = "smarthost";
static const char MAILHOST[] = "mailhost";
static const char SMARTMAILER[] = "smartmailer";
static const char ALIASES[] = "aliases";
static const char MAILAS[] = "mailas";
static const char UUCPMAX[] = "uucpmax";
static const char DELIVER[] = "deliver";
static const char MAILERTABLE[] = "mailertable";
static const char DEFERDELIV[] = "deferdeliv";
static const char BOGUSHELO[] = "bogushelo";
static const char QUEUEDELAY[] = "queuedelay";
static const char TRUST[] = "trust";
static const char USEGECOS[] = "usegecos";
static const char RELAYCTRL[] = "relayctrl";
static const char USERBL[] = "userbl";
static const char USESMRSH[]= "usesmrsh";
static const char MAXMSGSIZE[]="maxmsgsize";
static const char MAXRECIPIENTS[]="maxrecipients";
static const char VERIFY[]="verify";
static const char EXPN[]="expn";
static const char TMOUTIDENT[]="tmoutident";
static const char ETRN[]="etrn";
static const char VERB[]="verb";
static const char MAILQ[]="mailq";
static const char RUN[]="run";
static const char RECEIPTS[]="receipts";
static const char GOAWAY[]="goaway";
static const char PROBEINTERFACE[]="probeinterface";
static const char AUTHWARNINGS[]="authwarnings";
static const char QUEUEWARN[]="queuewarn";
static const char QUEUERETURN[]="queuereturn";
/*
	Return the database format for makemap
*/
const char *confread_getdbformat()
{
	return confread_getval(DBFORMAT,"hash");
}

PUBLIC MAILCONF::MAILCONF()
{
	features.uucpmax = confread_getval(UUCPMAX,200000);
	features.dnsneeded = confread_getval(DNSNEEDED,0);
	features.nodns = confread_getval(NODNS,0);
	features.uucpnobatch = confread_getval(UUCPNOBATCH,1);
	features.mailertable = confread_getval (MAILERTABLE,0);
	features.deferdeliv = confread_getval(DEFERDELIV,0);
	features.bogushelo = confread_getval(BOGUSHELO,0);
	features.queuedelay = confread_getval(QUEUEDELAY,15);
	features.dbformat.setfrom (confread_getdbformat());
	features.usegecos = confread_getval(USEGECOS,0);
	features.relayctrl = confread_getval(RELAYCTRL,1);
	features.userbl = confread_getval(USERBL,0);
	features.usesmrsh = confread_getval(USESMRSH,0);
	features.expn = confread_getval(EXPN,0);
	features.verify = confread_getval(VERIFY,0);
	features.tmoutident = confread_getval(TMOUTIDENT,0);

	features.etrn = confread_getval(ETRN,1);
	features.verb = confread_getval(VERB,1);
	features.run = confread_getval(RUN,1);
	features.mailq = confread_getval(MAILQ,1);
	features.receipts = confread_getval(RECEIPTS,1);
	features.goaway = confread_getval(GOAWAY,1);
	features.probeinterface = confread_getval(PROBEINTERFACE,0);
	features.authwarnings = confread_getval(AUTHWARNINGS,1);
	features.queuewarn.setfrom(confread_getval(QUEUEWARN,"4h"));
	features.queuereturn.setfrom(confread_getval(QUEUERETURN,"5d"));

	users.dontmasque.setfrom (confread_getval(DONTMASQUE,"root"));
	users.deliverlocal.setfrom (confread_getval(DELIVERLOCAL,"root"));
	users.trust.setfrom (confread_getval(TRUST,"root daemon uucp"));
	smarthost.setfrom (confread_getval(SMARTHOST,""));
	mailhost.setfrom (confread_getval(MAILHOST,""));
	smartmailer.setfrom (confread_getval(SMARTMAILER,"smtp"));
	confread_getall (ALIASES,alias);
	sendmail_cw = false;
	if (alias.getnb()==0){
		/* #Specification: mailconf / sendmail.cw
			Originally, linuxconf was not supporting sendmail.cw
			and the aliases were recorded in /etc/conf.linuxconf.
			A migration strategy was installed in 1.16r2. If
			conf.linuxconf do contain some aliases, they are used.
			If not, /etc/mail/sendmail.cw is used. When saving
			the aliases in /etc/conf.linuxconf are removed and
			sendmail.cw is rewritten.
		*/
		FILE_CFG *fin = f_sendmail_cw.fopen ("r");
		if (fin != NULL){
			sendmail_cw = true;	// Remember where came from the aliases
			char buf[1000];
			while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
				strip_end(buf);
				if (buf[0] !=  '\0') alias.add (new SSTRING(buf));
			}
			fclose (fin);
		}
	}
	mailas.setfrom (confread_getval(MAILAS,""));
	deliver.setfrom (confread_getval(DELIVER,""));
	mainserv = confread_getval(MAINSERV,0);
	hostserv = confread_getval(HOSTSERV,1);
	features.maxmsgsize = confread_getval (MAXMSGSIZE,0);
	features.maxrecipients = confread_getval (MAXRECIPIENTS,0);
}

void confread_replace (const char *key, const char *val)
{
	linuxconf_replace (KMAILCONF,key,val);
}

static void confread_replace (const char *key, const SSTRING &val)
{
	confread_replace (key,val.get());
}

static void confread_replace (const char *key, int val)
{
	char valstr[10];
	sprintf (valstr,"%d",val);
	confread_replace (key,valstr);
}

#if 0
static void confread_replace (const char *key, const SSTRINGS &vals)
{
	linuxconf_replace (KMAILCONF,key,vals);
}
#endif
/*
	Write sendmail configuration in /etc/conf.linuxconf
*/
PUBLIC int MAILCONF::write()
{
	linuxconf_setcursys (subsys_mail);
	confread_replace (DNSNEEDED,features.dnsneeded);
	confread_replace (UUCPMAX,features.uucpmax);
	confread_replace (NODNS,features.nodns);
	confread_replace (DEFERDELIV,features.deferdeliv);
	confread_replace (BOGUSHELO,features.bogushelo);
	confread_replace (MAILERTABLE,features.mailertable);
	confread_replace (UUCPNOBATCH,features.uucpnobatch);
	confread_replace (QUEUEDELAY,features.queuedelay);
	confread_replace (DBFORMAT,features.dbformat);
	confread_replace (USEGECOS,features.usegecos);
	confread_replace (MAILHOST,mailhost);
	confread_replace (SMARTHOST,smarthost);
	confread_replace (SMARTMAILER,smartmailer);
	confread_replace (MAILAS,mailas);
	confread_replace (DELIVERLOCAL,users.deliverlocal);
	confread_replace (DONTMASQUE,users.dontmasque);
	confread_replace (TRUST,users.trust);
	linuxconf_removeall (KMAILCONF,ALIASES);
	sendmail_cw = true;	// From now on the aliases come from sendmail.cw
	FILE_CFG *fout = f_sendmail_cw.fopen ("w");
	if (fout != NULL){
		for (int i=0; i<alias.getnb(); i++){
			fprintf (fout,"%s\n",alias.getitem(i)->get());
		}
		fclose (fout);
	}

	confread_replace (DELIVER,deliver);
	confread_replace (MAINSERV,mainserv);
	confread_replace (HOSTSERV,hostserv);
	linuxconf_setcursys (subsys_relaycontrol);
	confread_replace (RELAYCTRL,features.relayctrl);
	confread_replace (USERBL,features.userbl);
	confread_replace (USESMRSH,features.usesmrsh);
	confread_replace (VERIFY,features.verify);
	confread_replace (TMOUTIDENT,features.tmoutident);
	confread_replace (EXPN,features.expn);
	confread_replace (MAXMSGSIZE,features.maxmsgsize);
	confread_replace (MAXRECIPIENTS,features.maxrecipients);

	confread_replace (ETRN,features.etrn);
	confread_replace (VERB,features.verb);
	confread_replace (RUN,features.run);
	confread_replace (MAILQ,features.mailq);
	confread_replace (RECEIPTS,features.receipts);
	confread_replace (GOAWAY,features.goaway);
	confread_replace (PROBEINTERFACE,features.probeinterface);
	confread_replace (AUTHWARNINGS,features.authwarnings);
	confread_replace (QUEUEWARN,features.queuewarn);
	confread_replace (QUEUERETURN,features.queuereturn);

	return linuxconf_save();
}

/*
	Return the queue processing delay in minutes.
	Used to call sendmail (option -q)
*/
PUBLIC int MAILCONF::getqueuedelay()
{
	return features.queuedelay;
}

