// vim: nowrap

/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include <errno.h>
#include <unistd.h>
#include "kbdconf.h"
#include "../../paths.h"
#include "paths.h"
#include <subsys.h>
#include <translat.h>

MODULE_DEFINE_VERSION(kbdconf);

static const char subsys_kbdconf[]="kbdconf";
static LINUXCONF_SUBSYS sub (subsys_kbdconf,P_MSG_U(S_KEYBOARD,"Text keyboard configuration"));
CONFIG_FILE f_keyboard (ETC_SYSCONFIG_KEYBOARD,help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, subsys_kbdconf);
HELP_FILE help_kbdconf ("kbdconf","kbdconf"); 

PUBLIC MODULE_kbdconf::MODULE_kbdconf()
	: LINUXCONF_MODULE("kbdconf")
{
	linuxconf_loadmsg ("kbdconf",PACKAGE_REV);
	module_register_api ("kbdconf",1,kbdconf_api_get,kbdconf_api_release); 
}


static const char *keymenu=NULL;

PUBLIC void MODULE_kbdconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_HARDWARE){
		keymenu = MSG_U(M_kbdconf,"Text mode keyboard configuration");
		dia.new_menuitem ("kbdconf","",keymenu);
	}
}

PUBLIC int MODULE_kbdconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_HARDWARE){
		if (key == keymenu){
			// ### Place the call to the edit function here
			kbdconf();
		}
	}
	return 0;
}


PUBLIC int MODULE_kbdconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"kbdconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain kbdconf usage\n"
		 "\n"
		 "    kbdconf --option ...\n")
		);
}

PUBLIC void MODULE_kbdconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_kbdconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"kbdconf")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
			kbdconf();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}

static MODULE_kbdconf kbdconf;

PUBLIC void MODULE_kbdconf::kbdconf(){	
	DATALIST data(1); // pass 1 for verbose. This parameters is 0 when the DATALIST are created by api
	if (!data.init()){ // initialize. Read the configuration
		xconf_notice (MSG_U(E_WHILEINIT,"Error trying initialize configuration"));
		return;
	}
	
	int nof = 0;
	bool xaccess = 0;
	DIALOG dia;
	
	DEVICELIST devlist(USR_LIB_LINUXCONF "/device_lists/keyboard.list","keyboard"); // the list of keyboard's
	
	XKBDCONF_API *api = Xkbdconf_api_init("Xkbdconf"); // initialize the Xkbdconf_api
	SSTRINGS ctermopts;       // will contain the console maps
	ctermopts.neverdelete();  // never delete because its only get the list generated by data.getKeyboardConfig()
	SSTRING test;		  // a test string for test the keyboard configuration
	SSTRING current;	  // current configuration

	if (api!=NULL && api->isXFconfigaccessible() && api->init())	xaccess = 1;	// check if the api can be initialized
	
	data.getKeyboardConfig(devlist); 	// populate keyboard table
	data.getlistmodels(ctermopts);		// populate the list of map descriptions in ctermopts
	ctermopts.remove_dups();
	ctermopts.sort();
	
	dia.setbutinfo (MENU_USR1, MSG_U(B_SETTODEFAULT,"Default"), MSG_R(B_SETTODEFAULT));
	dia.setbutinfo (MENU_USR2, MSG_U(B_APPLY,"Apply"), MSG_R(B_APPLY));
	
	current.setfrom(data.getdescbyname(data.keytable.get()));
	FIELD_COMBO *combo = dia.newf_combo(MSG_U(F_KEYBOARD,"Keyboards"), current);
/*	
	// add each item and check its compatibility with X
	for (int i=0; i<ctermopts.getnb(); i++){
		const char *descr = "";
		const char *name = ctermopts.getitem(i)->get();
		
		DEVICE *dev = devlist.getitem_by_opt ("clayout", name);
		if (dev)	descr = dev->descr;
		combo->addopt(name, descr);
	}
*/
	combo->addopts(ctermopts);

	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_BASIC,"Keyboard Layout configuration")
			,""
			,help_kbdconf
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1|MENUBUT_USR2);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		} else if (code == MENU_ACCEPT){
			const char *name = data.getnamebydesc(current.get()); // get the name of the description
			if (name){ 
				if (data.keytable.cmp(name)!=0){ // if changed
					if(data.save(name)){
						xconf_notice (MSG_U(N_SAVED,"Configuration saved"));
						data.updatekeyboard(); // update the console keyboard
						if (xaccess)	checkXcomp (api, &devlist, name);
					} else  xconf_notice (MSG_U(E_FILECANTBESAVED,"Can't save configuration"));
				}
			} else 	xconf_notice (MSG_R(E_LAYOUTCANTBESAVED));
			break;	
		} else if (code == MENU_USR1){ //restore to default values 
			if (data.keytable.cmp(data.defkeytable)!=0){
				data.restoretodefault();
				if(data.save()){
					xconf_notice (MSG_R(N_SAVED));
					current.setfrom(data.keytable);
					data.updatekeyboard();
					current.setfrom(data.getdescbyname(data.keytable.get()));
					if (xaccess)	checkXcomp (api, &devlist, data.keytable.get());
					//test.setfrom("");
					dia.reload ();
				} else  xconf_error (MSG_U(E_DEFAULT,"Error while restoring configuration"));
			}
		} else if (code == MENU_USR2){
			dia.save();
			const char *name = data.getnamebydesc(current.get());
			if (name){
				if (data.keytable.cmp(name)!=0){
					if(data.save(name)){
						xconf_notice (MSG_R(N_SAVED));
						data.updatekeyboard();
						if (xaccess)	checkXcomp (api, &devlist, data.keytable.get());
					} else 	xconf_notice (MSG_R(E_FILECANTBESAVED));
				}
			} else	xconf_notice (MSG_U(E_LAYOUTCANTBESAVED,"This layout can't be saved"));
		}
	}
	Xkbdconf_api_end (api);
}
/*
		if (api != NULL){
			xconf_notice ("ACHEI API Xkbdconf");
			xconf_notice ("%s",api->touch());
		} else {
			xconf_notice ("NAO ACHEI API Xkbdconf");
		}
*/

/*
DESCRIPTION: Check the X keyboard compatibility.
RETURN: Nothing
*/
void checkXcomp (XKBDCONF_API *api, DEVICELIST* devlist, const char *name){
	DEVICE *dev = devlist->getitem_by_name (name);
	
	if (dev){
		const char *xlayout = dev->get_option("xlayout");
		const char *clayout = dev->get_option("clayout");
		if (xlayout && clayout){
			if (strcmp(xlayout, api->getlayout()) != 0){
				if (dialog_yesno (MSG_U(N_ALERT,"Alert!"),
						  MSG_U(N_SAMELAYOUT,
							"The selected layout has the same\n"
							"configuration for X11\n"
							"Do you want to switch the X11 layout too"),
							 help_kbdconf)==MENU_YES ){
					if (api->setXlayoutconfig(xlayout))
						api->updateXkeyboard();
					else xconf_error (MSG_U(E_XCFGCANTBESAVED,
							"X configuration can't be saved"));
				}
			}
		}
	}
}
