#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "firewall.h"
#include "firewall.m"
#include <netconf.h>

static HELP_FILE help_menu ("firewall","menu");

MODULE_DEFINE_VERSION(firewall);

PUBLIC MODULE_firewall::MODULE_firewall()
	: LINUXCONF_MODULE("firewall")
{
	linuxconf_loadmsg ("firewall",PACKAGE_REV);
}


static const char *firewallc=NULL;
static const char *firewallf=NULL;
static const char *firewallb=NULL;
static const char *firewallo=NULL;
static const char *firewalla=NULL;
static const char *rstfirewall=NULL;
static const char *key_fw_status=NULL;

PUBLIC void MODULE_firewall::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_FIREWALL){
		firewallc = MSG_U(M_FWDEF,"Firewalling defaults (packet filtering)");
		firewallb = MSG_U(M_BLOCK,"Input firewalling");
		firewallf = MSG_U(M_FORWARD,"Forward firewalling");
		firewallo = MSG_U(M_OUTPUT,"Output firewalling");
		firewalla = MSG_U(M_ACCT,"Packet accounting");
		static const char *menuopt[]={
			"firewall:",	firewallc,
			"input:",		firewallb,
			"forward:",		firewallf,
			"output:",		firewallo,
			"acct:",		firewalla,
			NULL
		};
		dia.new_menuitems (menuopt);
	}else if (context == MENU_CONTROL_PANEL){
		rstfirewall = MSG_U(M_RSTFIREWALL,"Turn off firewalling");
		dia.new_menuitem ("",rstfirewall);
	}else if (context == MENU_SYS_STATUS){
		if (kernel_newer(2,2,0)){
			key_fw_status = MSG_U(M_FW_STATUS,"Firewall");
			dia.new_menuitem ("",key_fw_status);
		}
	}
}

PUBLIC int MODULE_firewall::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_FIREWALL){
		if (key == firewallc){
			firewall_editc(NULL);
		}else if (key == firewallf){
			firewall_editf(NULL);
		}else if (key == firewallb){
			firewall_editb(NULL);
		}else if (key == firewalla){
			firewall_edita(NULL);
		}else if (key == firewallo){
			firewall_edito(NULL);
		}
	}else if (context == MENU_CONTROL_PANEL){
		if (key == rstfirewall){
			firewall_reset(NULL);
			xconf_notice (MSG_U(N_FIREWALLRESET
				,"The firewalling rules have been disabled\n"
				 "They will be activated again anytime you let\n"
				 "Linuxconf activate configuration changes."));
		}
	} else if (context == MENU_SYS_STATUS){
		if (key == key_fw_status){
			fw_status();
		}
	}
	return 0;
}


PUBLIC int MODULE_firewall::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"firewall")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}

PUBLIC int MODULE_firewall::probe (
	int level,
	int ,
	bool)
{
	if (level == 2){
		net_title (MSG_U(S_FIREWALL,"Setting firewalling"));
		firewall_setup (NULL);
	}
	return 0;
}

PUBLIC int MODULE_firewall::message (const char *msg, int , const char *[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"resetfw")==0){
		net_introlog (NETINTRO_MISC);
		ret = firewall_reset(NULL);
	}else if (strcmp(msg,"setfw")==0){
		net_introlog (NETINTRO_MISC);
		ret = firewall_setup(NULL);
	}
	return ret;
}



static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"module firewall\n"
		 "\n"
		 "    --resetfw\n"
		 "    --setfw\n"
		 "    --status\n"
		 "    --update\n")
		);
}

static void firewall_mainmenu()
{
	firewallc = MSG_R(M_FWDEF);
	firewallb = MSG_R(M_BLOCK);
	firewallf = MSG_R(M_FORWARD);
	firewallo = MSG_R(M_OUTPUT);
	firewalla = MSG_R(M_ACCT);
	static const char *menuopt[]={
		"firewall:",	firewallc,
		"input:",		firewallb,
		"forward:",		firewallf,
		"output:",		firewallo,
		"acct:",		firewalla,
		NULL
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_FIREWALL,"Firewall configuration")
			,"",help_menu,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else{
			const char *key = dia.getmenustr(nof);
			if (key == firewallc){
				firewall_editc(NULL);
			}else if (key == firewallf){
				firewall_editf(NULL);
			}else if (key == firewallb){
				firewall_editb(NULL);
			}else if (key == firewalla){
				firewall_edita(NULL);
			}else if (key == firewallo){
				firewall_edito(NULL);
			}
		}
	}
}


PUBLIC int MODULE_firewall::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"firewall")==0){
		ret = -1;
		if (argc == 1){
			if (netconf_rootaccess()){
				firewall_mainmenu();
			}
		}else if (argc == 2){
			if (netconf_rootaccess()){
				net_introlog (NETINTRO_MISC);
				if (strcmp(argv[1],"--resetfw")==0){
					ret = firewall_reset(NULL);
				}else if (strcmp(argv[1],"--setfw")==0
					|| strcmp(argv[1],"--update")==0){
					ret = firewall_setup(NULL);
				}else if (strcmp(argv[1],"--status")==0){
					simul_init (stdout);
					ret = firewall_setup(NULL);
				}else{
					::usage();
				}
			}
		}else{
			::usage();
		}
	}
	return ret;
}


static MODULE_firewall firewall;

