/*
 * This module is written and maintained by Torbjrn Gard (tgard@netg.se)
 * It is released as part of LinuxConf with the same licensing policy (GPL).
 */
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <usercomng.h>
#include <userconf.h>
#include <subsys.h>
#include "fetchmailconf.h"
#include "fetchmailconf.m"
#include "basicsedit.h"
#include "serveredit.h"
#include "useridedit.h"
#include "comng.h"

// config_file()
#include <pwd.h>
#include <sys/types.h>
// end config_file()

const char subsys_fetchmailconf[]="fetchmailconf";
static LINUXCONF_SUBSYS subb (subsys_fetchmailconf,P_MSG_U(T_FETCHMAILCONF,
	"Remote mail servers (fetchmail)"
	));


static HELP_FILE help_fetchmailrc ("fetchmailconf","fetchmailrc");

MODULE_DEFINE_VERSION(fetchmailconf);

static MODULE_fetchmailconf fetchmailconf;

static HELP_FILE help_fetchmailconf ("fetchmailconf","fetchmailconf");

/*
 * config_file() creates a CONFIG_FILE with default name ".fetchmailrc"
 * in the home directory of "root".
 */
CONFIG_FILE *f_config_file = NULL;
static void config_file( void )
{
	if ( f_config_file != NULL ) {
		return;
	}
	char path[PATH_MAX];

	struct passwd *p = getpwnam("root");
	sprintf (path,"%s/.fetchmailrc",p->pw_dir);
	// fprintf(stderr,"fetchmailconf.cc: config_file() path=%s\n", path);
	f_config_file = new CONFIG_FILE (
		path
		,help_fetchmailrc
		,CONFIGF_OPTIONAL|CONFIGF_MANAGED|CONFIGF_PROBED
		,"root"
		,"root"
		,0600
		,subsys_fetchmailconf);
}

PUBLIC MODULE_fetchmailconf::MODULE_fetchmailconf()
	: LINUXCONF_MODULE("fetchmailconf")
{
	//fprintf(stderr,"MODULE_fetchmailconf::MODULE_fetchmailconf\n");
	linuxconf_loadmsg ("fetchmailconf",PACKAGE_REV);
	config_file();
}

static const char *keymenu=NULL;

PUBLIC void MODULE_fetchmailconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_CLIENT){
//fprintf(stderr,"MODULE_fetchmailconf::setmenu\n");
		keymenu = MSG_U(M_FETCHMAILCONF, "Remote mail servers (fetchmail)");
//		Crashes when icon specified! Why? fetchmailconf.xpm is 50x50
//		dia.new_menuitem ("fetchmailconf","",keymenu);
		dia.new_menuitem ("",keymenu);
	}
}

PUBLIC int MODULE_fetchmailconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_CLIENT){
		if (key == keymenu){
			fetchmailconf_menu();
		}
	}
	return 0;
}


PUBLIC int MODULE_fetchmailconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"fetchmailconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}

PUBLIC int MODULE_fetchmailconf::message (
	const char *msg,
	int argc,
	const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"about")==0){
		ret = 0;
		SSTRINGS *tb = (SSTRINGS*)argv[0];
		tb->add (new SSTRING(MSG_U(A_ABOUT1,"Module fetchmailconf was written by Torbjrn Gard (tgard@netg.se)")));
	}
	return ret;
}

static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module fetchmailconf\n"
		 "linuxconf --modulemain fetchmailconf\n"
		 "\n"
		 "    No command line option\n"
		 "\n")
		);
}

PUBLIC void MODULE_fetchmailconf::usage(SSTRINGS &tb)
{
	tb.add (new SSTRING(MSG_R(T_USAGE)));
}


PUBLIC int MODULE_fetchmailconf::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"fetchmailconf")==0){
		ret = -1;
		if (argc == 1){
			fetchmailconf_menu();
			ret = 0;
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


PUBLIC int MODULE_fetchmailconf::probe (
	int level,	// Current level being probed
			// Only service of this level should do something.
	int target,	// target network runlevel of the probe
			// In which runlevel the machine is going to be
			// after the probe has completed
	bool simulation )	// simulation mode ?
{
//fprintf(stderr,"MODULE_fetchmailconf::probe level=%d target=%d %s\n", level, target, simulation?"simulation":"no simulation");
	if (level == 2 && target == 2) {
		/*
		 * Normal check of boot time daemon or after configuration
		 * change.
		 */
		return( fetchmail_probe( level, target, simulation ) );
	}
	return 0;
}

void fetchmailconf_menu()
{
//fprintf(stderr,"fetchmailconf_menu\n");
	static const char *m_basics = MSG_U(M_DEFAULT,"Basics");
	static const char *m_serverlist = MSG_U(M_SERVERLIST,"Mail servers");
	static const char *m_useridlist = MSG_U(M_USERIDLIST,"Users");
	static const char *menuopt[]={
		"",		m_basics,
		"",		m_serverlist,
		"",		m_useridlist,
		NULL,
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	int choice=0;
	while( 1 ) {
		MENU_STATUS code = dia.editmenu (MSG_U(M_FETCHMAIL_MENU, "Fetchmail administration")
			,MSG_U(I_FETCHMAIL,
			"This menu allows you to configure how to fetch mail\n"
			"for any number of users from remote mail servers\n"
			"using fetchmail")
			,help_fetchmailconf
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
//fprintf(stderr,"fetchmailconf_menu code=%d choice=%d\n", code, choice);
			const char *key = menuopt[choice*2+1];
			if (key == m_basics){
				basics_edit();
			}else if (key == m_serverlist){
	 			serverlist_edit();
			}else if (key == m_useridlist){
	 			useridlist_edit();
			}
		}
	}	
}

/*
 * Handler routines
 */
void basics_edit()
{
//fprintf(stderr,"fetchmailconf.cc: basics_edit()\n");
	BASICS basics( subsys_fetchmailconf );
	basics.read( );
	(void)basics.edit( );
}

void serverlist_edit()
{
//fprintf(stderr,"fetchmailconf.cc: serverlist_edit()\n");
	SERVERLIST *serverlist = new SERVERLIST( );
	serverlist->read( );
	(void)serverlist->edit( );
	delete serverlist;
}

void useridlist_edit()
{
//fprintf(stderr,"fetchmailconf.cc: useridlist_edit()\n");
	SERVERLIST *serverlist = new SERVERLIST( );
	SERVER *server = serverlist->select( );
	if ( server == NULL ) {
		return;
	}
	USERIDLIST *useridlist = new USERIDLIST( );
	useridlist->read( server );
	(void)useridlist->edit( server );
	delete serverlist;
	delete useridlist;
}

int fetchmail_probe( int level, int target, int simulation )
{
//fprintf(stderr,"fetchmailconf.cc: fetchmail_probe() %s\n", simulation?"(simulation)":"");
	BASICS basics( subsys_fetchmailconf );
	basics.read( );
	return ( basics.probe( level, target, simulation ) );
}

/*
 * Co-manager for user dialogs
 */

USERACCT_COMNG *fetchmail_comng( const char *key, DICTIONARY &dict)
{
//fprintf( stderr, "fetchmailconf.cc: USERACCT_COMNG::fetchmail_comng: key=%s\n", key);
	USERACCT_COMNG *ret = NULL;
	const char *domain = dict.get_str( "domain" );
	int category = dict.get_int( "categ" );
	if ( strcmp( key, "user" ) == 0
	&& ( strcmp( domain, "/" ) == 0 )
	&& ( category == TUSER_STD ) )
	{
		ret = new FETCHMAIL_COMNG( dict );
	}
	return( ret );
}

static REGISTER_USERACCT_COMNG register_comng( fetchmail_comng );
