#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <sys/stat.h>
#include "internal.h"
#include "dnsconf.h"
#include "dnsconf.m"
#include <netconf.h>
#include <dialog.h>

static DNSCONF_HELP_FILE help_forward("forward");



PUBLIC FORWARD::FORWARD(
	const char *_domain,
	const char **_ip_addr,
	int nb_ip)
{
	domain.setfrom (_domain);
	for (int i=0; i<nb_ip; i++) addrs.add (new IP_ADDR(_ip_addr[i]));
	domainv.setfrom (_domain);
	isrev = 0;
	zonetype=ZONE_FORWARD;
	option_forward_only=FORWARD_FIRST;
}

PUBLIC FORWARD::FORWARD()
{
	isrev=0;
	zonetype=ZONE_FORWARD;
	option_forward_only=FORWARD_FIRST;
}

PUBLIC void FORWARD::write(bool bind8, FILE_CFG *fout) const
{
	if (bind8){
		fprintf (fout,"zone \"%s\"{\n",domain.get());
		fprintf (fout,"\ttype forward;\n");
		if (option_forward_only == FORWARD_FIRST) {
			fputs("\tforward only;\n",fout);
		}
		fputs ("\tforwarders{\n",fout);
		for (int i=0; i<addrs.getnb(); i++){
			const char *s = addrs.getitem(i)->get();
			if (s[0] != '\0') fprintf (fout,"\t\t%s;\n",s);
		}
		fputs ("\t};\n",fout);
		fputs ("};\n",fout);
	}
}


/*
	Edit the minimal spec so this dns will act as a secondary for another
	Return -1 if the user escaped away.
	Return  0 if the changes are accepted
	Return  1 if the user wish to delete this entry
*/
PUBLIC int FORWARD::edit (DNS &dns)
{
	DIALOG dia;
	dia.newf_str (MSG_R(F_DOMAIN),domain);
	dia.newf_title (MSG_U(F_FORLIST,"Forwarders server(s)"),1,"",MSG_R(F_FORLIST));
	for (int i=0; i<3; i++) addrs.add (new IP_ADDR);
	dia.newf_str (MSG_R(F_IPSERV),*addrs.getitem(0));
	for (int i=1; i<addrs.getnb(); i++){
		dia.newf_str ("",*addrs.getitem(i));
	}
	int ret = -1;
	int nof = 0;
	while (1){
		MENU_STATUS status = dia.edit (
			 MSG_U(T_FORSPEC
			 ,"Forward zone specification")
			,MSG_U(I_FORSPEC
			 ,"You must enter a domain\n")
			,help_forward
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_DEL);

		if (status == MENU_CANCEL || status == MENU_ESCAPE){
			break;
		}else if (status == MENU_DEL){
			if (xconf_areyousure(MSG_U(Q_DELFORWARD
				,"Confirm deletion of a forward spec"))){
				ret = 1;
				break;
			}
		}else{
			const char *domname = domain.get();
			SECONDARY *sec = dns.findsecond (domname);
			PRIMARY  *dom = dns.finddomain (domname);
			FORWARD *forw = dns.findforward (domname);
			if (domain.is_empty()) {
				xconf_error(MSG_U(E_FILLDOMU
					,"Fill at least the domain\n"));
			}else if (forw != NULL && forw != this){
				xconf_error (MSG_R(E_DOMEXIST));
			}else if (dom != NULL){
				xconf_error (MSG_R(E_ISAPRIMARY));
			}else if (sec != NULL){
				xconf_error (MSG_R(E_ISASECOND));
			}else{
				remove_empty();
				ret = 0;
				break;
			}
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

PUBLIC FORWARD *FORWARDS::getitem (int no) const
{
	return (FORWARD*)ARRAY::getitem(no);
}

PUBLIC FORWARD *FORWARDS::getitem (const char *name) const
{
	FORWARD *ret = NULL;
	int n = getnb();
	for (int i=0; i<n; i++){
		FORWARD *s = getitem(i);
		if (s->domain.cmp(name)==0){
			ret = s;
			break;
		}
	}
	return ret;
}

PUBLIC void FORWARDS::write (bool bind8, FILE_CFG *fout) const
{
	if (bind8) {
		for (int i=0; i<getnb(); i++) getitem(i)->write(bind8,fout);
	}
}

PUBLIC void FORWARDS::edit(DNS &dns)
{
	int choice=0;
	DIALOG_LISTE dia;
	dia.newf_head ("",MSG_U(H_FORWARDS,"domain\tforwarders\t"));
	dia.addwhat (MSG_U(I_ADDFOR,"Select [Add] to add one forward spec"));
	while (1){
		int nb = getnb();
		for (int i=0; i<nb; i++){
			FORWARD *s = getitem(i);
			char buf[4*LEN_IP_ASC+30];
			char *pt = buf;
			const char *ctl = "%s";
			for (int a=0; a<s->addrs.getnb(); a++){
				if (!s->addrs.getitem(a)->is_empty()){
					pt += sprintf (pt,ctl,s->addrs.getitem(a)->get());
					ctl = ",%s";
				}
			}
			*pt++ = '\t';
			*pt = '\0';
			dia.set_menuitem (i,s->domain.get(),buf);
		}
		dia.remove_last (nb+1);
		MENU_STATUS code = dia.editmenu (MSG_U(T_FORWARDS,"Forward zones")
			,MSG_U(I_FORWARDS
				,"You are allowed to edit/add/remove forward zones\n")
			,help_forward
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			FORWARD *forw = new FORWARD;
			if (forw->edit(dns)==0){
				add (forw);
				dns.write();
			}else{
				delete forw;
			}
		}else{
			FORWARD *forw = getitem(choice);
			if (forw != NULL){
				int ok = forw->edit(dns);
				if (ok != -1){
					if (ok == 1) remove_del (forw);
					dns.write();
				}
			}
		}
	}
}

