
#include <stdlib.h>
#include <string.h>
#include <fviews.h>
#include "aptconf.h"

static CONFIG_FILE slist_file(
		"/etc/apt/sources.list",
		help_nil,CONFIGF_MANAGED,
		"root","root",0600);

PRIVATE bool SLIST::parse_line(const char *line, SLIST_ITEM &slitem)
{
	const char *s, *e = line;
	while (*e != 0 && (*e == ' ' || *e == '\t')) e++;
	if (*e == 0) return false;
	s = e;
	while (*e != 0 && *e != ' ' && *e != '\t') e++;
	if (*e == 0) return false;
	slitem.type.setfrom(s, e-s);
	while (*e != 0 && (*e == ' ' || *e == '\t')) e++;
	if (*e == 0) return false;
	s = e;
	while (*e != 0 && *e != ' ' && *e != '\t') e++;
	if (*e == 0) return false;
	if (*s == '['){
		slitem.vendor.setfrom(s+1, e-s-2);
		while (*e != 0 && (*e == ' ' || *e == '\t')) e++;
		if (*e == 0) return false;
		s = e;
		while (*e != 0 && *e != ' ' && *e != '\t') e++;
		if (*e == 0) return false;
	}
	slitem.uri.setfrom(s,e-s);
	while (*e != 0 && (*e == ' ' || *e == '\t')) e++;
	if (*e == 0) return false;
	s = e;
	while (*e != 0 && *e != ' ' && *e != '\t') e++;
	if (*e == 0) return false;
	slitem.distr.setfrom(s,e-s);
	while (*e != 0 && (*e == ' ' || *e == '\t')) e++;
	if (*e == 0) return true;
	s = e;
	for (const char *le = e; *le != 0; le++){
		if (*le != ' ' && *le != '\t') e = le+1;
	}
	slitem.comp.setfrom(s,e-s);
	return true;
}

PUBLIC SLIST::SLIST()
{
	vi.read(slist_file);
	modified = 0;
}

PUBLIC SLIST::~SLIST()
{
	if (modified){
		vi.write(slist_file,NULL);
	}
}

PUBLIC int SLIST::count()
{
	return vi.getnb();
}

PUBLIC bool SLIST::get(int nb, SLIST_ITEM &slitem)
{
	VIEWITEM *it = vi.getitem(nb);
	if (it != NULL){
		return parse_line(it->line.get(),slitem);
	}
	return false;
}

PUBLIC void SLIST::set(int nb, SLIST_ITEM &slitem)
{
	const char *type = slitem.type.get();
	const char *vendor = slitem.vendor.get();
	const char *uri = slitem.uri.get();
	const char *distr = slitem.distr.get();
	const char *comp = slitem.comp.get();
	int type_len = slitem.type.getlen();
	int vendor_len = slitem.vendor.getlen();
	int uri_len = slitem.uri.getlen();
	int distr_len = slitem.distr.getlen();
	int comp_len = slitem.comp.getlen();
	
	char *linep;
	
	char *line = (char *) malloc (type_len+vendor_len+2+uri_len+distr_len
				      +comp_len+5);
	
	linep = line;
	
	while (*type != 0 && *type != ' ' && *type != '\t'){
		*linep++ = *type++;
	}
	*linep++ = ' ';
	if (vendor_len > 0){
		*linep++ = '[';
		while (*vendor != 0 && *vendor != ' ' && *vendor != '\t'){
			*linep++ = *vendor++;
		}
		*linep++ = ']';
		*linep++ = ' ';
	}
	while (*uri != 0 && *uri != ' ' && *uri != '\t'){
		*linep++ = *uri++;
	}
	*linep++ = ' ';
	while (*distr != 0 && *distr != ' ' && *distr != '\t'){
		*linep++ = *distr++;
	}
	while (*comp != 0){
		while (*comp != 0 && (*comp == ' ' || *comp == '\t')) comp++;
		if (*comp == 0) break;
		*linep++ = ' ';
		while (*comp != 0 && *comp != ' ' && *comp != '\t'){
			 *linep++ = *comp++;
		}
	}
	
	*linep = 0;
	
	if (nb >= vi.getnb()){
		VIEWITEM *it = new VIEWITEM(line,VIEWITEM_VARIABLE);
		vi.add(it);
	}else{
		VIEWITEM *it = vi.getitem(nb);
		it->line.setfrom(line);
	}

	modified = true;
}

PUBLIC void SLIST::erase(int nb)
{
	vi.remove_del(nb);
}

PUBLIC bool SLIST_ITEM::check()
{
	if (type.getlen() > 0 && uri.getlen() > 0 && distr.getlen() > 0){
		return true;
	}
	return false;
}
