/*
 Amandaconf 1.1 - Linuxconf module for Amanda configuration
 by Daniel Mealha Cabrita (dancab@conectiva.com)
 Nov 30th, 2000

history:

1.0 - first version (already present in 1.22) Sep 20th, 2000
1.1 - worked on 1.22. Nov 30th, 2000
    - now lists (ex.: holding disks' list) are refreshed in a different
      manner so they no longer flashes and, now, the last selection
      is kept.

*/



#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_main.cc"

MODULE_DEFINE_VERSION(amandaconf);

PUBLIC MODULE_amandaconf::MODULE_amandaconf()
	: LINUXCONF_MODULE("amandaconf")
{
	linuxconf_loadmsg ("amandaconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_amandaconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MISCSERV){
		keymenu = MSG_U(M_amandaconf,"Amanda configurator");
		dia.new_menuitem ("amandaconf","",keymenu);
	}
}

PUBLIC int MODULE_amandaconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MISCSERV){
		if (key == keymenu){
			// ### Place the call to the edit function here
                    start_things();
                }
	}
	return 0;
}


PUBLIC int MODULE_amandaconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"amandaconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain amandaconf usage\n"
		 "\n"
		 "    amandaconf --option ...\n")
		);
}

PUBLIC void MODULE_amandaconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_amandaconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"amandaconf")==0){
		ret = -1;
		if (argc == 1){
                    start_things();
                    // ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_amandaconf amandaconf;

