
/* tape types */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "amandaconf.h"
#include "amandaconf.m"

#include "am_tools.h"
#include "lame_parser.h"

void edit_specified_tapetype(t_parser_control *parser_control, const char *tapetype_name)
{
    struct {
        SSTRING comment;
        complexint filemark,
            length,
            speed;
    } my_intvars;

    const char *groupname;
    SSTRING sgroupname;
    SSTRING dialog_title;
    DIALOG my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    sgroupname.setfromf("define tapetype %s {", tapetype_name);
    groupname=sgroupname.get();

    /* loads vars.. */
    bload_str(comment,"comment");
    bload_cintq(filemark,"filemark");
    bload_cintq(length,"length");
    bload_cintq(speed,"speed");

    /* builds gui.. */
    bgui_str(comment,MSG_R(F_COMMENT));
    bgui_cint(filemark,MSG_U(F_TAPEFILEMARK,"File mark:"));
    bgui_cint(length,MSG_U(F_TAPELENGTH,"Length:"));
    bgui_cint(speed,MSG_U(F_TAPESPEED,"Speed:"));

    /* opens dialog.. */
    dialog_title.setfromf(MSG_U(T_TAPETYPESETTINGS,"Settings for tape type %s"), tapetype_name);
    my_selection=0;
    my_button=my_dialog.editmenu(dialog_title.get(), "", tapetypes_prop_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        /* save vars if requested so.. */
        bsave_str(comment,"comment");
        bsave_cintq(filemark,"filemark");
        bsave_cintq(length,"length");
        bsave_cintq(speed,"speed");

        update_file(parser_control);
        break;
    case MENU_DEL:
        remove_group(parser_control, groupname);
        update_file(parser_control);
        break;
    default:
        break;
    }
}

void select_tapetypes_window(const char *given_groupname, CONFIG_FILE &cf_amandaconf, t_parser_control *parser_control)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    my_dialog.newf_head("", MSG_U(T_TAPETYPESLISTHEAD,"tape types"));

    while(1){
        SSTRINGS list_of_groups;
//        MENU_STATUS my_button=(MENU_STATUS)0;
//        int         my_selection=0;
        int linecounter=0;

//        my_dialog.remove_all(); // cleans window
//        my_dialog.newf_head("", MSG_U(T_TAPETYPESLISTHEAD,"tape types"));

        fills_sstrings_with_selected_groups(parser_control, list_of_groups, "define tapetype ");
        dump_sstrings_to_list(my_dialog, list_of_groups, linecounter);

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(linecounter+1);

        my_button=my_dialog.editmenu(MSG_U(T_TAPETYPESLIST,"Tape types"), "", tapetypes_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            ask_name_add_group_entry(parser_control, list_of_groups,
                                     "define tapetype %s {",
                                     MSG_U(T_ADDINGNEWTAPETYPE,"Adding a new tape type..."),
                                     "", MSG_U(F_NAMEFORNEWTAPETYPE,"Name for the new tape type:"));
            break;
        default:
            {
                SSTRING whole_groupname;

                whole_groupname.setfromf("define tapetype %s {", list_of_groups.getitem(my_selection)->get());

                if(!group_heritages_are_a_problem(parser_control, "define tapetype ", whole_groupname.get()))
                    edit_specified_tapetype(parser_control, list_of_groups.getitem(my_selection)->get());
                break;
            }
        }
    }
}


