#pragma implementation
#include <stdlib.h>
#include <string.h>
#include <string.h>
#include <stdarg.h>
#include <assert.h>
#include "popen.h"
#include "sstream.h"

/* #Specification: SSTREAM object / principle
	The SSTREAM object provide a general object allowing writing an reading
	to a stream. The SSTREAM object is a virtual object. One must use
	the proper SSTREAM_XXX variation for the task at hand.
*/

#
PUBLIC VIRTUAL SSTREAM::~SSTREAM()
{
}


PUBLIC int SSTREAM::printf(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[20000];
	int ret = vsnprintf (buf,sizeof(buf)-1,ctl,list);
	puts (buf);
	va_end (list);
	return ret;
}

PUBLIC void SSTREAM::putch(char c)
{
	static char buf[2];
	buf[0] = c;
	puts (buf);
}
PUBLIC SSTREAM_BUF::SSTREAM_BUF()
{
	buf = NULL;
	cursize = maxsize = 0;
}
/*
	The SSTREAM_BUF reads or write to a memory buffer
*/
PUBLIC SSTREAM_BUF::SSTREAM_BUF(const char *_buf)
{
	buf = strdup(_buf);
	cursize = maxsize = 0;
}
PUBLIC SSTREAM_BUF::~SSTREAM_BUF()
{
	free (buf);
}
PUBLIC void SSTREAM_BUF::puts(const char *s)
{
	int len = strlen(s);
	if (len + cursize >= maxsize){
		maxsize += 10000;
		buf = (char*)realloc (buf,maxsize);
		assert (buf!=NULL);
	}
	strcpy (buf+cursize,s);
	cursize += len;
}

PUBLIC char *SSTREAM_BUF::gets(char *s, int maxs)
{
	char *ret = s;
	int len = 0;
	maxs--;		// Make sure we have room for the '\0';
	while (buf[cursize] != '\0'){
		char carac = buf[cursize++];
		if (len < maxs){
			*s++ = carac;
			len++;
		}
		if (carac == '\n') break;
	}
	*s = '\0';
	if (s == ret) ret = NULL;
	return ret;
}
/*
	Return the current position in the buffer
*/
PUBLIC long SSTREAM_BUF::getoffset()
{
	return cursize;
}


/*
	Return the buffer which contain all the output of the various
	puts.
*/
PUBLIC const char *SSTREAM_BUF::getbuf() const
{
	return buf != NULL ? buf : "";
}

/*
	The SSTREAM_FILE reads of writes to a FILE handle
*/
PUBLIC SSTREAM_FILE::SSTREAM_FILE(FILE *_f)
{
	f = _f;
}

PUBLIC void SSTREAM_FILE::puts(const char *s)
{
	fputs (s,f);
}

PUBLIC char *SSTREAM_FILE::gets(char *s, int maxs)
{
	return fgets (s,maxs,f);
}

PUBLIC long SSTREAM_FILE::getoffset()
{
	return ftell(f);
}


/*
	The SSTREAM_FILE_CFG reads of writes to a FILE_CFG handle
*/
PUBLIC SSTREAM_FILE_CFG::SSTREAM_FILE_CFG(FILE_CFG *_f)
{
	f = _f;
}

PUBLIC void SSTREAM_FILE_CFG::puts(const char *s)
{
	fputs (s,f);
}

PUBLIC char *SSTREAM_FILE_CFG::gets(char *s, int maxs)
{
	return fgets (s,maxs,f);
}

PUBLIC long SSTREAM_FILE_CFG::getoffset()
{
	return ftell(f);
}



PUBLIC void SSTREAM_NUL::puts(const char *)
{
}

PUBLIC char *SSTREAM_NUL::gets(char *, int )
{
	return NULL;
}

PUBLIC long SSTREAM_NUL::getoffset()
{
	return 0;
}

