#pragma interface
#ifndef POPEN_H
#define POPEN_H

#include <stdio.h>
#include <sys/types.h>

#ifndef MISC_H
	#include <misc.h>
#endif

class POPENFD{
	friend class POPENWAITS;
protected:
	struct {
		int in;		// stdin of the process
		FILE *fin;	// Used to send buffered output
		int out;	// stdout of the process
		int err;	// error
		int ctl;	// Special channel used to send a message
					// indicating the end of the process (avoid some races)
	}fds;
	SSTRING outbuf;
	SSTRING errbuf;
	bool bytesent;	// Flag telling us if at least one message
					// was sent to the application, so we must give
					// it some time to process it at close time.
	bool eof;
	/*~PROTOBEG~ POPENFD */
public:
	POPENFD (int handlein, int handleout);
protected:
	POPENFD (void);
public:
	void flush (void);
	FILE *getfout (void);
	void grabhandles (int &in, int &out, int &err);
	bool iseof (void);
	virtual bool isok (void);
	void loadout (const char *lines);
	int process (int ret_select,
		 fd_set&in,
		 int otherfd,
		 bool&ctlmsg);
	int readerr (char *line, int size);
private:
	void readif (fd_set *in,
		 int fd,
		 SSTRING&buf,
		 bool&ctlmsg);
	int readline (char *line, int size, SSTRING&buf);
public:
	int readout (char *line, int size);
	int readoutraw (char *data, int size);
	void send (const char *msg);
	void sendf (const char *ctl, ...);
	void seteof (void);
protected:
	void setfds (int fdin,
		 int fdout,
		 int fderr,
		 int fdctl);
public:
	int setup (fd_set&in, int maxfd, int otherfd);
	int wait (int timeout);
	int wait (int timeout, int otherfd);
protected:
	int wait (int timeout, int otherfd, bool&ctlmsg);
public:
	virtual ~POPENFD (void);
	/*~PROTOEND~ POPENFD */
};

#ifndef SSTREAM_H
	#include "sstream.h"
#endif

class SSTREAM_POPEN: public SSTREAM {
	int offset;
	POPENFD *pop;
	/*~PROTOBEG~ SSTREAM_POPEN */
public:
	SSTREAM_POPEN (POPENFD&_pop);
	long getoffset (void);
	char *gets (char *s, int maxsiz);
	void puts (const char *s);
	~SSTREAM_POPEN (void);
	/*~PROTOEND~ SSTREAM_POPEN */
};


class POPEN: public POPENFD{
	int pid;
	int status;
	int cur_dead;	// Current level of child_counter
	/*~PROTOBEG~ POPEN */
public:
	POPEN (const char *command);
	POPEN (const char *command,
		 int uid,
		 bool keepenv,
		 bool keepcwd);
	POPEN (const char *command, const char *args);
	POPEN (const char *command, const char *args, int uid);
	POPEN (const char *command, int uid);
private:
	void checksignal (void);
public:
	int close (void);
	void forget (void);
	int getstatus (void);
private:
	void init (const char *command,
		 int uid,
		 bool keepenv,
		 bool keepcwd);
	void initarg (const char *command,
		 const char *args,
		 int uid);
public:
	bool isok (void);
	void kill (void);
	int wait (int timeout);
	int wait (int timeout, int otherfd);
private:
	void waitend (void);
	void waitone (void);
public:
	~POPEN (void);
	/*~PROTOEND~ POPEN */
};

class POPENUSER: public POPEN{
	/*~PROTOBEG~ POPENUSER */
public:
	POPENUSER (const char *cmd);
	/*~PROTOEND~ POPENUSER */
};


class POPENWAIT: public ARRAY_OBJ{
public:
	POPENFD *po;
	int timeout;
	int retcode;
	int threadid;
	/*~PROTOBEG~ POPENWAIT */
public:
	POPENWAIT (POPENFD&_po, int _timeout);
	int getretcode (void);
	/*~PROTOEND~ POPENWAIT */
};

class POPENWAITS: public ARRAY{
	/*~PROTOBEG~ POPENWAITS */
public:
	POPENWAIT *getitem (int no)const;
	bool hasdata (void);
	int wait (void);
	/*~PROTOEND~ POPENWAITS */
};



extern const char popen_SOCKETHOLDER[];

#endif

