#include "diawxxt.h"

class mywxFrame: public wxFrame{
public:
	bool in_onsize;
	bool was_resized;
	int last_width,last_height;
	MFORM *tbonpaint[100];
	int nbonpaint;
public:
	MAINFORM *mf;
	mywxFrame (wxFrame *_parent, MAINFORM *_mf, int x, int y, long style)
		: wxFrame(_parent,NULL, x, y, 400, 300,style)
	{
		mf = _mf;
		in_onsize = false;
		was_resized = false;
		last_width = last_height = 0;
		nbonpaint = 0;
	}
	#if 0
	void OnPaint(){
		fprintf (stderr,"Fram OnPaint start\n");
		wxFrame::OnPaint();
		fprintf (stderr,"Fram OnPaint end\n");
	}
	#endif
    void PreResize(int x, int y, int width, int height){
		// fprintf (stderr,"MAINFORM::PreResize %d %d\n",width,height);
		if (!in_onsize && width > 0 && height > 0){
			int w,h;
			//GetSize (&w,&h);
			w = last_width;
			h = last_height;
			if (w != width || h != height){
				// fprintf (stderr,"MAINFORM::PreResize %d %d -> %d %d\n",w,h,width,height);
				was_resized = true;
				in_onsize = true;
				mf->resizeitems (width-w,height-h);
				in_onsize = false;
				last_width = width;
				last_height = height;
				#if 0
					fprintf (stderr,"nbonpaint %d\n",nbonpaint);
					for (int i=0; i<nbonpaint; i++) tbonpaint[i]->Real_OnPaint();
					fprintf (stderr,"nbonpaint done\n");
					nbonpaint = 0;
				#endif
			}else{
				// fprintf (stderr,"Same size %d %d\n",w,h);
			}
		}
		wxFrame::PreResize (x,y,width,height);
	}
	void record_onpaint( MFORM *f){
		if (in_onsize){
			tbonpaint[nbonpaint++] = f;
		}else{
			f->Real_OnPaint();
		}
	}
	Bool OnClose(){
		mf->dump();
		mf->escape();
		return FALSE;
	}
	#if 0
	void OnEvent(wxMouseEvent &event){
		fprintf (stderr,"onevent\n");
	}
	#endif
	#if 0
    void  OnMenuSelect(int id){
		fprintf (stderr,"menuselect id %d\n",id);
	}
	#endif
	#if 0
    void OnItemEvent(wxItem *item, wxMouseEvent &event){
		fprintf (stderr,"itemevent %p\n",item);
	}
	#endif
	void OnMenuCommand(int id){
		char path[300];
		formbase_getabspath(mf,path);
		remadmin_setcursor (cursor_wait);
		mf->dump();
		fprintf (mform_fout,"menubar %s %d\n",path,id);
		fflush (mform_fout);
		// fprintf (stderr,"menubar %s %d\n",path,id);
	}
	void SetSize (int x, int y, int w, int h)
	{
		if (w != -1) last_width = w;
		if (h != -1) last_height = h;
		wxFrame::SetSize (x,y,w,h);
	}
};

PUBLIC void MAINFORM::mainlayout()
{
	//fprintf (stderr,"mainlayout\n");
	doalllayout();
	int w,h;
	GetSize (&w,&h);
	wxMenuBar *bar = fram->GetMenuBar();
	int toph = 0;
	if (bar != NULL){
		int w;
		bar->GetSize(&w,&toph);
	}
	h += toph;
	#if 0
	if (reqx != -1){
		int diffx = reqx - w;
		int diffy = reqy - h;
		resizeitems (diffx,diffy);
		GetSize (&w,&h);
		h += toph;
		w = reqx;
		h = reqy;
	}
	#endif
	fram->SetSize (-1,-1,w,h);
	// fprintf (stderr,"fin mainlayout %d %d %d\n",w,h,toph);
}

PRIVATE void MAINFORM::init(
	wxFrame *_parent,
	int x,
	int y,
	long style)
{
	nopopup = false;
	enteraction = NULL;
	fram = new mywxFrame(_parent,this,x,y,style);
	Create (fram);
}
PRIVATE void MAINFORM::init(const char *type)
{
	int opt = wxSDI | wxDEFAULT_FRAME;
	int x = -1,y=-1;
	if (strcmp(type,"error")==0){
		x = 300; y=300;
		opt = wxTRANSIENT;
	}else if (strcmp(type,"notice")==0){
		x = 300; y=300;
		opt = wxTRANSIENT;
	}else if (strcmp(type,"popup")==0){
		x = 300; y=300;
		opt = wxTRANSIENT;
	}
	init (NULL,x,y,opt);
}
PUBLIC MAINFORM::MAINFORM(
	const char *_id,
	const char *_titre,
	const char *type)
	: MFORM (_id)
{
	init(type);
	setTitle (_titre);
	max_width = 800;
	const char *trigger = rem_getvar("htrigger");
	if (trigger != NULL) max_width = atoi(trigger);
}
PUBLIC MAINFORM::MAINFORM(const char *_id)
	: MFORM(_id)
{
	init("");
}
PUBLIC MAINFORM::MAINFORM(
	wxFrame *_parent,
	const char *_id,
	int x,
	int y,
	long style)
	: MFORM(_id)
{
	init(_parent,x,y,style);
}
PUBLIC MAINFORM::~MAINFORM()
{
	free (enteraction);
}

PUBLIC void MAINFORM::reset()
{
	MFORM::reset();
}


PUBLIC void MAINFORM::Popup()
{
	if (!nopopup){
		fram->in_onsize = true;
		// fprintf (stderr,"mainform popup %d\n",pref_width);
		if (pref_width == -1) mainlayout();
		fram->Fit();
		fram->Show(TRUE);
		fram->in_onsize = false;
	}
}
/*
	Turn off the Popup function until a show function is executed
	Normally, every time a sub-form is included in a MAINFORM, it requests
	a popup to redo the layout.
*/
PUBLIC void MAINFORM::waitpopup()
{
	nopopup = true;
}
PUBLIC void MAINFORM::setTitle(const char *title)
{
	fram->SetTitle((char*)title);
}
PUBLIC VIRTUAL void MAINFORM::dispose()
{
	wxPostDelete(fram);
}

PUBLIC void MAINFORM::show()
{
	nopopup = false;
	Popup();
}
PUBLIC void MAINFORM::hide()
{
	fram->Show(FALSE);
}

PUBLIC void MAINFORM::escape()
{
	remadmin_setcursor (cursor_wait);
	char path[300];
	formbase_getabspath(this,path);
	fprintf (mform_fout,"action %s X\n",path);
	fflush (mform_fout);
}

PUBLIC void MAINFORM::setenteraction(const char *str)
{
	free (enteraction);
	enteraction = strdup(str);
}
PUBLIC const char *MAINFORM::getenteraction()
{
	return enteraction;
}
/*
	Select the mouse cursor
*/
PUBLIC void MAINFORM::setcursor(wxCursor *cur)
{
	fram->SetCursor(cur);
}

PUBLIC wxFrame *MAINFORM::getframe()
{
	return fram;
}

PUBLIC void MAINFORM::record_onpaint( MFORM *f)
{
	fram->record_onpaint(f);
}

PUBLIC bool MAINFORM::was_resized()
{
	return fram->was_resized;
}

