class extrstr{
	String s;
	int offset;
	int len;
	public extrstr(String s){
		this.s = s;
		offset = 0;
		len = s.length();
	}
	public void skip(){
		while (true){
			if (offset == len) break;
			char c = s.charAt(offset);
			if (c > ' ') break;
			offset++;
		}
	}
	// Jump one character in the string
	public void skipone(){
		if (offset < len) offset++;
	}
	// Get the next word. A word start with a non-white and end
	// at a white char
	public String nextword(){
		String ret = "";
		skip();		
		if (offset < len){
			int start = offset;
			while (true){
				if (offset == len) break;
				char c = s.charAt(offset);
				if (c <= ' ') break;
				offset++;
			}
			ret = s.substring (start,offset);
		}
		return ret;
	}
	// Get the next "word", but understand quoting
	// The quote will be removed
	public String nextwordq(){
		skip();		
		String ret = "";
		if (offset < len && s.charAt(offset) == '"'){
			offset++;
			while (true){
				if (offset == len) break;
				char c = s.charAt(offset);
				if (c == '"'){
					break;
				}else if (c == '\\' && offset < len-1){
					offset++;
					ret += s.charAt(offset);
				}else{
					ret += c;
				}
				offset++;
			}
			if (offset < len) offset++;
		}else{
			ret = nextword();
		}
		return ret;
	}
	public int nextint(){
		String str = nextword();
		return Integer.parseInt(str);
	}
	public String getend(){
		return s.substring (offset);
	}
	public String getendskip(){
		skip();
		return s.substring (offset);
	}
	public int getparms(String tb[]){
		int nb = 0;
		for (int i=0; i<100; i++){
			skip();		
			if (offset >= len){
				break;
			}else{
				tb[nb++] = nextwordq();
			}
		}
		return nb;
	}
	public static int splitpath (String path, String tb[]){
		int ret = 0;
		int len = path.length();
		int offset = 0;
		int start = 0;
		while (offset < len){
			if (path.charAt(offset)== '.'){
				tb[ret++] = new String(path.substring(start,offset));
				start = offset+1;
			}
			offset++;
		}
		if (offset > start){
			tb[ret++] = new String(path.substring(start,offset));
		}
		return ret;
	}
}

